<?php

namespace CorporateTrainingBundle\Biz\UserGroup\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\UserGroup\Dao\MemberDao;

class MemberDaoImpl extends AdvancedDaoImpl implements MemberDao
{
    protected $table = 'user_group_member';

    public function deleteByGroupId($groupId)
    {
        return $this->db()->delete($this->table(), ['groupId' => $groupId]);
    }

    public function deleteByMemberIdAndMemberType($memberId, $memberType)
    {
        return $this->db()->delete($this->table(), ['memberId' => $memberId, 'memberType' => $memberType]);
    }

    public function getByGroupIdAndMemberIdAndMemberType($groupId, $memberId, $memberType)
    {
        return $this->getByFields(
            [
                'groupId' => $groupId,
                'memberId' => $memberId,
                'memberType' => $memberType,
            ]
        );
    }

    public function findByGroupId($groupId)
    {
        $sql = "SELECT * FROM {$this->table} WHERE groupId = ?";

        return $this->db()->fetchAll($sql, [$groupId]);
    }

    public function findByGroupIdAndMemberType($groupId, $memberType)
    {
        $sql = "SELECT * FROM {$this->table} WHERE groupId = ? AND memberType = ?";

        return $this->db()->fetchAll($sql, [$groupId, $memberType]);
    }

    public function findByMemberIdAndMemberType($memberId, $memberType)
    {
        $sql = "SELECT * FROM {$this->table} WHERE memberId = ? AND memberType = ?";

        return $this->db()->fetchAll($sql, [$memberId, $memberType]);
    }

    public function declares()
    {
        return [
            'timestamps' => ['createdTime', 'updatedTime'],
            'serializes' => [],
            'orderbys' => ['id'],
            'conditions' => [
                'groupId = :groupId',
                'memberId = :memberId',
                'memberId <> :exitMemberId',
                'memberType = :memberType',
                'memberId IN ( :memberIds)',
            ],
        ];
    }
}
