<?php

namespace CorporateTrainingBundle\Controller\Admin;

use AppBundle\Controller\Admin\BaseController;
use Biz\System\Service\SettingService;
use Symfony\Component\HttpFoundation\Request;

class MailSettingController extends BaseController
{
    public function setAction(Request $request)
    {
        $mailNotification = $this->getSettingService()->get('mail_notification', []);

        $default = [
            'enroll' => 0,
            'post_assign' => 0,
            'project_plan_progress' => 0,
            'live_course' => 0,
            'project_plan_content' => 0,
            'my_task' => 0,
            'exam' => 0,
        ];

        $mailNotification = array_merge($default, $mailNotification);

        if ('POST' === $request->getMethod()) {
            $mailNotification = $request->request->all();

            $this->getSettingService()->set('mail_notification', $mailNotification);
            $this->setFlashMessage('success', 'site.save.success');
        }

        return $this->render(
            'CorporateTrainingBundle::admin/mail/set.html.twig',
            [
                'mailNotification' => $mailNotification,
            ]
        );
    }

    public function previewTemplateAction(Request $request, $type)
    {
        return $this->render(
            'CorporateTrainingBundle::admin/mail/preview-modal.html.twig',
            $this->getTemplateByType($type)
        );
    }

    protected function getTemplateByType($type)
    {
        switch ($type) {
            case 'enroll':
                return $this->getEnrollTemplate();
            case 'post_assign':
                return $this->getPostAssignTemple();
            case 'project_plan_progress':
                return $this->getProjectPlanProgressTemple();
            case 'live_course':
                return $this->getLiveCourseTemple();
            case 'project_plan_content':
                return $this->getProjectPlanContentTemple();
            case 'my_task':
                return $this->getMyTaskTemple();
            case 'exam':
                return $this->getExamTemple();
            case 'qa':
                return $this->getQATemple();
            case 'offline_class_publish':
                return $this->getOfflineClassPublishTemplate();
            default:
                return [];
        }
    }

    protected function getEnrollTemplate()
    {
        return [
            'title' => 'admin.mail_setting.mail_notification.preview.temp.enroll_result',
            'templates' => [
                'offlineActivityAddMember' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.temp.enroll_result.1.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.temp.enroll_result.1.message',
                ],
                'offlineActivityApproveReject' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.temp.enroll_result.2.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.temp.enroll_result.2.message',
                ],
                'projectPlanEnrollResult' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.temp.enroll_result.3.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.temp.enroll_result.3.message',
                ],
                'projectPlanApproveReject' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.temp.enroll_result.4.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.temp.enroll_result.4.message',
                ],
            ],
        ];
    }

    protected function getPostAssignTemple()
    {
        return [
            'title' => 'admin.mail_setting.mail_notification.preview.temp.post_course_update',
            'templates' => [
                'postCourseAdd' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.temp.post_course_update.1.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.temp.post_course_update.1.message',
                ],
            ],
        ];
    }

    protected function getProjectPlanProgressTemple()
    {
        return [
            'title' => 'admin.mail_setting.mail_notification.preview.temp.project',
            'templates' => [
                'projectPlanOnlineExamStart' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.temp.project.1.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.temp.project.1.message',
                ],
                'projectPlanOfflineExamStart' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.temp.project.2.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.temp.project.2.message',
                ],
                'offlineCourseTask' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.temp.project.3.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.temp.project.3.message',
                ],
                'offlineCourseQuestionnaire' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.temp.project.4.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.temp.project.4.message',
                ],
            ],
        ];
    }

    protected function getLiveCourseTemple()
    {
        return [
            'title' => 'admin.mail_setting.mail_notification.preview.live_course',
            'templates' => [
                'projectPlanUpdate' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.live_course.1.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.live_course.1.message',
                ],
            ],
        ];
    }

    protected function getProjectPlanContentTemple()
    {
        return [
            'title' => 'admin.mail_setting.mail_notification.preview.project_plan_content',
            'templates' => [
                'projectPlanUpdate' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.project_plan_content.1.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.project_plan_content.1.message',
                ],
            ],
        ];
    }

    protected function getMyTaskTemple()
    {
        return [
            'title' => 'admin.mail_setting.mail_notification.preview.my_task',
            'templates' => [
                'examAssign' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.my_task.1.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.my_task.1.message',
                ],
                'projectPlanAssign' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.my_task.2.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.my_task.2.message',
                ],
            ],
        ];
    }

    protected function getExamTemple()
    {
        return [
            'title' => 'admin.mail_setting.mail_notification.preview.exam',
            'templates' => [
                'examResult' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.exam.1.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.exam.1.message',
                ],
            ],
        ];
    }

    protected function getQATemple()
    {
        return [
            'title' => 'admin.mail_setting.mail_notification.preview.qa',
            'templates' => [
                'qaPostCreate' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.qa.1.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.qa.1.message',
                ],
                'qaPostFollow' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.qa.2.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.qa.2.message',
                ],
            ],
        ];
    }

    protected function getOfflineClassPublishTemplate()
    {
        return [
            'title' => 'admin.mail_setting.mail_notification.preview.offline_class_publish',
            'templates' => [
                'offlineClassPublish' => [
                    'title' => 'admin.mail_setting.mail_notification.preview.offline_class_publish.1.title',
                    'message' => 'admin.mail_setting.mail_notification.preview.offline_class_publish.1.message',
                ],
            ],
        ];
    }

    /**
     * @return SettingService
     */
    private function getSettingService()
    {
        return $this->createService('System:SettingService');
    }
}
