<?php

namespace CorporateTrainingBundle\Controller\Admin\Train;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Common\Paginator;
use AppBundle\Controller\Admin\BaseController;
use Biz\Taxonomy\Service\CategoryService;
use CorporateTrainingBundle\Biz\Focus\Service\FocusService;
use ExamPlugin\Biz\Exam\Service\ExamService;
use SurveyPlugin\Biz\Survey\Service\SurveyService;
use Symfony\Component\HttpFoundation\Request;

class MyWorksController extends BaseController
{
    // 分页每一页的数量
    const PER_PAGE = 20;

    //1、直播授课列表 ，开始时间降序。我的教学，普通课程和直播课程中的任务列表，添加了直播模块的task
    public function liveAction(Request $request)
    {
        $nowTime = time();
        $conditions = $request->request->all();
        $conditions = $this->filterConditions($conditions);
        $currentUser = $this->getCurrentUser();
        $members = $this->getMemberService()->findTeacherMembersByUserId($currentUser['id']);
        $myTeachingCourseIds = !empty(ArrayToolkit::column($members, 'courseId')) ? ArrayToolkit::column($members, 'courseId') : [-1];

        $conditions = array_merge(
            $conditions,
            [
                'courseIds' => $myTeachingCourseIds,
                'status' => 'published',
                'type' => 'live',
            ]
        );
        $paginator = new Paginator(
            $this->get('request'),
            $this->getCourseTaskService()->countTasks($conditions),
            self::PER_PAGE
        );
        $paginator->setBaseUrl($this->generateUrl('admin_train_teach_manage_my_works_live'));

        if (!$currentUser->hasPermission('admin_course_show') && !($currentUser->hasPermission('admin_train_teach_manage_my_teaching_courses_manage') && $currentUser->hasPermission('admin_train_teach_manage_my_teaching_classrooms_manage') && $currentUser->hasPermission('admin_train_teach_manage_my_teaching_offline_courses_manage'))) {
            $liveCourse = [];
        } else {
            $liveCourse = $this->getCourseTaskService()->searchTasks(
                $conditions,
                ['startTime' => 'DESC'],
                $paginator->getOffsetCount(),
                $paginator->getPerPageCount()
            );

            foreach ($liveCourse as &$value) {
                $value['startTimeToNowAbs'] = abs($value['startTime'] - $nowTime);
            }
            $liveCourse = $this->arrayMultiSort($liveCourse);
        }

        return $this->render(
            'CorporateTrainingBundle::admin/train/teach-manage/my-works/live.html.twig', [
                'liveCourse' => $liveCourse,
                'filter' => 'live',
                'paginator' => $paginator,
            ]
        );
    }

    // 2、线上考试
    public function onlineExamAction(Request $request)
    {
        $nowTime = time();
        $conditions = $request->request->all();
        $conditions = $this->filterConditions($conditions);

        $currentUser = $this->getCurrentUser();
        $conditions = array_merge(
            $conditions,
            [
                'status' => 'published',
                'createdUserId' => $currentUser['id'],
            ]
        );

        $paginator = new Paginator(
            $this->get('request'),
            $this->getExamService()->countExams($conditions),
            self::PER_PAGE
        );

        $paginator->setBaseUrl($this->generateUrl('admin_train_teach_manage_my_works_online_exam'));
        $onlineExam = $this->getExamService()->searchExams(
            $conditions,
            ['startTime' => 'DESC'],
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );

        foreach ($onlineExam as &$value) {
            $value['startTimeToNowAbs'] = abs($value['startTime'] - $nowTime);
        }
        $onlineExam = $this->arrayMultiSort($onlineExam);

        return $this->render(
            'CorporateTrainingBundle::admin/train/teach-manage/my-works/online_exam.html.twig', [
                'onlineExam' => $onlineExam,
                'filter' => 'online_exam',
                'paginator' => $paginator,
            ]
        );
    }

    //3、线下活动列表，开始时间降序
    public function offlineActivityAction(Request $request)
    {
        $nowTime = time();
        $conditions = $request->request->all();
        $conditions = $this->filterConditions($conditions);

        $currentUser = $this->getCurrentUser();
        $conditions = array_merge(
            $conditions,
            [
                'creator' => $currentUser['id'],
                'status' => 'published',
            ]
        );

        $paginator = new Paginator(
            $this->get('request'),
            $this->getOfflineActivityService()->countOfflineActivities($conditions),
            self::PER_PAGE
        );
        $paginator->setBaseUrl($this->generateUrl('admin_train_teach_manage_my_works_offline_activity'));

        if (!$currentUser->hasPermission('admin_offline_activity') && !$currentUser->hasPermission('admin_data')) {
            $offlineActivity = [];
        } else {
            $offlineActivity = $this->getOfflineActivityService()->searchOfflineActivities(
                $conditions,
                ['startTime' => 'DESC'],
                $paginator->getOffsetCount(),
                $paginator->getPerPageCount()
            );

            foreach ($offlineActivity as &$value) {
                $value['startTimeToNowAbs'] = abs($value['startTime'] - $nowTime);
            }

            $offlineActivity = $this->arrayMultiSort($offlineActivity);
        }

        return $this->render(
            'CorporateTrainingBundle::admin/train/teach-manage/my-works/offline_activity.html.twig', [
                'offlineActivity' => $offlineActivity,
                'filter' => 'offline_activity',
                'paginator' => $paginator,
            ]
        );
    }

    //4、线下课程，开始时间降序
    public function offlineCoursesAction(Request $request)
    {
        $nowTime = time();
        $currentUser = $this->getCurrentUser();
        $conditions = $request->request->all();
        $conditions = $this->filterConditions($conditions);

        $conditions = array_merge(
            $conditions,
            [
                'teacherId' => $currentUser['id'],
                'status' => 'published',
            ]
        );

        $paginator = new Paginator(
            $request,
            $this->getOfflineCourseService()->countPublishedOfflineClassOrProjectPlanOfflineCourses($conditions),
            self::PER_PAGE
        );
        $paginator->setBaseUrl($this->generateUrl('admin_train_teach_manage_my_works_offline_courses'));

        $offlineCourses = $this->getOfflineCourseService()->searchPublishedOfflineClassOrProjectPlanOfflineCourses(
            $conditions,  // daoImpl层直接做了 startTime => DESC 排序
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );

        foreach ($offlineCourses as &$value) {
            $value['startTimeToNowAbs'] = abs($value['startTime'] - $nowTime);
        }

        $offlineCourses = $this->arrayMultiSort($offlineCourses);

        return $this->render(
            'CorporateTrainingBundle::admin/train/teach-manage/my-works/offline_courses.html.twig', [
                'offlineCourses' => $offlineCourses,
                'filter' => 'offline_courses',
                'paginator' => $paginator,
            ]
        );
    }

    // 5线下考试包括 线下课程开班 和 培训项目
    public function offLineExamAction(Request $request)
    {
        $nowTime = time();
        $currentUser = $this->getCurrentUser();
        $conditions = $request->request->all();
        $conditions = $this->filterConditions($conditions);

        $conditions = array_merge(
            $conditions,
            [
                'creator' => $currentUser['id'],
                'status' => 'published',
            ]
        );

        $paginator = new Paginator(
            $request,
            $this->getOfflineExamService()->countOfflineExams($conditions),
            self::PER_PAGE
        );
        $paginator->setBaseUrl($this->generateUrl('admin_train_teach_manage_my_works_offline_exam'));

        $offLineExam = $this->getOfflineExamService()->searchOfflineExams(
            $conditions,
            ['startTime' => 'DESC'],
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );

        foreach ($offLineExam as &$value) {
            $value['startTimeToNowAbs'] = abs($value['startTime'] - $nowTime);
        }

        $offLineExam = $this->arrayMultiSort($offLineExam);

        return $this->render(
            'CorporateTrainingBundle::admin/train/teach-manage/my-works/offline_exam.html.twig', [
                'offLineExam' => $offLineExam,
                'filter' => 'offline_exam',
                'paginator' => $paginator,
            ]
        );
    }

    //6、问卷列表，开始时间降序
    public function surveyManageAction(Request $request)
    {
        $nowTime = time();
        $currentUser = $this->getCurrentUser();
        $conditions = $request->request->all();
        $conditions = $this->filterConditions($conditions);

        $conditions = array_merge(
            $conditions,
            [
                'createdUserId' => $currentUser['id'],
                'status' => 'published',
                'type' => 'questionnaire',
            ]
        );

        $paginator = new Paginator(
            $request,
            $this->getSurveyService()->countSurveys($conditions),
            self::PER_PAGE
        );
        $paginator->setBaseUrl($this->generateUrl('admin_train_teach_manage_my_works_survey_manage'));

        $surveyManage = $this->getSurveyService()->searchSurveys(
            $conditions,
            ['startTime' => 'DESC'],
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );

        foreach ($surveyManage as &$value) {
            $value['startTimeToNowAbs'] = abs($value['startTime'] - $nowTime);
        }

        $surveyManage = $this->arrayMultiSort($surveyManage);

        return $this->render(
            'CorporateTrainingBundle::admin/train/teach-manage/my-works/survey_manage.html.twig', [
                'surveyManage' => $surveyManage,
                'filter' => 'survey_manage',
                'paginator' => $paginator,
            ]
        );
    }

    // 首页预览的三个今日工作
    public function myWorksAction(Request $request)
    {
        $nowTime = time();
        $myWorks = $this->getFocusService()->findFocusToday($nowTime);

        foreach ($myWorks as &$value) {
            $value['startTimeToNowAbs'] = abs($value['startTime'] - $nowTime);
        }
        $myWorks = array_slice($this->arrayMultiSort($myWorks), 0, 3);

        return $this->render(
            'CorporateTrainingBundle::admin/default/to-do-work.html.twig', [
                'myWorks' => $myWorks,
            ]
        );
    }

    /**
     * @param string $filter
     *
     * @return array
     */
    protected function arrayMultiSort(array $array, $filter = 'startTimeToNowAbs')
    {
        $startTimeToNowAbsColumn = array_column($array, $filter);
        array_multisort($startTimeToNowAbsColumn, SORT_ASC, $array);

        return $array;
    }

    protected function getCourseTaskService()
    {
        return $this->createService('Task:TaskService');
    }

    protected function filterConditions($conditions)
    {
        $conditions['orgIds'] = $this->prepareOrgIds($conditions);

        if (!empty($conditions['categoryId'])) {
            $categorIds = $this->getCategoryService()->findCategoryChildrenIds($conditions['categoryId']);
            $categorIds[] = $conditions['categoryId'];
            $conditions['categoryIds'] = $categorIds;
            unset($conditions['categoryId']);
        }

        return $conditions;
    }

    /**
     * @return CategoryService
     */
    protected function getCategoryService()
    {
        return $this->createService('Taxonomy:CategoryService');
    }

    /**
     * @return ExamService
     */
    protected function getExamService()
    {
        return $this->createService('ExamPlugin:Exam:ExamService');
    }

    /**
     * @return OfflineActivityService
     */
    protected function getOfflineActivityService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineActivity:OfflineActivityService');
    }

    /**
     * @return OfflineCourseService
     */
    protected function getOfflineCourseService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }

    protected function getOfflineExamService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineExam:OfflineExamService');
    }

    /**
     * @return SurveyService
     */
    protected function getSurveyService()
    {
        return $this->createService('SurveyPlugin:Survey:SurveyService');
    }

    /**
     * @return FocusService
     */
    protected function getFocusService()
    {
        return $this->createService('CorporateTrainingBundle:Focus:FocusService');
    }

    protected function getMemberService()
    {
        return $this->createService('CorporateTrainingBundle:Course:MemberService');
    }
}
