<?php

namespace CorporateTrainingBundle\Controller\Classroom;

use AppBundle\Controller\Classroom\ClassroomManageController as BaseController;
use Symfony\Component\HttpFoundation\Request;

class ClassroomManageController extends BaseController
{
    public function preBatchRemoveMemberAction(Request $request, $classroomId)
    {
        $ids = $request->request->get('ids');
        $count = $this->getClassroomService()->searchMemberCount(array('ids' => $ids, 'classroomId' => $classroomId));

        return $this->createJsonResponse(array('count' => $count));
    }

    public function batchRemoveMemberAction(Request $request, $classroomId)
    {
        $ids = $request->request->get('ids');
        $members = $this->getClassroomService()->searchMembers(
            array('ids' => $ids, 'classroomId' => $classroomId),
            array('createdTime' => 'DESC'),
            0,
            10
        );
        $status = 'finish';
        if (!empty($members)) {
            foreach ($members as $key => $member) {
                $this->getClassroomService()->removeStudent(
                    $classroomId,
                    $member['userId'],
                    array(
                        'reason' => 'site.remove_by_batch',
                        'reason_type' => 'remove',
                    )
                );
            }
            $status = 'continue';
        }

        return $this->createJsonResponse(array('status' => $status, 'success' => true));
    }
}
