<?php

namespace CorporateTrainingBundle\Controller;

use AppBundle\Common\Exception\AccessDeniedException;
use AppBundle\Controller\BaseController;
use CorporateTrainingBundle\Biz\Enroll\Service\EnrollRecordService;
use Symfony\Component\HttpFoundation\Request;

class EnrollController extends BaseController
{
    public function cancelEnrollAction(Request $request, $targetId, $targetType)
    {
        $this->getEnrollStrategyContext()->createStrategy($targetType)->cancelEnroll($targetId, $this->getCurrentUser()->getId());

        return $this->createJsonResponse(true);
    }

    public function verifyEnrollmentAction(Request $request, $id, $targetType)
    {
        $record = $this->getEnrollRecordService()->getEnrollRecord($id);

        if (!$this->getEnrollStrategyContext()->createStrategy($targetType)->canManageResource($record['targetId'])) {
            throw new AccessDeniedException('project_plan.message.can_not_manage_message');
        }

        if ('POST' === $request->getMethod()) {
            $fields = $request->request->all();
            $this->getEnrollStrategyContext()->createStrategy($targetType)->verifyEnrollment($record['targetId'], [$record['id']], $fields['verifyStatus'], $fields);

            return $this->createJsonResponse(true);
        }

        return $this->render('@CorporateTraining/enroll/verify/verify-enrollment.html.twig', [
            'record' => $record,
            'targetType' => $targetType,
        ]);
    }

    public function batchVerifyEnrollmentAction(Request $request, $targetId, $targetType)
    {
        if (!$this->getEnrollStrategyContext()->createStrategy($targetType)->canManageResource($targetId)) {
            throw new AccessDeniedException('project_plan.message.can_not_manage_message');
        }

        if ('POST' === $request->getMethod()) {
            $fields = $request->request->all();
            $status = empty($fields['status']) ? 'rejected' : $fields['status'];
            $recordIds = explode(',', $fields['recordIds']);

            if (!empty($recordIds)) {
                $this->getEnrollStrategyContext()->createStrategy($targetType)->verifyEnrollment($targetId, $recordIds, $status);
            }

            return $this->createJsonResponse(true);
        }

        return $this->render(
            '@CorporateTraining/enroll/verify/batch-verify-modal.html.twig', [
                'targetId' => $targetId,
                'targetType' => $targetType,
            ]
        );
    }

    public function queueBecomeMemberAction(Request $request, $targetId, $targetType, $recordId)
    {
        if (!$this->getEnrollStrategyContext()->createStrategy($targetType)->canManageResource($targetId)) {
            throw new AccessDeniedException('project_plan.message.can_not_manage_message');
        }
        $this->getEnrollStrategyContext()->createStrategy($targetType)->queueListBecomeMember($targetId, [$recordId]);

        return $this->createJsonResponse(true);
    }

    protected function getEnrollStrategyContext()
    {
        return $this->getBiz()['enroll_strategy_context'];
    }

    /**
     * @return EnrollRecordService
     */
    protected function getEnrollRecordService()
    {
        return $this->createService('CorporateTrainingBundle:Enroll:EnrollRecordService');
    }
}
