<?php

namespace CorporateTrainingBundle\Controller\OfflineCourse;

use AppBundle\Controller\BaseController;
use Endroid\QrCode\QrCode;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class OfflineCourseController extends BaseController
{
    public function signInAction(Request $request, $offlineCourseId)
    {
        $course = $this->getOfflineCourseService()->getOfflineCourse($offlineCourseId);

        if ('app' == $request->query->get('origin')) {
            $nickname = $request->query->get('nickname');

            return $this->signInApp($nickname, $course);
        }

        if ($course['endTime'] < time()) {
            return $this->render('@CorporateTraining/offline-course/sign-in/error.html.twig',
                [
                    'message' => $this->trans('offline_course.sign_in.message.end'),
                ]
            );
        }

        $user = $this->getCurrentUser();

        if (!$this->isMember($offlineCourseId, $user['id'])) {
            return $this->render('@CorporateTraining/offline-course/sign-in/error.html.twig',
                [
                    'offlineCourseId' => $offlineCourseId,
                    'message' => $this->getNotMemberMessage($offlineCourseId),
                ]
            );
        }

        $signTaskNum = $this->getOfflineCourseTaskService()->countTasks(['offlineCourseId' => $offlineCourseId, 'type' => 'sign', 'startTime_LE' => time(), 'endTime_GE' => time()]);
        if (!empty($signTaskNum)) {
            $this->getOfflineCourseTaskService()->signIn($user['id'], $course);

            return $this->render('@CorporateTraining/offline-course/sign-in/success.html.twig');
        }

        $signTaskNum = $this->getOfflineCourseTaskService()->countTasks(['offlineCourseId' => $offlineCourseId, 'type' => 'sign', 'startTime_GE' => time()]);
        if (empty($signTaskNum)) {
            return $this->render('@CorporateTraining/offline-course/sign-in/error.html.twig', [
                'offlineCourseId' => $offlineCourseId,
                'message' => $this->trans('offline_course.sign_in.message.over'),
            ]);
        } else {
            return $this->render('@CorporateTraining/offline-course/sign-in/error.html.twig', [
                'offlineCourseId' => $offlineCourseId,
                'message' => $this->trans('offline_course.sign_in.message.not_start'),
            ]);
        }
    }

    public function viewSurveyQrcodeAction(Request $request, $taskId)
    {
        $task = $this->getOfflineCourseTaskService()->getTask($taskId);
        $course = $this->getOfflineCourseService()->getOfflineCourse($task['offlineCourseId']);
        $projectPlanItem = $this->getProjectPlanService()->getProjectPlanItemByTargetIdAndTargetType($course['id'], 'offline_course');
        $activity = $this->getActivityService()->getActivity($task['activityId']);

        return $this->render('offline-course/do-survey/qr-code.html.twig',
            [
                'course' => $course,
                'task' => $task,
                'surveyId' => $activity['mediaId'],
                'projectPlanId' => $projectPlanItem['projectPlanId'],
            ]
        );
    }

    public function doSurveyQrcodeAction(Request $request)
    {
        $surveyId = $request->query->get('surveyId');
        $projectPlanId = $request->query->get('projectPlanId');
        $taskId = $request->query->get('taskId');

        $url = $this->generateUrl('can_do_survey', ['surveyId' => $surveyId, 'projectPlanId' => $projectPlanId, 'taskId' => $taskId], true);
        $qrCode = new QrCode();
        $qrCode->setText($url);
        $img = $qrCode->get('png');

        $headers = [
            'Content-Type' => 'image/png',
            'Content-Disposition' => 'inline; filename="image.png"',
        ];

        return new Response($img, 200, $headers);
    }

    protected function signInApp($nickname, $course)
    {
        $user = $this->getUserService()->getUserByNickname($nickname);

        if (!$this->isMember($course['id'], $user['id'])) {
            return $this->createJsonResponse(['success' => false, 'message' => $this->getNotMemberMessage($course['id'])]);
        }

        if ($course['endTime'] < time()) {
            return  $this->createJsonResponse(['success' => false, 'message' => $this->trans('offline_course.sign_in.message.end')]);
        }

        $this->getOfflineCourseTaskService()->signIn($user['id'], $course);

        return $this->createJsonResponse(['success' => true, 'message' => $this->trans('offline_course.sign_in.success')]);
    }

    protected function isMember($offlineCourseId, $userId)
    {
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($offlineCourseId);

        if ('projectPlan' == $offlineCourse['targetType']) {
            $member = $this->getProjectPlanMemberService()->getProjectPlanMemberByUserIdAndProjectPlanId($userId, $offlineCourse['targetId']);
            if (!empty($member)) {
                return true;
            }
        }

        if ('offlineClass' == $offlineCourse['targetType']) {
            $member = $this->getOfflineClassMemberService()->getOfflineClassMemberByUserIdAndOfflineClassId($userId, $offlineCourse['targetId']);
            if (!empty($member)) {
                return true;
            }
        }

        return false;
    }

    protected function getNotMemberMessage($offlineCourseId)
    {
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($offlineCourseId);

        if ('projectPlan' == $offlineCourse['targetType']) {
            return $this->trans('project_plan.can_do_exam.message.no_permission');
        }

        if ('offlineClass' == $offlineCourse['targetType']) {
            return $this->trans('offline_class.can_do_exam.message.no_permission');
        }
    }

    protected function getActivityService()
    {
        return $this->createService('Activity:ActivityService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\MemberServiceImpl
     */
    protected function getProjectPlanMemberService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\ProjectPlanServiceImpl
     */
    protected function getProjectPlanService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\OfflineCourseServiceImpl
     */
    protected function getOfflineCourseService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }

    /**
     * @return \OfflineCourseProPlugin\Biz\OfflineClass\Service\MemberService
     */
    protected function getOfflineClassMemberService()
    {
        return $this->createService('OfflineCourseProPlugin:OfflineClass:MemberService');
    }
}
