<?php

namespace CorporateTrainingBundle\Controller\OfflineCourse;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Controller\BaseController;
use Codeages\Biz\Framework\Service\Exception\NotFoundException;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\MemberService;
use Symfony\Component\HttpFoundation\Request;

class OfflineCourseManageController extends BaseController
{
    protected $types = [
                'offline_class' => 'CorporateTrainingBundle:OfflineCourse\ResourceManage\OfflineClass',
                'project_plan' => 'CorporateTrainingBundle:OfflineCourse\ResourceManage\ProjectPlan',
                ];

    public function attendanceManageAction(Request $request, $id, $type)
    {
        $this->checkResourceType($type);
        $controller = $this->types[$type];

        return $this->forward("{$controller}:attendanceManage", [
            'id' => $id,
        ]);
    }

    public function homeworkManageAction(Request $request, $taskId, $type)
    {
        $this->checkResourceType($type);
        $controller = $this->types[$type];

        return $this->forward("{$controller}:homeworkManage", [
            'taskId' => $taskId,
        ]);
    }

    public function attendAction(Request $request, $id, $userId)
    {
        $offlineCourse = $this->getOfflineCourseService()->tryManageOfflineCourse($id);

        if ($request->isMethod('POST')) {
            $this->getOfflineCourseMemberService()->batchAttend($id, [$userId], $request->request->get('status', 'none'));
        }
        $tasks = $this->getOfflineCourseTaskService()->searchTasks(['offlineCourseId' => $id, 'type' => 'sign'], [], 0, PHP_INT_MAX);
        $taskIds = empty($tasks) ? [-1] : ArrayToolkit::column($tasks, 'id');

        return $this->render('@CorporateTraining/offline-course/resource-manage/attendance-manage/update-modal.html.twig',
            [
                'user' => $this->getUserService()->getUser($userId),
                'userProfiles' => $this->getUserService()->getUserProfile($userId),
                'taskResults' => $this->getOfflineCourseTaskResultService()->searchTaskResults(['offlineCourseId' => $id, 'taskIds' => $taskIds, 'type' => 'sign', 'userId' => $userId], [], 0, count($taskIds)),
                'taskCount' => count($tasks),
                'member' => $this->getOfflineCourseMemberService()->getMemberByOfflineCourseIdAndUserId($id, $userId),
                'offlineCourse' => $offlineCourse,
            ]
        );
    }

    public function batchAttendAction(Request $request, $id)
    {
        $offlineCourse = $this->getOfflineCourseService()->tryManageOfflineCourse($id);

        if ($request->isMethod('POST')) {
            $userIds = $request->request->get('ids');
            $userIds = explode(',', $userIds);

            $this->getOfflineCourseMemberService()->batchAttend($id, $userIds, $request->request->get('status', 'none'));

            return $this->createJsonResponse(true);
        }

        return $this->render('@CorporateTraining/offline-course/resource-manage/attendance-manage/batch-update-modal.html.twig',
            [
                'offlineCourse' => $offlineCourse,
            ]
        );
    }

    public function homeworkCheckAction(Request $request, $resultId)
    {
        $taskResult = $this->getOfflineCourseTaskService()->getTaskResult($resultId);
        if (!$this->getOfflineCourseService()->tryManageOfflineCourse($taskResult['offlineCourseId'])) {
            return $this->createMessageResponse('error', 'offline_course.message.no_permission');
        }

        if ('POST' == $request->getMethod()) {
            $homeworkStatus = $request->request->get('homeworkStatus');
            $this->getOfflineCourseTaskService()->batchCheckHomework($taskResult['taskId'], [$taskResult['userId']], $homeworkStatus);

            return $this->createJsonResponse(true);
        }

        return $this->render('@CorporateTraining/offline-course/resource-manage/homework-manage/check.html.twig', [
            'taskResult' => $taskResult,
        ]);
    }

    public function homeworkBatchCheckAction(Request $request, $taskId)
    {
        $task = $this->getOfflineCourseTaskService()->getTask($taskId);
        $this->getOfflineCourseService()->tryManageOfflineCourse($task['offlineCourseId']);
        if ('POST' == $request->getMethod()) {
            $userIds = $request->request->get('ids');
            $userIds = explode(',', $userIds);
            $homeworkStatus = $request->request->get('homeworkStatus');
            $this->getOfflineCourseTaskService()->batchCheckHomework($taskId, $userIds, $homeworkStatus);

            return $this->createJsonResponse(true);
        }

        return $this->render('@CorporateTraining/offline-course/resource-manage/homework-manage/batch-update-modal.html.twig', [
            'taskId' => $taskId,
        ]);
    }

    public function viewSignQrcodeAction(Request $request, $offlineCourseId)
    {
        $offlineCourse = $this->getOfflineCourseService()->tryManageOfflineCourse($offlineCourseId);
        $signTasks = $this->getOfflineCourseTaskService()->searchTasks(['offlineCourseId' => $offlineCourseId, 'type' => 'sign'], [], 0, PHP_INT_MAX);

        $qrcodeImgUrl = $this->qrcode($offlineCourseId);

        return $this->render('@CorporateTraining/offline-course/sign-in/qr-code.html.twig',
            [
                'course' => $offlineCourse,
                'signTasks' => $signTasks,
                'qrcodeImgUrl' => $qrcodeImgUrl,
            ]
        );
    }

    protected function qrcode($offlineCourseId)
    {
        $url = $this->generateUrl('offline_course_sign_in', ['offlineCourseId' => $offlineCourseId], true);

        return $this->generateUrl('common_qrcode', ['text' => $url], true);
    }

    protected function checkResourceType($type)
    {
        if (empty($type) || in_array($type, $this->types)) {
            throw new NotFoundException('请求错误！');
        }

        return true;
    }

    /**
     * @return \Biz\Activity\Service\Impl\ActivityServiceImpl
     */
    protected function getActivityService()
    {
        return $this->createService('Activity:ActivityService');
    }

    protected function getTokenService()
    {
        return $this->createService('User:TokenService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\ProjectPlanServiceImpl
     */
    protected function getProjectPlanService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return \SurveyPlugin\Biz\Questionnaire\Service\Impl\QuestionnaireServiceImpl
     */
    protected function getQuestionnaireService()
    {
        return $this->createService('SurveyPlugin:Questionnaire:QuestionnaireService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\MemberServiceImpl
     */
    protected function getOfflineCourseMemberService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\OfflineCourseServiceImpl
     */
    protected function getOfflineCourseService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }

    /**
     * @return MemberService
     */
    protected function getProjectPlanMemberService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskResultService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\User\Service\Impl\UserOrgServiceImpl
     */
    protected function getUserOrgService()
    {
        return $this->createService('CorporateTrainingBundle:User:UserOrgService');
    }
}
