<?php

namespace CorporateTrainingBundle\Controller\OfflineCourse\ResourceManage;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Controller\BaseController as DefaultController;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\MemberService;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\OfflineClassService;

class BaseController extends DefaultController
{
    protected function appendOfflineCourseData($members, $offlineCourseId)
    {
        $tasks = $this->getOfflineCourseTaskService()->searchTasks(['offlineCourseId' => $offlineCourseId, 'type' => 'sign'], [], 0, PHP_INT_MAX, ['id']);
        $offlineCourse['attendTaskCount'] = count($tasks);
        $taskIds = empty($tasks) ? array(-1) : ArrayToolkit::column($tasks, 'id');

        foreach ($members as &$member) {
            $member['attendCount'] = $this->getOfflineCourseTaskResultService()->countTaskResults(['offlineCourseId' => $offlineCourseId, 'userId' => $member['userId'], 'status' => 'finished', 'taskIds' => $taskIds]);
        }

        return $members;
    }

    protected function prepareConditionByUserIds($userIds, $conditions)
    {
        if (isset($conditions['orgIds'])) {
            $conditions['orgIds'] = explode(',', $conditions['orgIds']);
            $users = $this->getUserOrgService()->searchUserOrgs(
                ['orgIds' => $conditions['orgIds'], 'userIds' => $userIds],
                [],
                0,
                PHP_INT_MAX,
                ['userId']
            );
            $conditions['userIds'] = ArrayToolkit::column($users, 'userId');
        }

        if (!empty($conditions['username'])) {
            $userIds = $this->getUserService()->findUserIdsByNickNameOrTrueName($conditions['username']);
            $conditions['userIds'] = (empty($conditions['userIds']) || empty($userIds)) ? [] : array_intersect($conditions['userIds'], $userIds);
            unset($conditions['username']);
        }

        if (isset($conditions['userIds'])) {
            $conditions['userIds'] = empty($conditions['userIds']) ? [-1] : $conditions['userIds'];
        }

        return $conditions;
    }

    protected function prepareConditionsByHomeworkStatus($conditions, $taskId)
    {
        if (!empty($conditions['homeworkStatus']) && !in_array($conditions['homeworkStatus'], ['none', 'all'])) {
            $results = $this->getOfflineCourseTaskResultService()->searchTaskResults(['status' => $conditions['homeworkStatus'], 'userIds' => $conditions['userIds'], 'taskId' => $taskId], [], 0, count($conditions['userIds']), ['userId']);
            $userIds = ArrayToolkit::column($results, 'userId');
            $conditions['userIds'] = (empty($conditions['userIds']) || empty($userIds)) ? array() : array_intersect($conditions['userIds'], $userIds);
        }

        if (!empty($conditions['homeworkStatus']) && 'none' == $conditions['homeworkStatus']) {
            $results = $this->getOfflineCourseTaskResultService()->searchTaskResults(['taskId' => $taskId], [], 0, PHP_INT_MAX, ['userId']);
            $userIds = ArrayToolkit::column($results, 'userId');
            $conditions['userIds'] = empty($conditions['userIds']) ? array() : array_diff($conditions['userIds'], $userIds);
        }

        unset($conditions['homeworkStatus']);
        if (isset($conditions['userIds'])) {
            $conditions['userIds'] = empty($conditions['userIds']) ? array(-1) : $conditions['userIds'];
        }

        return $conditions;
    }

    protected function prepareConditionsByAttendStatus($offlineCourseId, $conditions)
    {
        if (!empty($conditions['attendStatus']) && !in_array($conditions['attendStatus'], ['none', 'all'])) {
            $members = $this->getOfflineCourseMemberService()->searchMembers(['status' => $conditions['attendStatus'], 'userIds' => $conditions['userIds'], 'offlineCourseId' => $offlineCourseId], [], 0, count($conditions['userIds']), ['userId']);
            $userIds = ArrayToolkit::column($members, 'userId');
            $conditions['userIds'] = (empty($conditions['userIds']) || empty($userIds)) ? [] : array_intersect($conditions['userIds'], $userIds);
        }

        if (!empty($conditions['attendStatus']) && 'none' == $conditions['attendStatus']) {
            $members = $this->getOfflineCourseMemberService()->searchMembers(['excludeStatus' => $conditions['attendStatus'], 'userIds' => $conditions['userIds'], 'offlineCourseId' => $offlineCourseId], [], 0, count($conditions['userIds']), ['userId']);
            $userIds = ArrayToolkit::column($members, 'userId');
            $conditions['userIds'] = empty($conditions['userIds']) ? [] : array_diff($conditions['userIds'], $userIds);
        }

        unset($conditions['attendStatus']);
        if (isset($conditions['userIds'])) {
            $conditions['userIds'] = empty($conditions['userIds']) ? [-1] : $conditions['userIds'];
        }

        return $conditions;
    }

    /**
     * @return \Biz\Activity\Service\Impl\ActivityServiceImpl
     */
    protected function getActivityService()
    {
        return $this->createService('Activity:ActivityService');
    }

    protected function getTokenService()
    {
        return $this->createService('User:TokenService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\ProjectPlanServiceImpl
     */
    protected function getProjectPlanService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return \SurveyPlugin\Biz\Questionnaire\Service\Impl\QuestionnaireServiceImpl
     */
    protected function getQuestionnaireService()
    {
        return $this->createService('SurveyPlugin:Questionnaire:QuestionnaireService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\MemberServiceImpl
     */
    protected function getOfflineCourseMemberService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\OfflineCourseServiceImpl
     */
    protected function getOfflineCourseService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }

    /**
     * @return MemberService
     */
    protected function getProjectPlanMemberService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskResultService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\User\Service\Impl\UserOrgServiceImpl
     */
    protected function getUserOrgService()
    {
        return $this->createService('CorporateTrainingBundle:User:UserOrgService');
    }

    /**
     * @return OfflineClassService
     */
    protected function getOfflineClassService()
    {
        return $this->createService('OfflineCourseProPlugin:OfflineClass:OfflineClassService');
    }

    /**
     * @return \OfflineCourseProPlugin\Biz\OfflineClass\Service\MemberService
     */
    protected function getOfflineClassMemberService()
    {
        return $this->createService('OfflineCourseProPlugin:OfflineClass:MemberService');
    }
}
