<?php

namespace CorporateTrainingBundle\Controller\OfflineCourse\ResourceManage;

use AppBundle\Common\Paginator;
use AppBundle\Common\ArrayToolkit;
use Symfony\Component\HttpFoundation\Request;

class ProjectPlanController extends BaseController
{
    const TYPE = 'project_plan';

    public function attendanceManageAction(Request $request, $id)
    {
        $renderData = $this->buildAttendanceManageData($request, $id);

        return $this->render('@CorporateTraining/offline-course/resource-manage/attendance-manage/project-plan-attendance-list.html.twig', $renderData);
    }

    public function ajaxAttendanceManageAction(Request $request, $id)
    {
        $renderData = $this->buildAttendanceManageData($request, $id, 'ajax');

        return $this->render('@CorporateTraining/offline-course/resource-manage/attendance-manage/attendance-table.html.twig', $renderData);
    }

    public function homeworkManageAction(Request $request, $taskId)
    {
        $renderData = $this->buildHomeworkManageData($request, $taskId);

        return $this->render('@CorporateTraining/offline-course/resource-manage/homework-manage/project-plan-review-list.html.twig', $renderData);
    }

    public function ajaxHomeworkManageAction(Request $request, $taskId)
    {
        $renderData = $this->buildHomeworkManageData($request, $taskId, 'ajax');

        return $this->render('@CorporateTraining/offline-course/resource-manage/homework-manage/review-list-table.html.twig', $renderData);
    }

    protected function buildHomeworkManageData($request, $taskId, $type = '')
    {
        $offlineCourseTask = $this->getOfflineCourseTaskService()->getTask($taskId);
        $offlineCourse = $this->getOfflineCourseService()->tryManageOfflineCourse($offlineCourseTask['offlineCourseId']);
        $projectPlanItem = $this->getProjectPlanService()->getProjectPlanItemByTargetIdAndTargetType($offlineCourse['id'], 'offline_course');
        $conditions = $request->request->all();
        $conditions['projectPlanId'] = $projectPlanItem['projectPlanId'];
        $members = $this->getProjectPlanMemberService()->searchProjectPlanMembers(['projectPlanId' => $conditions['projectPlanId']], [], 0, PHP_INT_MAX, ['userId']);
        $userIds = ArrayToolkit::column($members, 'userId');
        $conditions = $this->prepareConditionByUserIds($userIds, $conditions);
        $conditions = $this->prepareConditionsByHomeworkStatus($conditions, $taskId);

        $paginator = new Paginator(
            $request,
            $this->getProjectPlanMemberService()->countProjectPlanMembers($conditions),
            20
        );

        if ('ajax' != $type) {
            $paginator->setBaseUrl($this->generateUrl('project_plan_offline_course_homework_manage_ajax', array('taskId' => $taskId)));
        }

        $members = $this->getProjectPlanMemberService()->searchProjectPlanMembers(
            $conditions,
            ['id' => 'DESC'],
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );

        $userIds = empty($members) ? array(-1) : ArrayToolkit::column($members, 'userId');
        $users = $this->getUserService()->findUsersByIds($userIds);
        $taskResults = $this->getOfflineCourseTaskResultService()->searchTaskResults(['taskId' => $taskId, 'userIds' => $userIds], [], 0, count($userIds));

        return [
            'offlineCourse' => $offlineCourse,
            'members' => $members,
            'paginator' => $paginator,
            'users' => $users,
            'taskId' => $taskId,
            'taskResults' => ArrayToolkit::index($taskResults, 'userId'),
            'orgIds' => implode(',', $this->prepareOrgIds($conditions)),
            'resourceId' => $projectPlanItem['projectPlanId'],
            'type' => self::TYPE,
            'projectPlan' => $this->getProjectPlanService()->getProjectPlan($projectPlanItem['projectPlanId']),
        ];
    }

    protected function buildAttendanceManageData($request, $id, $ajaxType = '')
    {
        $offlineCourse = $this->getOfflineCourseService()->tryManageOfflineCourse($id);
        $conditions = $request->request->all();
        $projectPlanItem = $this->getProjectPlanService()->getProjectPlanItemByTargetIdAndTargetType($offlineCourse['id'], 'offline_course');

        $conditions['projectPlanId'] = $projectPlanItem['projectPlanId'];
        $members = $this->getProjectPlanMemberService()->searchProjectPlanMembers(['projectPlanId' => $conditions['projectPlanId']], [], 0, PHP_INT_MAX, ['userId']);
        $userIds = ArrayToolkit::column($members, 'userId');
        $conditions = $this->prepareConditionByUserIds($userIds, $conditions);
        $conditions = $this->prepareConditionsByAttendStatus($offlineCourse['id'], $conditions);

        $paginator = new Paginator(
            $request,
            $this->getProjectPlanMemberService()->countProjectPlanMembers($conditions),
            20
        );

        if ('ajax' != $ajaxType) {
            $paginator->setBaseUrl($this->generateUrl('project_plan_offline_course_attendance_manage_ajax', ['id' => $id]));
        }

        $members = $this->getProjectPlanMemberService()->searchProjectPlanMembers(
            $conditions,
            ['id' => 'DESC'],
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );

        $userIds = empty($members) ? array(-1) : ArrayToolkit::column($members, 'userId');
        $users = $this->getUserService()->findUsersByIds($userIds);
        $offlineCourseMembers = $this->getOfflineCourseMemberService()->searchMembers(['userIds' => $userIds, 'offlineCourseId' => $id], [], 0, count($userIds));

        return [
            'offlineCourse' => $offlineCourse,
            'members' => $this->appendOfflineCourseData($members, $id),
            'paginator' => $paginator,
            'users' => $users,
            'offlineCourseMembers' => ArrayToolkit::index($offlineCourseMembers, 'userId'),
            'taskCount' => $this->getOfflineCourseTaskService()->countTasks(['offlineCourseId' => $id, 'type' => 'sign']),
            'orgIds' => implode(',', $this->prepareOrgIds($conditions)),
            'projectPlan' => $this->getProjectPlanService()->getProjectPlan($projectPlanItem['projectPlanId']),
            'resourceId' => $projectPlanItem['projectPlanId'],
            'type' => self::TYPE,
        ];
    }
}
