<?php

namespace CorporateTrainingBundle\Controller;

use AppBundle\Controller\BaseController;
use Symfony\Component\HttpFoundation\Request;
use CorporateTrainingBundle\Biz\ResourceFavorite\Service\ResourceFavoriteService;

class ResourceFavoriteController extends BaseController
{
    public function favoriteAction(Request $request, $targetType, $targetId)
    {
        $this->getResourceFavoriteService()->createResourceFavorite(['targetType' => $targetType, 'targetId' => $targetId, 'userId' => $this->getCurrentUser()->getId()]);

        return $this->createJsonResponse(true);
    }

    public function unfavoriteAction(Request $request, $targetType, $targetId)
    {
        $this->getResourceFavoriteService()->deleteResourceFavoriteByTargetTypeAndTargetIdAndUserId($targetType, $targetId, $this->getCurrentUser()->getId());

        return $this->createJsonResponse(true);
    }

    /**
     * @return ResourceFavoriteService
     */
    protected function getResourceFavoriteService()
    {
        return $this->createService('CorporateTrainingBundle:ResourceFavorite:ResourceFavoriteService');
    }
}
