<?php

namespace CorporateTrainingBundle\Controller;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Common\Paginator;
use AppBundle\Controller\BaseController;
use Codeages\Biz\Framework\Service\Exception\NotFoundException;
use CorporateTrainingBundle\Biz\ResourceUsePermissionShared\Service\ResourceUsePermissionSharedHistoryService;
use CorporateTrainingBundle\Biz\ResourceUsePermissionShared\Service\ResourceUsePermissionSharedService;
use Symfony\Component\HttpFoundation\Request;

class ResourceUsePermissionController extends BaseController
{
    public function accreditAction(Request $request, $type, $resourceId)
    {
        if ('POST' == $request->getMethod()) {
            $userIds = $request->request->get('userIds');
            if (!empty($userIds)) {
                $userIds = explode(',', $userIds);
                $this->getResourceUsePermissionSharedService()->batchCreateSharedRecord([
                'resourceType' => $type,
                'resourceId' => $resourceId,
                'userIds' => $userIds,
            ]);
            }
            $count = $this->getResourceUsePermissionSharedService()->countSharedRecords(['resourceType' => $type, 'resourceId' => $resourceId]);

            return $this->createJsonResponse($count);
        }

        return  $this->render('resource-use-permission/accredit-modal.html.twig', [
            'resourceId' => $resourceId,
            'resourceType' => $type,
        ]);
    }

    public function recordListAction(Request $request, $type, $resourceId)
    {
        return  $this->render('resource-use-permission/record-list-modal.html.twig', [
            'resourceId' => $resourceId,
            'resourceType' => $type,
        ]);
    }

    public function ajaxRecordListAction(Request $request, $type, $resourceId)
    {
        $conditions = [
            'resourceType' => $type,
            'resourceId' => $resourceId,
        ];
        $paginator = new Paginator(
            $request,
            $this->getResourceUsePermissionSharedService()->countSharedRecords($conditions),
            20
        );
        $paginator->setBaseUrl($this->generateUrl('resource_use_permission_record_ajax_list', ['type' => $type, 'resourceId' => $resourceId]));

        $records = $this->getResourceUsePermissionSharedService()->searchSharedRecords(
            $conditions,
            ['createdTime' => 'DESC'],
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );
        $recordToUserIds = ArrayToolkit::column($records, 'toUserId');
        $recordFromUserIds = ArrayToolkit::column($records, 'fromUserId');
        $userIds = array_merge($recordToUserIds, $recordFromUserIds);

        $recordUsers = [];
        if (!empty($userIds)) {
            $recordUsers = $this->getUserService()->findUsersByIds($userIds);
        }

        return  $this->render('resource-use-permission/record-list-tr.html.twig', [
            'resourceId' => $resourceId,
            'resourceType' => $type,
            'records' => $records,
            'recordUsers' => $recordUsers,
            'paginator' => $paginator,
        ]);
    }

    public function ajaxHistoryListAction(Request $request, $type, $resourceId)
    {
        $conditions = [
            'resourceType' => $type,
            'resourceId' => $resourceId,
        ];
        $username = $request->request->get('nameLike', '');

        if (!empty($username)) {
            $userIds = $this->getUserService()->findUserIdsByNickNameOrTrueName($username);
            $conditions['toUserIds'] = empty($userIds) ? [-1] : $userIds;
        }

        $paginator = new Paginator(
            $request,
            $this->getResourceUsePermissionSharedService()->countSharedRecords($conditions),
            20
        );
        $paginator->setBaseUrl($this->generateUrl('resource_use_permission_history_ajax_list', ['type' => $type, 'resourceId' => $resourceId]));

        $histories = $this->getResourceUsePermissionSharedHistoryService()->searchHistories(
            $conditions,
            ['createdTime' => 'DESC'],
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );
        $recordToUserIds = ArrayToolkit::column($histories, 'toUserId');
        $actionUserIds = ArrayToolkit::column($histories, 'actionUser');
        $userIds = array_merge($recordToUserIds, $actionUserIds);

        $recordUsers = [];
        if (!empty($userIds)) {
            $recordUsers = $this->getUserService()->findUsersByIds($userIds);
        }

        return  $this->render('resource-use-permission/history-list-tr.html.twig', [
            'resourceId' => $resourceId,
            'resourceType' => $type,
            'histories' => $histories,
            'recordUsers' => $recordUsers,
            'paginator' => $paginator,
        ]);
    }

    public function userMatchAction(Request $request)
    {
        $queryString = $request->query->get('q');
        $isTeacher = $request->query->get('isTeacher', false);
        $conditions = ['truename' => $queryString, 'noType' => 'system', 'locked' => 0];
        $conditions['roles'] = $isTeacher ? 'teacher' : '';
        $users = $this->getUserService()->searchUsers($conditions, ['id' => 'ASC'], 0, 20, ['truename', 'nickname', 'id']);

        return $this->createJsonResponse($users);
    }

    public function canceledSharedAction(Request $request, $recordId)
    {
        $record = $this->getResourceUsePermissionSharedService()->getSharedRecord($recordId);
        if (empty($record)) {
            throw  new NotFoundException($this->trans('resource.canceled_shared.error_message'));
        }
        $result = $this->getResourceUsePermissionSharedService()->canceledSharedRecord($recordId);
        $sharedCount = $this->getResourceUsePermissionSharedService()->countSharedRecords(['resourceType' => $record['resourceType'], 'resourceId' => $record['resourceId']]);

        return $this->createJsonResponse(['success' => $result, 'sharedCount' => $sharedCount]);
    }

    /**
     * @return \Biz\User\Service\UserService
     */
    protected function getUserService()
    {
        return $this->createService('CorporateTrainingBundle:User:UserService');
    }

    /**
     * @return ResourceUsePermissionSharedService
     */
    protected function getResourceUsePermissionSharedService()
    {
        return $this->createService('ResourceUsePermissionShared:ResourceUsePermissionSharedService');
    }

    /**
     * @return ResourceUsePermissionSharedHistoryService
     */
    protected function getResourceUsePermissionSharedHistoryService()
    {
        return $this->createService('ResourceUsePermissionShared:ResourceUsePermissionSharedHistoryService');
    }
}
