<?php

namespace CorporateTrainingBundle\Extension;

use CorporateTrainingBundle\Biz\Enroll\Strategy\EnrollStrategyContext;
use CorporateTrainingBundle\Biz\Enroll\Strategy\Impl\OfflineActivityStrategy;
use CorporateTrainingBundle\Biz\Enroll\Strategy\Impl\ProjectPlanStrategy;
use Pimple\Container;
use Pimple\ServiceProviderInterface;

class EnrollExtension extends Extension implements ServiceProviderInterface
{
    public function register(Container $biz)
    {
        $biz['enroll_strategy_context'] = function ($biz) {
            return new EnrollStrategyContext($biz);
        };

        $biz['enroll_strategy_projectPlan'] = function ($biz) {
            return new ProjectPlanStrategy($biz);
        };

        $biz['enroll_strategy_offlineActivity'] = function ($biz) {
            return new OfflineActivityStrategy($biz);
        };
    }
}
