<?php

namespace CorporateTrainingBundle\Extension;

use Pimple\Container;
use Pimple\ServiceProviderInterface;
use CorporateTrainingBundle\Biz\Org\Module\UserModule;
use CorporateTrainingBundle\Biz\Org\Module\ArticleModule;
use CorporateTrainingBundle\Biz\Org\Module\ClassroomModule;
use CorporateTrainingBundle\Biz\Org\Module\UserGroupModule;
use CorporateTrainingBundle\Biz\Org\Module\CourseSetModule;
use CorporateTrainingBundle\Biz\Org\Module\OpenCourseModule;
use CorporateTrainingBundle\Biz\Org\Module\ProjectPlanModule;
use CorporateTrainingBundle\Biz\Org\Module\AnnouncementModule;
use CorporateTrainingBundle\Biz\Org\Module\OfflineActivityModule;

class OrgModuleExtension extends Extension implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container['org.module.user'] = function ($biz) {
            return new UserModule($biz);
        };
        $container['org.module.courseSet'] = function ($biz) {
            return new CourseSetModule($biz);
        };
        $container['org.module.classroom'] = function ($biz) {
            return new ClassroomModule($biz);
        };
        $container['org.module.article'] = function ($biz) {
            return new ArticleModule($biz);
        };
        $container['org.module.announcement'] = function ($biz) {
            return new AnnouncementModule($biz);
        };
        $container['org.module.openCourse'] = function ($biz) {
            return new OpenCourseModule($biz);
        };
        $container['org.module.project'] = function ($biz) {
            return new ProjectPlanModule($biz);
        };
        $container['org.module.offlineActivity'] = function ($biz) {
            return new OfflineActivityModule($biz);
        };
        $container['org.module.userGroup'] = function ($biz) {
            return new UserGroupModule($biz);
        };
    }

    public function getOrgModules()
    {
        return [
            'user' => [
                'displayKey' => 'org.module.display_name.user',
                'service' => 'User:UserService',
                'countMethod' => 'countUsers',
            ],
            'courseSet' => [
                'displayKey' => 'org.module.display_name.courseset',
                'service' => 'Course:CourseSetService',
                'countMethod' => 'countCourseSets',
            ],
            'classroom' => [
                'displayKey' => 'org.module.display_name.classroom',
                'service' => 'Classroom:ClassroomService',
                'countMethod' => 'countClassrooms',
            ],
            'article' => [
                'displayKey' => 'org.module.display_name.article',
                'service' => 'Article:ArticleService',
                'countMethod' => 'countArticles',
            ],
            'announcement' => [
                'displayKey' => 'org.module.display_name.announcement',
                'service' => 'Announcement:AnnouncementService',
                'countMethod' => 'countAnnouncements',
            ],
            'openCourse' => [
                'displayKey' => 'org.module.display_name.openCourse',
                'service' => 'OpenCourse:OpenCourseService',
                'countMethod' => 'countCourses',
            ],
            'project' => [
                'displayKey' => 'org.module.display_name.project',
                'service' => 'ProjectPlan:ProjectPlanService',
                'countMethod' => 'countProjectPlans',
            ],
            'offlineActivity' => [],
            'userGroup' => [],
        ];
    }
}
