<?php

namespace CorporateTrainingBundle\Extensions\DataTag;

use AppBundle\Extensions\DataTag\BaseDataTag;
use AppBundle\Extensions\DataTag\DataTag;
use CorporateTrainingBundle\Biz\Enroll\Service\EnrollRecordService;

class OfflineActivitySubmittedStudentNumDataTag extends BaseDataTag implements DataTag
{
    public function getData(array $arguments)
    {
        return $this->getEnrollRecordService()->countEnrollRecords(['targetId' => $arguments['offlineActivityId'], 'status' => 'submitted']);
    }

    /**
     * @return EnrollRecordService
     */
    protected function getEnrollRecordService()
    {
        return $this->getServiceKernel()->getBiz()->service('CorporateTrainingBundle:Enroll:EnrollRecordService');
    }
}
