<?php

namespace CorporateTrainingBundle\Extensions\DataTag;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Extensions\DataTag\CourseBaseDataTag;
use AppBundle\Extensions\DataTag\DataTag;

class OfflineCourseDataTag extends CourseBaseDataTag implements DataTag
{
    public function getData(array $arguments)
    {
        $offlineCourse = $this->getOfflineCourseService()->getOfflineCourse($arguments['id']);
        $courseItems = $this->getOfflineCourseService()->findOfflineCourseItems($arguments['id']);
        $courseItemsGroup = ArrayToolkit::group($courseItems, 'type');

        $offlineCourseItems = array('info' => $offlineCourse, 'items' => $courseItemsGroup);

        return $offlineCourseItems;
    }

    protected function getOfflineCourseService()
    {
        return $this->getServiceKernel()->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }
}
