<?php

namespace CorporateTrainingBundle\Extensions\DataTag;

use AppBundle\Extensions\DataTag\DataTag;
use AppBundle\Extensions\DataTag\BaseDataTag;

class ProjectPlanEvaluationItemResultDataTag extends BaseDataTag implements DataTag
{
    public function getData(array $arguments)
    {
        if (empty($arguments['userId']) || empty($arguments['surveyId']) || empty($arguments['itemId'])) {
            return array();
        }

        $surveyResult = $this->getSurveyResultService()->getSurveyResultBySurveyIdAndUserId($arguments['surveyId'], $arguments['userId']);
        if (empty($surveyResult) || 'finished' != $surveyResult['status']) {
            return array();
        }

        $results = $this->getQuestionnaireItemResultService()->searchQuestionnaireItemResults(
            array(
                'itemId' => $arguments['itemId'],
                'resultId' => $surveyResult['id'],
                'surveyId' => $arguments['surveyId'],
                'userId' => $arguments['userId'],
            ),
            array(),
            0,
            PHP_INT_MAX
        );

        return empty($results) ? array() : $results[0];
    }

    /**
     * @return \SurveyPlugin\Biz\Questionnaire\Service\Impl\QuestionnaireItemResultServiceImpl
     */
    protected function getQuestionnaireItemResultService()
    {
        return $this->getServiceKernel()->createService('SurveyPlugin:Questionnaire:QuestionnaireItemResultService');
    }

    /**
     * @return SurveyResultService
     */
    protected function getSurveyResultService()
    {
        return $this->getServiceKernel()->createService('SurveyPlugin:Survey:SurveyResultService');
    }
}
