<?php

namespace CorporateTrainingBundle\Extensions\DataTag;

use Biz\System\Service\SettingService;
use AppBundle\Extensions\DataTag\DataTag;
use AppBundle\Extensions\DataTag\BaseDataTag;

class ResourceDingTalkNotificationSettingDataTag extends BaseDataTag implements DataTag
{
    protected $resourceTypes = [
        'course_member' => 'online_course_assign',
        'offlineActivity_member' => 'offline_activity_add_member',
        'classroom_member' => 'classroom_assign',
        'project_plan_member' => 'project_plan_assign',
        'exam_member' => 'exam_assign',
        'offline_class_member' => 'offline_class_assign',
        'survey_member' => 'survey_assign',
    ];

    /**
     * 获取资源待审核数量.
     *
     * @param array $arguments 参数
     *
     * @return int 报名记录数量
     */
    public function getData(array $arguments)
    {
        if (!isset($arguments['targetType']) || empty($this->resourceTypes[$arguments['targetType']])) {
            return  0;
        }

        $setting = $this->getSettingService()->get('dingtalk_notification', []);

        return  empty($setting[$this->resourceTypes[$arguments['targetType']]]) ? 0 : $setting[$this->resourceTypes[$arguments['targetType']]];
    }

    /**
     * @return SettingService
     */
    protected function getSettingService()
    {
        return $this->getServiceKernel()->getBiz()->service('System:SettingService');
    }
}
