<?php

namespace CorporateTrainingBundle\Extensions\DataTag;

use CertificatePlugin\Biz\Certificate\CertificateResourceStrategy\BaseStrategy;
use Topxia\Service\Common\ServiceKernel;
use AppBundle\Extensions\DataTag\BaseDataTag;
use AppBundle\Extensions\DataTag\DataTag;

class ResourceHasCertificateDataTag extends BaseDataTag implements DataTag
{
    public function getData(array $arguments)
    {
        return $this->getCertificateClass($arguments['targetType'])->countResourceCertificatesCount($arguments['targetId']);
    }

    /**
     * @param $type
     *
     * @return BaseStrategy
     */
    protected function getCertificateClass($type)
    {
        return ServiceKernel::instance()->getBiz()->offsetGet('certificate.type.'.$type);
    }
}
