<?php

namespace CorporateTrainingBundle\Extensions\DataTag;

use AppBundle\Extensions\DataTag\DataTag;
use AppBundle\Extensions\DataTag\BaseDataTag;
use CorporateTrainingBundle\Biz\Enroll\Service\EnrollRecordService;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\ProjectPlanService;

class ResourceUserEnrollRecordDataTag extends BaseDataTag implements DataTag
{
    /**
     * 获取用户报名记录
     *
     * @param array $arguments 参数
     *
     * @return int 报名记录数量
     */
    public function getData(array $arguments)
    {
        if (!isset($arguments['targetId'])) {
            throw new \InvalidArgumentException($this->getServiceKernel()->trans('targetId参数缺失'));
        }
        if (!isset($arguments['targetType'])) {
            throw new \InvalidArgumentException($this->getServiceKernel()->trans('targetType参数缺失'));
        }

        return $this->getEnrollRecordService()->getEnrollRecordByTargetIdAndUserIdAndTargetType($arguments['targetId'], $this->getCurrentUser()->getId(), $arguments['targetType']);
    }

    /**
     * @return ProjectPlanService
     */
    protected function getProjectPlanService()
    {
        return $this->getServiceKernel()->getBiz()->service('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return EnrollRecordService
     */
    protected function getEnrollRecordService()
    {
        return $this->getServiceKernel()->getBiz()->service('CorporateTrainingBundle:Enroll:EnrollRecordService');
    }
}
