<?php

namespace CorporateTrainingBundle\Extensions\DataTag;

use AppBundle\Extensions\DataTag\BaseDataTag;
use AppBundle\Extensions\DataTag\DataTag;
use Codeages\Biz\Framework\Service\Exception\NotFoundException;
use CorporateTrainingBundle\Biz\Enroll\Service\EnrollRecordService;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\ProjectPlanService;

class UserEnrollStatusDataTag extends BaseDataTag implements DataTag
{
    public function getData(array $arguments)
    {
        if (empty($arguments['enrollType']) || empty($arguments['targetId']) || empty($arguments['userId'])) {
            throw new NotFoundException('缺少必要字段！');
        }
        $status = $this->getEnrollStrategyContext()->createStrategy($arguments['enrollType'])->getUserEnrollStatus($arguments['targetId'], $arguments['userId']);

        if ('queue' == $status) {
            $userQueueCount = $this->getEnrollRecordService()->getUserQueueCountByTargetIdAndTargetType($arguments['userId'], $arguments['targetId'], $arguments['enrollType']);

            return ['status' => $status, 'userQueueCount' => $userQueueCount];
        }

        if ('queueAble' == $status) {
            $queueCount = $this->getEnrollRecordService()->getQueueCountByTargetIdAndTargetType($arguments['targetId'], $arguments['enrollType']);

            return ['status' => $status, 'queueCount' => $queueCount];
        }

        return ['status' => $status];
    }

    /**
     * @return EnrollRecordService
     */
    protected function getEnrollRecordService()
    {
        return $this->getServiceKernel()->getBiz()->service('CorporateTrainingBundle:Enroll:EnrollRecordService');
    }

    /**
     * @return ProjectPlanService
     */
    protected function getProjectPlanService()
    {
        return $this->getServiceKernel()->getBiz()->service(
            'CorporateTrainingBundle:ProjectPlan:ProjectPlanService'
        );
    }

    protected function getEnrollStrategyContext()
    {
        return $this->getServiceKernel()->getBiz()['enroll_strategy_context'];
    }
}
