<?php

namespace CorporateTrainingBundle\Extensions\DataTag;

use AppBundle\Extensions\DataTag\DataTag;
use AppBundle\Extensions\DataTag\BaseDataTag;
use CorporateTrainingBundle\Biz\ResourceFavorite\Service\ResourceFavoriteService;

class UserFavoriteResourceRecordDataTag extends BaseDataTag implements DataTag
{
    /**
     * 获取用户资源收藏记录
     *
     * @param array $arguments 参数
     *
     * @return int 报名记录数量
     */
    public function getData(array $arguments)
    {
        if (!isset($arguments['targetId'])) {
            throw new \InvalidArgumentException($this->getServiceKernel()->trans('targetId参数缺失'));
        }
        if (!isset($arguments['targetType'])) {
            throw new \InvalidArgumentException($this->getServiceKernel()->trans('targetType参数缺失'));
        }
        if (!isset($arguments['userId'])) {
            throw new \InvalidArgumentException($this->getServiceKernel()->trans('userId参数缺失'));
        }

        return $this->getResourceFavoriteService()->getResourceFavoriteByUserIdAndTargetTypeAndTargetId($arguments['userId'], $arguments['targetType'], $arguments['targetId']);
    }

    /**
     * @return ResourceFavoriteService
     */
    protected function getResourceFavoriteService()
    {
        return $this->getServiceKernel()->getBiz()->service('CorporateTrainingBundle:ResourceFavorite:ResourceFavoriteService');
    }
}
