define(function (require, exports, module) {
  var Validator = require('bootstrap.validator');
  var Notify = require('common/bootstrap-notify');
  require('common/validator-rules').inject(Validator);

  exports.run = function () {
    var $form = $('#org-manage-form');
    var $modal = $form.parents('.modal');

    var validator = new Validator({
      element: $form,
      autoSubmit: false,
      onFormValidated: function (error, results, $form) {
        if (error) {
          return;
        }
          $('#org-create-btn').button('submiting').addClass('disabled');
          $('.delete-org').addClass('disabled');

        $.post($form.attr('action'), $form.serialize(), function (response) {
        if(response.status === 'success'){
            $modal.modal('hide');
            Notify.success(Translator.trans('保存组织机构成功！'));
            let org = response.org;
            refreshItem(org.id);
            if(org.changeParent > 0){
                moveItem(org.id, org.parentId);
            }
        }else{
            $('#org-create-btn').button('submiting').removeClass('disabled');
            $('.delete-org').removeClass('disabled');
            Notify.danger(Translator.trans('保存组织机构失败！'));
        }
        }).fail(function (data) {
            data = $.parseJSON(data.responseText);
            if (data.error) {
                Notify.danger(data.error.message);
            } else {
                Notify.danger(Translator.trans('保存组织机构失败，请重试！'));
            }
            $('#org-create-btn').removeClass('disabled');
            $('.delete-org').removeClass('disabled');
        });
      }
    });

    validator.addItem({
      element: '#org-name-field',
      required: true,
      rule: 'chinese_alphanumeric byte_maxlength{max:200} remote'
    });

    validator.addItem({
      element: '#org-code-field',
      required: true,
      rule: 'alpha_numerica byte_maxlength{max:30} remote'
    });


    Validator.addRule("alpha_numerica", /^([0-9]|[a-zA-Z])*$/i, `{{display}}${Translator.trans('admin.user_group.alpha_numerica_message')}`);

    $modal.find('.delete-org').on('click', function () {
      if (confirm(Translator.trans('admin.org.delete_confirm_message'))) {
          $('#org-create-btn').addClass('disabled');
          $('.delete-org').addClass('disabled');
        $.post($(this).data('url'), function (response) {
          if (response && response.status == 'error') {
            var msg = Translator.trans('admin.org.delete_error_one');
            $.each(response.data, function ($key) {
              msg += Translator.trans($key) + ':' + response.data[$key] + Translator.trans('admin.org.delete_count') + " \t";
            });
            msg += Translator.trans('admin.org.delete_error_two');
            Notify.danger(msg, 8);
              $('#org-create-btn').removeClass('disabled');
              $('.delete-org').removeClass('disabled');
            return false;
          }
          Notify.success(Translator.trans('admin.org.delete_success'));
          $modal.modal('hide');
          updateParentItemChildrenNum(response.orgId);
        });
      }
    });

    function moveItem(orgId, parentId) {
      let $orgTreeItem = $('#tree-item-' + orgId);
      let $parentItem = $orgTreeItem.parent().closest('.js-org-tree-item');
        if($parentItem.length > 0 ){
            let $parentItemChildren = $parentItem.children('.org-tree-item__head').find('div.org-tree-item__children_num');
            let parentItemChildrenNum = $parentItemChildren.text();
            $parentItemChildren.text(parentItemChildrenNum-1);
            $orgTreeItem.remove();
            refreshNewParentItems(parentId);
        }else{
            window.location.href= $('#org-table-body').data('refreshUrl');
        }
  }

  function refreshNewParentItems(parentId) {
      let $orgTreeParentItem = $('#tree-item-' + parentId);
      if($orgTreeParentItem.length >0){
          let $loadBtn = $("#load-btn-" + parentId);
          let $itemChildren = $orgTreeParentItem.children('.org-tree-item__head').find('div.org-tree-item__children_num');
          let itemChildrenNum = $itemChildren.text();
          $itemChildren.text(Number(itemChildrenNum) + 1);
          let isChildrenOpen = false;
          if ($loadBtn.length > 0 && $loadBtn.hasClass('glyphicon-chevron-down')) {
              isChildrenOpen = true;
          }
          $.get($orgTreeParentItem.data('refresh-url'), function (html) {
              if (!isChildrenOpen) {
                  $orgTreeParentItem.replaceWith(html);
              } else {
                  let contentWrapHtml = $orgTreeParentItem.find('.js-org-tree-item-wrap').html();
                  $orgTreeParentItem.replaceWith(html);
                  let $newOrgTreeItem = $('#tree-item-' + parentId);
                  $newOrgTreeItem.find('.js-org-tree-item-wrap').html(contentWrapHtml);
                  refreshChildrenItems(parentId);
              }
          });
      }
  }

    function refreshChildrenItems(parentId) {
          let $loadBtn = $("#load-btn-" + parentId);
          $loadBtn.toggleClass('glyphicon-chevron-right').toggleClass('glyphicon-chevron-down');
          let $orgTreeItem = $('#tree-item-' + parentId);
          let $contentWrap = $orgTreeItem.find('.js-org-tree-item-wrap');
          $.get($loadBtn.data('url'), function (html) {
              $contentWrap.html(html);
              $loadBtn.data('is-complete', true);
          });
    }

    function refreshItem(orgId) {
        let $orgTreeItem = $('#tree-item-' + orgId);
        let $loadBtn = $("#load-btn-" + orgId);
        let isChildrenOpen = false;
        if ($loadBtn.length > 0 && $loadBtn.hasClass('glyphicon-chevron-down')) {
            isChildrenOpen = true;
        }
        $.get($orgTreeItem.data('refresh-url'), function (html) {
            if (!isChildrenOpen) {
                $orgTreeItem.replaceWith(html);
            } else {
                let contentWrapHtml = $orgTreeItem.find('.js-org-tree-item-wrap').html();
                $orgTreeItem.replaceWith(html);
                let $newOrgTreeItem = $('#tree-item-' + orgId);
                $newOrgTreeItem.find('.js-org-tree-item-wrap').html(contentWrapHtml);
                refreshChildrenItems(orgId);
            }
        });
    }

    function updateParentItemChildrenNum(orgId) {
        let $item = $('#tree-item-' + orgId);
        let $parentItem = $item.parent().closest('.js-org-tree-item');
        let $parentItemChildren = $parentItem.children('.org-tree-item__head').find('div.org-tree-item__children_num');
        let parentItemChildrenNum = $parentItemChildren.text();
        $parentItemChildren.text(parentItemChildrenNum-1);
        $item.remove();
    }
  }

});
