import notify from 'common/notify';
import BatchSelectInCookie from 'app/common/widget/batch-select-in-cookie';
export default class  BatchRemove {
  constructor(container,cookieName) {
    this.batchSelectInCookie = new BatchSelectInCookie(container, cookieName);
    this.initBatchRemove(container,cookieName);
  }

  initBatchRemove(container,cookieName) {
    let $element = container;
    let self  = this;
    $element.on('click', '[data-role="batch-delete"]', function () {
      let $btn = $(this);
      let name = $btn.data('name');
      let ids = self.batchSelectInCookie.itemIds;
      if (ids.length == 0) {
        notify('danger', Translator.trans('member.item.selsect_empty') + name);
        return;
      }
      if (!confirm(Translator.trans('member.item.batch_remove_confirm_message', {ids: ids.length, name: name}))) {
        return;
      }
      $element.find('.btn').addClass('disabled');
      let count = 0;
      $.ajaxSettings.async = false;
      $.post($btn.data('member-count-url'), {ids: ids}, function (response) {
        count = response.count;
      });
      $.ajaxSettings.async = true;
      if (count == 0) {
        notify('danger', Translator.trans('member.item.selsect_empty') + name);
        return;
      }
      self.showProgress();
      self.removeData($btn.data('url'), ids, count, 0);
    });
  }

  showProgress() {
    let progressHtml = $('#batch-delete-modal').html();
    $('#modal').html(progressHtml);
    $('#modal').modal({backdrop: 'static', keyboard: false});
  }

  removeData(url, ids, count, start) {
    let self = this;
    let modal = $('#modal');

    $.post(url, {ids: ids}, function (response) {
      if (!response.success) {
        console.log(response);

        notify('danger', Translator.trans(response.message));
        return;
      }

      if (response.status === 'continue') {
        let process = start * 100 / count + '%';
        modal.find('#batch-delete-progress-bar').width(process);
        self.removeData(url, ids, count, start + 10);
      } else {
        modal.find('#batch-delete-progress-bar').width('100%');
        let $title = $(modal).find('.modal-title');
        notify('success', Translator.trans($title.data('success')));
        self.batchSelectInCookie._clearCookie();
        window.location.reload();
        self.batchSelectInCookie._clearCookie();
      }
    }).error(function(e){
      notify('danger', e.responseJSON.error.message);
    });
  }
}