import notify  from 'common/notify';
import Cookies from 'js-cookie';

$('#batch-record-num').text($('#selected-count').text());

let $form = $('#batch-verify-from');
$('.js-verify-btn').click(function () {
  $(this).button('submiting').addClass('disabled');

  let recordIds = $('#recordIds').val();
  $.post($form.attr('action'), {status: $(this).data('status'),recordIds:recordIds}, function(result){
    if (result) {
      notify('success', Translator.trans('project_plan.operate_success'));
      window.location.reload();
    } else {
      notify('danger', Translator.trans('project_plan.operate_error'));
    }
  }).success(function(){
    recordIds = Cookies.get('recordIds').split(',');
    recordIds.splice(0, recordIds.length);
    Cookies.set('recordIds', recordIds.join(','));
  }).error(function() {
    notify('danger', Translator.trans('project_plan.operate_error'));
  });
});