import { enterSubmit } from 'app/common/form';
import notify from 'common/notify';

const $form = $('#third-party-bind-form');
const $btn = $('.js-submit-btn');

let validator = $form.validate({
  currentDom: $btn,
  ajax: true,
  rules: {
    password: {
      required: true,
    }
  },
  submitSuccess(data) {
    window.location.href = data.url;
  },
  submitError(res){
    let msg = '';
    let errorRes = JSON.parse(res.responseText);
    if (errorRes.error && errorRes.error.message) {
      msg = errorRes.error.message;
    }
    notify('danger', msg);
  },
});


$('#password').focus(() => {
  $('.js-password-error').remove();
});

enterSubmit($form, $btn);