import notify from 'common/notify';

class batchUpdate
{
  constructor() {
    this.init();
  }

  init() {
    let $form = $('#homework-update-form');
    let $modal = $form.parents('.modal');

    $('.js-update-btn').click(function () {
      $('.js-update-btn').button('loading');
      $.post($form.data('url'), $form.serialize(),function (result) {
        if (result) {
          $modal.modal('hide');
          notify('success', Translator.trans('project_plan.save_success'));
          window.location.reload();
        } else {
          $('.js-update-btn').button('reset');
          notify('danger', Translator.trans('project_plan.save_error'));
        }
      }).error(function() {
        $('.js-update-btn').button('reset');
        notify('danger', Translator.trans('project_plan.save_error'));
      });
    });

    this.getCheckedBatchItems();
  }

  getCheckedBatchItems() {
    let ids = [];
    $('[data-role=\'batch-item\']:checked').each(function () {
      let id = $(this).val();
      let userId = id.split('-').pop();
      ids.push(userId);
    });
    if(ids.length == 0 ){
      $('.js-update-btn').addClass('disabled');
    }
    $('#batch-ids').val(ids);
  }
}

new batchUpdate();

