class Page {
  constructor() {
    this.init();
  }

  init() {
    echo.init();
    this.initEasyPieChart($('.js-chart'));
  }

  initEasyPieChart($element) {
    let colorPrimary = $('.js-pie-chart-hover').css('color');
    $element.easyPieChart({
      animate: 2000,
      size: 60,
      barColor: colorPrimary,
      trackColor: '#e1e1e1',
      scaleLength: 0,
      lineWidth: 5,
      onStart: function() {
        $('.js-pie-chart-hover').removeClass('hidden');
      },
      onStep: function (from, to, percent) {
        if (Math.round(percent) == 100) {
          $(this.el).addClass('done');
        }
        $(this.el).find('.js-course__percent').html('通过率<br>'+Math.round(percent) + '%');
      }
    });
  }
}

new Page();