import notify from 'common/notify';

export default class Create {
  constructor($element) {
    this.$element = $element;
    this.$projectPlanType = this.$element.find('.js-project-plan-type');
    this.$currentType = this.$element.find('.js-project-plan-type.active');
    this.init();
    this.initDateTimePicker();
  }

  init() {
    this.validator = this.$element.validate({
      rules: {
        name: {
          byte_maxlength: 200,
          required: {
            depends () {
              $(this).val($.trim($(this).val()));
              return true;
            }
          },
          course_title: true
        },
        startDateTime: {
          required: true,
        },
        endDateTime: {
          required: true,
          endDate_check: true,
        },
        orgCode: {
          required: true,
        },
        publishOrg: {
          publish_org_check: true,
        },
        accessOrg: {
          access_org_check: true,
        }
      },
      messages: {
        name: {
          required: Translator.trans('project_plan.create.name.required_message'),
          trim: Translator.trans('project_plan.create.name.required_message'),
        },
        publishOrg: {
          required: Translator.trans('advanced_user_select.department_input'),
          trim: Translator.trans('advanced_user_select.department_input'),
        },
        startDateTime: {
          required: Translator.trans('project_plan.base.start_time.required_message'),
        },
        endDateTime: {
          required: Translator.trans('project_plan.base.end_time.required_message'),
        },
      }
    });

    $('#project-plan-create-btn').on('click', (e) => {
      let $target = $(e.target);
      if (this.validator.form()) {
        if ($('.js-project-plan-type.active').data('type') == 'template' && $('#templateId').val() == 0) {
          notify('danger', Translator.trans('project_plan.please_choose_template'));
        } else {
          $('#project-plan-create-btn').button('loading').addClass('disabled');
          this.$element.submit();
        }
      }
    });

    this.$projectPlanType.click(event => {
      this.$projectPlanType.removeClass('active');
      this.$currentType = $(event.currentTarget).addClass('active');
      $('input[name="type"]').val(this.$currentType.data('type'));
      if (this.$currentType.data('type') === 'template') {
        $('.js-choose-template').removeClass('hidden');
      } else {
        $('.js-choose-template').addClass('hidden');
        $('#templateId').val(0);
      }
    });
  }

  initDateTimePicker() {
    $('#startDateTime, #endDateTime').datetimepicker({
      format: 'yyyy-mm-dd',
      language: document.documentElement.lang,
      minView: 2,
      autoclose: true,
      startView: 2
    });

    $('#startDateTime').on('changeDate',function(){
      $('#endDateTime').datetimepicker('setStartDate',$('#startDateTime').val().substring(0,16));
    });

    $('#endDateTime').on('changeDate',function(){
      $('#startDateTime').datetimepicker('setEndDate',$('#endDateTime').val().substring(0,16));
    });
  }

}


jQuery.validator.addMethod('publish_org_check', function () {
  let showable = $('[name = showable]').val();
  let publishOrg = $('[name = publishOrg]').val();
  if(showable == 0 || (publishOrg.length>0&&showable == 1)){
    return  true;
  }
  return  false;
},  Translator.trans('source.source_publish.select_org'));

jQuery.validator.addMethod('access_org_check', function () {
  let conditionalAccess = $('[name = conditionalAccess]').val();
  let AccessOrg = $('[name = accessOrg]').val();
  if(conditionalAccess == 0 || (AccessOrg.length>0 && conditionalAccess == 1)){
    return  true;
  }
  return  false;
},  Translator.trans('source.source_publish.select_org'));

jQuery.validator.addMethod('endDate_check', function () {
  let startDate = $('[name="startDateTime"]').val();
  let endDate = $('[name="endDateTime"]').val();
  return (startDate <= endDate);
},  Translator.trans('project_plan.base.end_date_check'));