import notify  from 'common/notify';

let $form = $('.js-answer-survey');
let rules = {};
let missQuestions = [];
let $question = $('.js-answer-survey').find('.question');

$question.each(function(index, item) {
  if ($(this).data('type') === 'evaluation') {
    let $evaluationItem = $(this).find('.evaluation-item');
    $evaluationItem.each(function (index, element) {
      let name = $(this).find('input:radio').attr('name');
      rules[name] = {
        required: true
      };
    });
  } else {
    let name = $(this).data('questionnaire-item-id');
    let isOptional = $(this).data('is-optional');
    if (!isOptional) {
      rules[name] = {
        required: true
      };
    }
  }
});

$question.each(function(index, item) {
  $(this).data('errorArray', []);
});

let validator = $form.validate({
  highlight: function (element, errorClass, validClass) {
    let $question = $(element).closest('.question');
    let name = $(element).attr('name');
    let errorArray = $question.data('errorArray');

    if (errorArray.indexOf(name) < 0) {
      errorArray.push(name);
    }

    missQuestions.push($(element).closest('.question').attr('id'));
    $(element).closest('.question').find('.question__title').addClass('is-not-answer')
      .find('.js-error-span').text(Translator.trans('survey.do.please_answer_survey'));
  },
  unhighlight: function (element, errorClass, validClass) {


    let $question = $(element).closest('.question');
    let name = $(element).attr('name');

    let errorArray = $question.data('errorArray');
    let index = errorArray.indexOf(name);

    if ( index >= 0) {
      errorArray.splice(index, 1);
    }

    if (!errorArray.length) {
      $(element).closest('.question').find('.question__title').removeClass('is-not-answer')
        .find('.js-error-span').text('');
    }

  },
  errorPlacement: function (error, element) {

  },
  rules: rules
});

function _checkEvaluation (targetKey, data) {
  let count =$('input[name^=\'' + targetKey + '\']').length / 5;
  for (let i=0; i < count; i++) {
    let t = targetKey + i;
    if (data[t]) {
      continue;
    } else {
      data[t] = ['0'];
    }
  }
  return data;
}

$('.js-answer-survey-btn').on('click', function() {
  let url = $('.js-answer-survey-btn').data('gotoUrl');
  let validate = validator.form();
  if (missQuestions.length > 0) {
    let a = document.createElement('a');
    a.href = '#'+missQuestions[0];
    a.click();
  }
  missQuestions.length = 0;

  if (validate) {
    let t = $form.serializeArray();
    $.post('/', $form.serializeArray());

    let data = {};
    for (let i = 0; i < t.length; i++) {
      if (data[t[i].name] == undefined) {
        data[t[i].name] = [];
      }
      data[t[i].name].push(t[i].value);
    }

    if (data['questionnaireItem-id']) {
      for (let j =0; j < data['questionnaireItem-id'].length; j++) {
        let targetId = data['questionnaireItem-id'][j];
        let targetKey = targetId + '-';
        _checkEvaluation(targetKey, data);
        $.each(data, function (key, val) {
          if (key.startsWith(targetKey)) {
            if (data[targetId]) {
              data[targetId].push(val[0]);
            } else {
              data[targetId] = val;
            }
            delete data[key];
          }
        });
        delete data['questionnaireItem-id'][j];
      }
    }

    $.post($form.data('url'), data, function (result) {
      if (result) {
        notify('success', Translator.trans('survey.do.survey_submit_success'));
        window.location.href = url;
      }
    }).error(function () {
      notify('warning', Translator.trans('survey.do.survey_submit_failed'));
    });
  }
});
$('.question-item-list .tab-control').on('click', function(e){
  if(e.target.nodeName.toLocaleLowerCase() === 'td'){
    let len = $(e.target).find('input[type=\'radio\']').length;
    if(len){
      $(e.target).parent().find('input[type=\'radio\']').removeAttr('checked');
      $(e.target).find('input[type=\'radio\']').prop('checked', true);
    }
  }
});