class Page {
  constructor() {
    this.init();
    this.initpopover();
  }

  init() {
    echo.init();
    this.initEasyPieChart($('.js-chart'));
  }

  initpopover() {
    $('.popover-expansion').click(function () {
      $(this).popover('show');
    });

    $(document).mouseup(function (e) {
      var con = $('.popover');   // 设置目标区域
      if (!con.is(e.target) && con.has(e.target).length === 0) {
        $('.popover-expansion').popover('hide');
      }
    });
  }

  initEasyPieChart($element) {
    let colorPrimary = $('.js-pie-chart-hover').css('color');
    $element.easyPieChart({
      animate: 2000,
      size: 60,
      barColor: colorPrimary,
      trackColor: '#e1e1e1',
      scaleLength: 0,
      lineWidth: 5,
      onStart: function () {
        $('.js-pie-chart-hover').removeClass('hidden');
      },
      onStep: function (from, to, percent) {
        if (Math.round(percent) == 100) {
          $(this.el).addClass('done');
        }
        $(this.el).find('.js-course__percent').html(Translator.trans('project_plan.user_detail.exam_passing_rate')+'<br>' + Math.round(percent) + '%');
      }
    });
  }
}

new Page();
