import notify  from 'common/notify';
import Sortable from 'common/sortable';
import onlineCourse from './online-course/base';
import onlineExam from './online-exam/base';
import offlineCourse from './offline-course/base';
import offlineExam from './offline-exam/base';
import questionnaire from './questionnaire/base';

export default class ItemManage {
  constructor() {
    this._initItemManage();
    this.$element = $('#item-container');
  }

  _initItemManage(){
    let self = this;
    $('#item-type-choose-btn').click(function () {
      $.get($(this).data('url'), function(result){
        $('#item-container').html(result);
        self.initPopover();
      });
    });

    $('#item-container').on('click','.js-item-manage-cancel-btn', function () {
      window.location.reload();
    });

    let $sortableList = $('#sortable-list');
    new Sortable({
      element: '#sortable-list',
      ajax: false
    }, function(data) {
      $.post($sortableList.data('sorturl'), { ids: data }, (response) => {

      });

      $sortableList.find('.drag').each(function(index, item) {
        $(item).find('.js-project-unit-number').text(`${index + 1}.`);
      });
    });

    $('#item-container').on('click', '.js-unit-addition-select-item', function() {
      $(this).addClass('active');
      let $selectItem = this;
      $.get($(this).data('url'), function(result){
        $('#item-container').html(result);
        self.initCreateItemJs($($selectItem).data('type'));
      });
    });

    $('#item-container').on('click', '.js-item-update', function() {
      let $selectItem = this;
      $.get($(this).data('url'), function(result){
        $('#item-container').html(result);
        self.initCreateItemJs($($selectItem).data('type'));
      });
    });


    $('[id=remove-item]').click(function () {
      if (!confirm(Translator.trans('project_plan.item.remove_confirm_message'))) {
        return;
      }
      $.post($(this).data('url'), function(result){
        if (result) {
          notify('success', Translator.trans('project_plan.item.remove_success_message'));
          window.location.reload();
        } else {
          notify('danger', Translator.trans('project_plan.item.remove_error_message'));
        }
      }).error(function() {
        notify('danger', Translator.trans('project_plan.item.remove_error_message'));
      });
    });

  }

  initPopover(){
    $('#item-container').find('.js-data-popover').popover({
      html: true,
      trigger: 'hover',
      placement: 'top',
      content: $('.popover-content').html()
    });
  }

  initCreateItemJs(type) {
    switch (type) {
    case 'course':
      new onlineCourse(this.$element);
      break;
    case 'offlineCourse':
      new offlineCourse(this.$element);
      break;
    case 'exam':
      new onlineExam(this.$element);
      break;
    case 'offlineExam':
      new offlineExam(this.$element);
      break;
    case 'questionnaire':
      new questionnaire(this.$element);
      break;

    }

  }
}

new ItemManage();
