import notify from 'common/notify';

export default class Create {
  constructor() {
    this.$element = $('#offline-course-form');
    this.$offlineCourseType = this.$element.find('.js-offline-course-type');
    this.$currentType = this.$element.find('.js-offline-course-type.active');
    this.init();
    this.initTeacher();
    this.initDateTimePicker();
    this.$signSeq = [];
    this.$signTimePickerNum = [];
    this.$curHomeworkNum = [];
    this.$maxSignTimePicker = 0;
    this.$maxCurHomeworkNum = 0;
    this.$signNum = $('.js-sign-num').val();
    this.$homeworkNum = $('.js-homework-num').val();
    if (this.$signNum >= 1) {
      for (let i=1; i <= this.$signNum; i++) {
        this.initSignDateTimePicker(i);
      }
    }

    if (this.$signNum === 0) {
      this.initSignDateTimePicker(1);
    }

    if (this.$homeworkNum >= 1) {
      for (let j=1; j <= this.$homeworkNum; j++) {
        this.initHomeworkDateTimePicker(j);
      }
    }

    if (this.$homeworkNum === 0) {
      this.initHomeworkDateTimePicker(1);
    }
  }

  addValidatorMethod() {
    $.validator.addMethod('endTime_check', function () {
      let statTime = $('[name="startTime"]').val();
      let endTime = $('[name="endTime"]').val();

      return (statTime <= endTime);
    },  Translator.trans('offline_class.validator_message.end_date_check'));

    $.validator.addMethod('signEndTime_check', function (value, element, param) {
      let statTime = $(`[name="signStartTime[${param}]"]`).val();
      let endTime = $(`[name="signEndTime[${param}]"]`).val();

      return (statTime <= endTime);
    },  Translator.trans('offline_class.validator_message.end_date_check'));
  }

  init() {
    this.addValidatorMethod();
    $('[data-toggle="tooltip"]').tooltip();

    let self = this;
    self.validator = self.$element.validate({
      currentDom: '#offline-course-btn',
      rules: {
        title: {
          maxlength: 200,
          required: {
            depends () {
              $(this).val($.trim($(this).val()));
              return true;
            },
            trim: true,
          },
        },
        place: {
          maxlength: 60,
          required: {
            depends () {
              $(this).val($.trim($(this).val()));
              return true;
            },
          }
        },
        teacherId: {
          required: true
        },
        time: {
          min: 0,
          max: 99,
          time_check: true
        },
        startTime: {
          required: true
        },
        endTime: {
          required: true,
          endTime_check: true,
        },
        'signStartTime[1]': {
          required: true
        },
        'signEndTime[1]': {
          required: true,
          signEndTime_check: 1,
        },
        'homeworkDemand[1]': {
          required: true
        },
        'homeworkDeadline[1]': {
          required: true
        }
      },
      messages: {
        title: {
          required: Translator.trans('请输入课程名称'),
        },
        teacherId: {
          required: Translator.trans('请选择课程讲师'),
        },
        place: {
          required: Translator.trans('请输入上课地点'),
        },
        startTime: {
          required: Translator.trans('请输入上课开始时间'),
        },
        endTime: {
          required: Translator.trans('请输入上课结束时间'),
        },
        'signEndTime[1]': {
          required: Translator.trans('请输入结束时间'),
        },
        'signStartTime[1]': {
          required: Translator.trans('请输入开始时间'),
        },
        'homeworkDemand[1]': {
          required: Translator.trans('请输入作业要求'),
        },
        'homeworkDeadline[1]': {
          required: Translator.trans('请输入截止时间'),
        }
      }
    });

    this.$offlineCourseType.click(event => {
      this.$offlineCourseType.removeClass('active');
      this.$currentType = $(event.currentTarget).addClass('active');
      $('input[name="type"]').val(this.$currentType.data('type'));
      if (this.$currentType.data('type') === 'template') {
        $('.js-choose-template').removeClass('hidden');
      } else {
        $('.js-choose-template').addClass('hidden');
        $('#templateId').val(0);
      }
    });

    $('#js-create-sign').on('click', (e) => {
      if ($('.js-sign-seq').length < 10) {
        let number = $('.js-sign-seq').length + 1;
        let curTimeNum = 0;
        if (this.$maxSignTimePicker != 0) {
          curTimeNum = this.$maxSignTimePicker + 1;
          this.$maxSignTimePicker ++;
        } else {
          curTimeNum = number;
        }
        $('.js-sign-contains').append(`
          <div class="form-group js-sign-html">
            <label class="col-md-2 control-label" for="time"></label>
            <div class="col-sm-8 controls">
              <div class="col-md-3 controls mts" style="margin-right: -50px; margin-left:-10px;">
                第<span class="js-sign-seq" data-value="${number}">${number}</span>次签到
              </div>
              <div class="col-md-4 controls">
                <input type="text" data-value="${curTimeNum}" id="signStartTime${curTimeNum}" name="signStartTime[${curTimeNum}]" data-url="" class="form-control js-signStartTime" for="signStartTime" placeholder="${Translator.trans('offline_course_sign.start_time')}" autocomplete="off">
              </div>
              <div class="col-md-4 controls">
                <input type="text" data-value="${curTimeNum}" id="signEndTime${curTimeNum}" name="signEndTime[${curTimeNum}]" data-url="" class="form-control js-signEndTime" for="signEndTime" placeholder="${Translator.trans('offline_course_sign.end_time')}" autocomplete="off">
              </div>
              <span class="es-icon es-icon-delete mrm dis-i-b mtm delete-sign"></span>
            </div>
          </div>
        `);
        this.initSignDateTimePicker(curTimeNum);
        $('.js-sign-num').val(number);
        $('#signStartTime'+curTimeNum).rules('add', {
          required: true,
          messages: {
            required: Translator.trans('请输入开始时间'),
          }
        });
        $('#signEndTime'+curTimeNum).rules('add', {
          required: true,
          signEndTime_check: curTimeNum,
          messages: {
            required: Translator.trans('请输入结束时间'),
          }
        });

        $('.js-sign-seq').each(function (key, value) {
          self.$signSeq[key] = $(this).data('value');
        });
      } else {
        notify('danger', Translator.trans('最多只能设置10个签到'));
      }
    });

    $('.js-sign-contains').on('click', '.delete-sign', (e) => {
      $(e.target).parents('.form-group').find('.signStartTime').rules('remove');
      $(e.target).parents('.form-group').find('.signEndTime').rules('remove');
      $(e.target).parents('.form-group').remove();
      self.$signNum = $('.js-sign-seq').length;
      $('.js-sign-seq').each(function (key, value) {
        $(this).html(key+1);
      });
      $('.js-signStartTime').each(function (key, val) {
        self.$signTimePickerNum[key] = $(this).data('value');
      });

      for(let k=0;k<self.$signTimePickerNum.length;k++)
      {
        if(self.$signTimePickerNum[k]>this.$maxSignTimePicker) {
          this.$maxSignTimePicker = self.$signTimePickerNum[k];
        }
      }
    });

    $('#js-create-homework').on('click', (e) => {
      if ($('.js-homework-seq').length < 5) {
        let homeworkNum = $('.js-homework-seq').length + 1;
        let curHomeworkNum = 0;
        if (this.$maxCurHomeworkNum != 0) {
          curHomeworkNum = this.$maxCurHomeworkNum + 1;
          this.$maxCurHomeworkNum ++;
        } else {
          curHomeworkNum = homeworkNum;
        }
        $('.js-homework-contains').append(`
         <div class="js-homework">
          <div class="form-group">
            <label class="col-md-2 control-label" for="homework"></label>
            <div class="col-md-8 controls">
              <div class="col-md-3 controls" style="margin-right: -50px; margin-left:-10px;">
                第<span class="js-homework-seq" data-value="${homeworkNum}">${homeworkNum}</span>份作业 <span class="es-icon es-icon-delete mrm dis-i-b mtm delete-homework"></span>
              </div>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-2 control-label" for="homeworkDemand"></label>
            <div class="col-md-8 controls">
              <div class="col-md-3 controls" style="margin-right: -65px; margin-left:-10px;">
                <span>作业要求</span>
              </div>
              <div class="col-md-8 controls">
                <textarea id="homeworkDemand${curHomeworkNum}" data-value="${curHomeworkNum}" name="homeworkDemand[${curHomeworkNum}]" class="form-control homeworkDemand" rows="4" placeholder="添加作业描述，可以提交附件文件。支持word，ppt，pdf，视频，音频等形式作业在线预览。"></textarea>
              </div>
            </div>
          </div>
          <div class="form-group">
            <label class="col-md-2 control-label" for="homeworkDeadline"></label>
            <div class="col-sm-8 controls">
              <div class="col-md-3 controls mts" style="margin-right: -65px; margin-left:-10px;">
                <span>截止时间</span>
              </div>
              <div class="col-md-4 controls">
                <input type="text" id="homeworkDeadline${curHomeworkNum}" data-value="${curHomeworkNum}" name="homeworkDeadline[${curHomeworkNum}]" data-url="" class="form-control js-cur-homework-num homeworkDeadline" for="homeworkDeadline" placeholder="选择日期" autocomplete="off">
              </div>
            </div>
          </div>
          </div>
        `);

        this.initHomeworkDateTimePicker(curHomeworkNum);
        $('.js-homework-num').val(homeworkNum);
        $('#homeworkDeadline'+curHomeworkNum).rules('add', {
          required: true,
          messages: {
            required: Translator.trans('请输入截止时间'),
          }
        });

        $('#homeworkDemand'+curHomeworkNum).rules('add', {
          required: true,
          messages: {
            required: Translator.trans('请输入作业要求'),
          }
        });
      } else {
        notify('danger', Translator.trans('最多只能设置5个作业'));
      }
    });

    $('.js-homework-contains').on('click', '.delete-homework', (e) => {
      $(e.target).parents('.js-homework').find('.homeworkDemand').rules('remove');
      $(e.target).parents('.js-homework').find('.signEndTime').rules('remove');
      $(e.target).parents('.js-homework').remove();
      self.$homeworkNum = $('.js-homework-seq').length;
      $('.js-homework-seq').each(function (key, value) {
        $(this).html(key+1);
      });
      $('.js-cur-homework-num').each(function (key, val) {
        self.$curHomeworkNum[key] = $(this).data('value');
      });

      for(let k=0;k<self.$curHomeworkNum.length;k++)
      {
        if(self.$curHomeworkNum[k]>this.$maxCurHomeworkNum) {
          this.$maxCurHomeworkNum = self.$curHomeworkNum[k];
        }
      }
    });
    
    $('#offline-course-btn').click(event => {
      if (self.validator.form()) {
        if ($('.js-offline-course-type.active').data('type') == 'template' && $('#templateId').val() == 0) {
          notify('danger', Translator.trans('project_plan.please_choose_template'));
        } else {
          $('#offline-course-btn').button('loading');
          $.post(this.$element.prop('action'), this.$element.serialize(),function (result) {
            if (result) {
              notify('success', Translator.trans('project_plan.save_success'));
              window.location.reload();
            } else {
              $('#offline-course-btn').button('reset');
              notify('danger', Translator.trans('project_plan.save_error'));
            }
          }).error(function() {
            $('#offline-course-btn').button('reset');
            notify('danger', Translator.trans('project_plan.save_error'));
          });
        }
      }
    });

    $('#startTime').on('change', function () {
      if ($('#signStartTime1').val() == '') {
        let date = new Date(new Date($('#startTime').val().replace(/-/g,'/')).getTime() - 15*600*100);
        let Y = date.getFullYear() + '-';
        let M = (date.getMonth()+1 < 10 ? '0'+(date.getMonth()+1) : date.getMonth()+1) + '-';
        let D = date.getDate() < 10 ? '0'+date.getDate() + ' ' : date.getDate() + ' ';
        let h = date.getHours() < 10 ? '0'+date.getHours() + ':' : date.getHours() + ':';
        let m = date.getMinutes() < 10 ? '0'+date.getMinutes() : date.getMinutes();
        console.log(date.getFullYear());
        $('#signStartTime1').val(Y+M+D+h+m);
      }
    });

    $('#endTime').on('change', function () {
      if ($('#signEndTime1').val() == '') {
        let date = new Date(new Date($('#endTime').val().replace(/-/g,'/')).getTime() + 15*600*100);
        let Y = date.getFullYear() + '-';
        let M = (date.getMonth()+1 < 10 ? '0'+(date.getMonth()+1) : date.getMonth()+1) + '-';
        let D = date.getDate() < 10 ? '0'+date.getDate() + ' ' : date.getDate() + ' ';
        let h = date.getHours() < 10 ? '0'+date.getHours() + ':' : date.getHours() + ':';
        let m = date.getMinutes() < 10 ? '0'+date.getMinutes() : date.getMinutes();

        $('#signEndTime1').val(Y+M+D+h+m);
      }
    });
  }

  initSignDateTimePicker(number) {
    $('#signEndTime'+number).datetimepicker({
      format: 'yyyy-mm-dd hh:ii',
      language: document.documentElement.lang,
      minView: 0,
      autoclose: true,
      startView: 2
    });

    $('#signStartTime'+number).datetimepicker({
      format: 'yyyy-mm-dd hh:ii',
      language: document.documentElement.lang,
      minView: 0,
      autoclose: true,
      startView: 2
    });

    $('#signStartTime'+number).on('changeDate',function(){
      $('#signStartTime'+number).datetimepicker('signStartTime'+number,$('#signStartTime'+number).val().substring(0,16));
    });

    $('#signEndTime'+number).on('changeDate',function(){
      $('#signEndTime'+number).datetimepicker('signEndTime'+number,$('#signEndTime'+number).val().substring(0,16));
    });
  }

  initHomeworkDateTimePicker(number) {
    $('#homeworkDeadline'+number).datetimepicker({
      format: 'yyyy-mm-dd hh:ii',
      language: document.documentElement.lang,
      minView: 0,
      autoclose: true,
      startView: 2
    });

    $('#homeworkDeadline'+number).on('changeDate',function(){
      $('#homeworkDeadline'+number).datetimepicker('homeworkDeadline'+number,$('#homeworkDeadline'+number).val().substring(0,16));
    });
  }

  initDateTimePicker() {
    if ($('#startTime').attr('readonly') || $('#endTime').attr('readonly')) {
      return;
    }

    $('#startTime, #endTime').datetimepicker({
      format: 'yyyy-mm-dd hh:ii',
      language: document.documentElement.lang,
      minView: 0,
      autoclose: true,
      startView: 2
    });

    $('#startTime').on('changeDate',function(){
      $('#endTime').datetimepicker('setStartDate',$('#startTime').val().substring(0,16));
    });

    $('#endTime').on('changeDate',function(){
      $('#startTime').datetimepicker('setEndDate',$('#endTime').val().substring(0,16));
    });
  }

  initTeacher() {
    const $teacher = $('#teacherId');
    $teacher.select2({
      ajax: {
        url: $teacher.data('url'),
        dataType: 'json',
        quietMillis: 500,
        data (term, page) {
          return {
            q: term,
            page_limit: 10
          };
        },
        results (data) {
          data.map(function (item) {
            item.itemId = item.id;
          });
          return {
            results: data
          };
        }
      },
      initSelection (element, callback) {
        callback(callback($(element).data('jsonValue')));
      },
      formatSelection(item) {

        return item.truename+`(${item.nickname})`;
      },
      formatResult(item) {
        return item.truename+`(${item.nickname})`;
      },
      formatSearching: function() {
        return Translator.trans('site.searching_hint');
      },
      multiple: false,
      maximumSelectionSize: 20,
      placeholder: Translator.trans('use_authorization.select_placeholder'),
      width: 'off',
      createSearchChoice () {
        return null;
      }
    });
  }
}

jQuery.validator.addMethod('time_check',function(value,element){
  return this.optional( element ) || /^[0-99]+(\.[0-9]?)?$/.test(value);
}, Translator.trans('请输入0-99的数值,最多保留一位小数'));
