import notify from 'common/notify';

export default class Base {
  constructor($element) {
    this.$element = $element;
    this.selectCourseIds = [];
    this.$form = $element.find('#questionnaire-form');
    if(this.$form.length){
      this.initSelect2OfflineCourses();
      this.initDateTimePicker();
      let self = this;
      this.$element.find('.project-plan-sortable-item').each(function() {
        self.selectCourseIds.push($(this).data('id'));
      });
    }
  }

  initSelect2OfflineCourses() {
    const self = this;
    this.data = {};
    self.tempArr = $('[name=projectPlanCourses]').val();

    let $postsContainer = $('#changeModalTargetId');
    $postsContainer.select2({
      ajax: {
        url: $postsContainer.data('url'),
        dataType: 'json',
        quietMillis: 100,
        data: function (term, page) {
          return {
            courseIds: self.selectCourseIds,
            q: term,
            page_limit: 10
          };
        },
        results: function (data) {
          var results = [];
          $.each(data, function (index, item) {
            results.push({
              id: item.id,
              name: item.title + '；编号：' + item.id
            });
            self.data[item.id] = item.title;
          });

          return {
            results: results
          };

        }
      },
      formatSelection: function (item) {
        return Translator.trans('输入课程标题关键字搜索更多课程');
      },
      formatResult: function (item) {
        return item.name;
      },
      placeholder: Translator.trans('输入课程标题关键字搜索更多课程')
    });

    $postsContainer.on('select2-selected', function (e) {
      const exp = new RegExp(`(^|,)${e.val}($|,)`, 'ig');
      let $sortable = $('.js-ct-sortable');

      if (typeof $sortable.sortable('serialize').get()[0] === 'object') {
        $('[name=projectPlanCourses]').val(self.tempArr);
      } else {
        if (self.tempArr) {
          $('[name=projectPlanCourses]').val(self.tempArr+','+$sortable.sortable('serialize').get()[0]);
        } else {
          $('[name=projectPlanCourses]').val($sortable.sortable('serialize').get()[0]);
        }
      }

      if (!exp.test($('[name=projectPlanCourses]').val())) {
        self.$sortable.append(self.renderSortableItem({
          id: e.val,
          name: self.data[e.val]
        }));
        self.selectCourseIds =[];
        self.$element.find('.project-plan-sortable-item').each(function() {
          self.selectCourseIds.push($(this).data('id'));
        });
      } else {
        notify('warning', '重复添加课程');
      }

    });

    let validator = this.$form.validate({
      rules: {
        startTime: {
          required: true,
          startTime_input_check: true
        },
        questionnaireId: {
          required: true,
          questionnaireId_check: true,
        },
        targetId: {
          targetId_check: true,
        },

      },
      messages: {
        startTime: {
          required: Translator.trans('请选择开始时间'),
        },
        endTime: {
          required: Translator.trans('请选择结束时间'),
        },
      }
    });
    self.$element.find('#questionnaire-submit').click(function () {

      if (validator.form()) {
        self.$element.find('#questionnaire-submit').button('loading');
        $.post(self.$form.attr('action'), self.$form.serialize()+'&offlineCourseIds='+self.selectCourseIds, function (result) {
          if (result) {
            notify('success', '保存成功!');
            window.location.reload();
          } else {
            notify('danger', '保存失败!');
          }
        }).error(function() {
          notify('danger', '保存失败!');
        });
      }
    });

    this.initsortable();
  }

  initsortable() {
    let $sortable = this.$element.find('.js-ct-sortable');
    this.$sortable = $sortable;
    let self = this;
    $sortable.sortable({
      distance: 20,
      onDrop: function ($item, container, _super) {
        self.setSortableValue();
        _super($item, container);
      },

      serialize: function (parent, children, isContainer) {
        return isContainer ? children.join() : $(parent).data('id');
      }
    });

    $sortable.on('click', '.js-close-icon', function () {
      self.selectCourseIds =[];
      $(this).parent().remove();
      self.$element.find('.project-plan-sortable-item').each(function() {
        self.selectCourseIds.push($(this).data('id'));
      });
    });
  }

  setSortableValue() {
    let $sortable = this.$sortable;
    $('[name=projectPlanCourses]').val($sortable.sortable('serialize').get()[0]);
  }

  renderSortableItem(opts) {
    return `<li class="project-plan-sortable-item" data-id="${opts.id}">
                    <i class="project-plan-sortable-item__icon es-icon es-icon-yidong mrl gray-medium vertical-middle"></i>
                    <span class="project-plan-sortable-item__info">
                      课程：${opts.name}
                    </span>
                    <span class="gray-medium">；</span>
                    <span class="project-plan-sortable-item__info">编号：${opts.id}</span>
                        <a class="project-plan-sortable-item__close-btn js-close-icon" href="javascript:;">
                            <i class="es-icon es-icon-close01 pull-right "></i>
                        </a>
                </li>`;
  }

  initDateTimePicker() {
    $('[name=startTime]').datetimepicker({
      autoclose: true,
      language: document.documentElement.lang,
      format: 'yyyy-mm-dd hh:ii',
      startDate:  new Date(Date.now()+5*60)
    });

  }
}

$.validator.addMethod('startTime_input_check', function (value, element, params) {
  let startTime = new Date(value.replace(/-/g, '/'));
  return this.optional(element) || startTime >= new Date();
},
Translator.trans('开始时间应大于等于当前时间')
);
jQuery.validator.addMethod('questionnaireId_check', function () {
  var questionnaireId = $('[name="questionnaireId"]').val();
  return questionnaireId > 0;
}, Translator.trans('survey.manage.survey_please_choose_questionnaire'));

jQuery.validator.addMethod('targetId_check', function () {
  let $sortable = $('.js-ct-sortable');
  if (typeof $sortable.sortable('serialize').get()[0] === 'object') {
    return false;
  }
  return true;
}, Translator.trans('请选择课程'));