<?php

namespace Omnipay\Alipay\Requests;

use Omnipay\Alipay\Responses\AopTradeQueryResponse;
use Omnipay\Common\Exception\InvalidRequestException;
use Omnipay\Common\Message\ResponseInterface;
/**
 * Class AopTradeQueryRequest
 * @package Omnipay\Alipay\Requests
 * @link    https://doc.open.alipay.com/docs/api.htm?docType=4&apiId=757
 */
class AopTradeQueryRequest extends \Omnipay\Alipay\Requests\AbstractAopRequest
{
    protected $method = 'alipay.trade.query';
    /**
     * Send the request with specified data
     *
     * @param  mixed $data The data to send
     *
     * @return ResponseInterface
     * @throws InvalidRequestException
     */
    public function sendData($data)
    {
        $data = parent::sendData($data);
        return $this->response = new \Omnipay\Alipay\Responses\AopTradeQueryResponse($this, $data);
    }
    public function validateParams()
    {
        parent::validateParams();
        $this->validateBizContentOne('trade_no', 'out_trade_no');
    }
}