/*********************************************************
* EGE (Easy Graphics Engine)
* FileName      ege.h
* HomePage1     http://misakamm.github.com/xege
* HomePage2     http://misakamm.bitbucket.org/index.htm
* teiba1        http://tieba.baidu.com/f?kw=ege
* teiba2        http://tieba.baidu.com/f?kw=ege%C4%EF
* Blog:         http://misakamm.com
* E-Mail:       mailto:misakamm[at gmail com]
*
* FileName: ege.h
*  VC ģ Borland BGI ͼ⣬ʵּ򵥵Ļͼ֮࣬չ˽ϸӵĻͼ
*
* ʹñʱҪconio.hͷļ
* ЩͷļӦ棬ܻ
* getchconio.hڵĸǣɰע
* 蹲棬ʹöļֿģʽʹã
* һcppͬʱԷֿ
* ʹñ⣬C++룬ֵ֧ı
* VC6/VC2008/VC2010/VC2012/VC2013/MinGW3.4.5/MinGW4.7.1/MinGW4.8.1
*********************************************************/

/****************************************************************************
** ע
* Ҫʾ̨ڣڰļǰһdefine SHOW_CONSOLE
* SleepAPIʱߵdelayʵʾתΪdelay_msAPIʹapi_sleep
* delay_ms(0)жûиµıҪεĵò֡ʵӰ
* delay_ms, delay_fps, getch, getkey, getmouse ʱݿܻ£Щ൱delay_ms(0)
*   ֻҪ´ڣȴdelay_ms(0)עdelayֻʱ´
* ʹdelay_ms/delay_fpsԼĳռõCPUһûеͬʱҲûgetch/getmouseĻռһCPUʱ
****************************************************************************/

#ifndef _EGE_H_
#define _EGE_H_

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
#pragma once
#endif

#ifndef __cplusplus
#error You must use C++ compiler, or you need filename with '.cpp' suffix
#endif

#if defined(_INC_CONIO) || defined(_CONIO_H_)
#error can not include "conio.h" before "graphics.h"
#endif

#if defined(_MSC_VER)
#	pragma warning(disable: 4355)
#	ifndef _ALLOW_ITERATOR_DEBUG_LEVEL_MISMATCH
#		define _ALLOW_ITERATOR_DEBUG_LEVEL_MISMATCH
#	endif
#	ifndef _ALLOW_RUNTIME_LIBRARY_MISMATCH
#		define _ALLOW_RUNTIME_LIBRARY_MISMATCH
#	endif
#endif

#if !defined(_GRAPH_LIB_BUILD_) && !defined(_GRAPH_NO_LIB_)
#	ifdef _MSC_VER
#		pragma comment(lib,"gdiplus.lib")
#		ifdef _WIN64 // 64 bit libs
#			pragma comment(lib,"graphics64.lib")
#		else   // 32 bit libs
#			pragma comment(lib,"graphics.lib")
#		endif
#	endif
#endif

#if !defined(_GRAPH_LIB_BUILD_) && !defined(_GRAPH_NO_LIB_)
#ifndef _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#endif

#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE
#endif

#ifndef _CRT_NON_CONFORMING_SWPRINTFS
#define _CRT_NON_CONFORMING_SWPRINTFS
#endif

#endif

#include "windows.h"

#if defined(_MSC_VER) && _MSC_VER <= 1200 && !defined(SetWindowLongPtr)
#	define SetWindowLongPtrW   SetWindowLongW
#	define GetWindowLongPtrW   GetWindowLongW
#	define GWLP_USERDATA       GWL_USERDATA
#	define GWLP_WNDPROC        GWL_WNDPROC
#endif

#ifndef WM_MOUSEWHEEL
#define WM_MOUSEWHEEL                   0x020A
#endif

#ifndef _Cdecl
#	if __STDC__
#		define _Cdecl  __cdecl
#	else
#		define _Cdecl  __cdecl
#	endif
#endif

#ifdef _MSC_VER
#	if defined(_WIN64)
#		define EGEAPI
#	else
#		define EGEAPI _Cdecl
#	endif
#else
#	if defined(__WORDSIZE)
#		if __WORDSIZE > 32
#			define EGEAPI
#		else
#			define EGEAPI _Cdecl
#		endif
#	else
#		define EGEAPI
#	endif
#endif

#ifndef EGE_DEPRECATE
#	ifdef _MSC_VER
#		ifdef _CRT_DEPRECATE_TEXT
#			define EGE_DEPRECATE(text) _CRT_DEPRECATE_TEXT("This function is deprecated, more info visit http://tcgraphics.sourceforge.net/")
#		else
#			define EGE_DEPRECATE(text)
#		endif
#	else
#		define EGE_DEPRECATE(text) __attribute__((deprecated))
#	endif
#endif

#define SHOWCONSOLE             1       // ͼģʽʱ̨ʾ
#define EGERGBA(r, g, b, a)     ( ((r)<<16) | ((g)<<8) | (b) | ((a)<<24) )
#define EGERGB(r, g, b)         EGERGBA(r, g, b, 0xFF)
#define EGEARGB(a, r, g, b)     EGERGBA(r, g, b, a)
#define EGEACOLOR(a, color)     ( ((color) & 0xFFFFFF) | ((a)<<24) )
#define EGECOLORA(color, a)     EGEACOLOR(a, color)
#define EGEGET_R(c)             ( ((c)>>16) & 0xFF )
#define EGEGET_G(c)             ( ((c)>> 8) & 0xFF )
#define EGEGET_B(c)             ( ((c)) & 0xFF )
#define EGEGET_A(c)             ( ((c)>>24) & 0xFF )
#define EGEGRAY(gray)           EGERGB(gray, gray, gray)
#define EGEGRAYA(gray, a)       EGERGBA(gray, gray, gray, a)
#define EGEAGRAY(a, gray)       EGEGRAYA(gray, a)
#define NAMESPACE_EGE_L         namespace ege {
#define NAMESPACE_EGE_R         }

NAMESPACE_EGE_L

const double PI = 3.1415926535897932384626;

enum graphics_drivers {     /* define graphics drivers */
	DETECT,         /* requests autodetection */
	CGA, MCGA, EGA, EGA64, EGAMONO, IBM8514,/* 1 - 6 */
	HERCMONO, ATT400, VGA, PC3270,          /* 7 - 10 */
	TRUECOLOR, TRUECOLORSIZE,
	CURRENT_DRIVER = -1
};

enum graphics_modes { /* graphics modes for each driver */
	CGAC0       = 0,  /* 320x200 palette 0; 1 page  */
	CGAC1       = 1,  /* 320x200 palette 1; 1 page  */
	CGAC2       = 2,  /* 320x200 palette 2: 1 page  */
	CGAC3       = 3,  /* 320x200 palette 3; 1 page  */
	CGAHI       = 4,  /* 640x200 1 page             */
	MCGAC0      = 0,  /* 320x200 palette 0; 1 page  */
	MCGAC1      = 1,  /* 320x200 palette 1; 1 page  */
	MCGAC2      = 2,  /* 320x200 palette 2; 1 page  */
	MCGAC3      = 3,  /* 320x200 palette 3; 1 page  */
	MCGAMED     = 4,  /* 640x200 1 page             */
	MCGAHI      = 5,  /* 640x480 1 page             */
	EGALO       = 0,  /* 640x200 16 color 4 pages   */
	EGAHI       = 1,  /* 640x350 16 color 2 pages   */
	EGA64LO     = 0,  /* 640x200 16 color 1 page    */
	EGA64HI     = 1,  /* 640x350 4 color  1 page    */
	EGAMONOHI   = 0,  /* 640x350 64K on card, 1 page - 256K on card, 4 pages */
	HERCMONOHI  = 0,  /* 720x348 2 pages            */
	ATT400C0    = 0,  /* 320x200 palette 0; 1 page  */
	ATT400C1    = 1,  /* 320x200 palette 1; 1 page  */
	ATT400C2    = 2,  /* 320x200 palette 2; 1 page  */
	ATT400C3    = 3,  /* 320x200 palette 3; 1 page  */
	ATT400MED   = 4,  /* 640x200 1 page             */
	ATT400HI    = 5,  /* 640x400 1 page             */
	VGALO       = 0,  /* 640x200 16 color 4 pages   */
	VGAMED      = 1,  /* 640x350 16 color 2 pages   */
	VGAHI       = 2,  /* 640x480 16 color 1 page    */
	PC3270HI    = 0,  /* 720x350 1 page             */
	IBM8514LO   = 0,  /* 640x480 256 colors         */
	IBM8514HI   = 1   /*1024x768 256 colors         */
};

enum graphics_errors {      /* graphresult error return codes */
	grOk                =   0,
	grNoInitGraph       =  -1,
	grNotDetected       =  -2,
	grFileNotFound      =  -3,
	grInvalidDriver     =  -4,
	grNoLoadMem         =  -5,
	grNoScanMem         =  -6,
	grNoFloodMem        =  -7,
	grFontNotFound      =  -8,
	grNoFontMem         =  -9,
	grInvalidMode       = -10,
	grError             = -11,   /* generic error */
	grIOerror           = -12,
	grInvalidFont       = -13,
	grInvalidFontNum    = -14,
	grInvalidVersion    = -18,
	grException         = 0x10,  /* ege error */
	grParamError        = 0x11,
	grInvalidRegion     = 0x12,
	grOutOfMemory       = 0x13,
	grNullPointer       = 0x14,
	grAllocError        = 0x15,
	grInvalidMemory     = 0xCDCDCDCD,
};

enum message_event {
	MSG_EVENT_UP            = 0x00,
	MSG_EVENT_DOWN          = 0x01,
	MSG_EVENT_CLICK         = 0x01,
	MSG_EVENT_DBCLICK       = 0x02,
	MSG_EVENT_MOVE          = 0x04,
	MSG_EVENT_WHEEL         = 0x10,
};

enum message_mouse {
	MSG_MOUSE_LEFT      = 0x01,
	MSG_MOUSE_RIGHT     = 0x02,
	MSG_MOUSE_MID       = 0x04,
};

// ɫ
enum COLORS {
	BLACK           = EGERGB(0, 0, 0),
	BLUE            = EGERGB(0, 0, 0xA8),
	GREEN           = EGERGB(0, 0xA8, 0),
	CYAN            = EGERGB(0, 0xA8, 0xA8),
	RED             = EGERGB(0xA8, 0, 0),
	MAGENTA         = EGERGB(0xA8, 0, 0xA8),
	BROWN           = EGERGB(0xA8, 0xA8, 0),
	LIGHTGRAY       = EGERGB(0xA8, 0xA8, 0xA8),
	DARKGRAY        = EGERGB(0x54, 0x54, 0x54),
	LIGHTBLUE       = EGERGB(0x54, 0x54, 0xFC),
	LIGHTGREEN      = EGERGB(0x54, 0xFC, 0x54),
	LIGHTCYAN       = EGERGB(0x54, 0xFC, 0xFC),
	LIGHTRED        = EGERGB(0xFC, 0x54, 0x54),
	LIGHTMAGENTA    = EGERGB(0xFC, 0x54, 0xFC),
	YELLOW          = EGERGB(0xFC, 0xFC, 0x54),
	WHITE           = EGERGB(0xFC, 0xFC, 0xFC),
};

// ģʽ
enum fill_patterns {/* Fill patterns for get/setfillstyle */
	EMPTY_FILL,     /* fills area in background color */
	SOLID_FILL,     /* fills area in solid fill color */
	LINE_FILL,      /* --- fill */
	LTSLASH_FILL,   /* /// fill */
	SLASH_FILL,     /* /// fill with thick lines */
	BKSLASH_FILL,   /* \\\ fill with thick lines */
	LTBKSLASH_FILL, /* \\\ fill */
	HATCH_FILL,     /* light hatch fill */
	XHATCH_FILL,    /* heavy cross hatch fill */
	INTERLEAVE_FILL,/* interleaving line fill */
	WIDE_DOT_FILL,  /* Widely spaced dot fill */
	CLOSE_DOT_FILL, /* Closely spaced dot fill */
	USER_FILL       /* user defined fill */
};

enum text_just {        /* Horizontal and vertical justification
						for settextjustify */
	LEFT_TEXT   = 0,
	CENTER_TEXT = 1,
	RIGHT_TEXT  = 2,

	BOTTOM_TEXT = 0,
	/* CENTER_TEXT = 1,  already defined above */
	TOP_TEXT    = 2
};

enum line_styles {      /* Line styles for get/setlinestyle */
	SOLID_LINE      = PS_SOLID,
	CENTER_LINE     = PS_DASH,
	DOTTED_LINE     = PS_DOT,
	DASHED_LINE     = PS_DASHDOT,
	NULL_LINE       = PS_NULL,
	USERBIT_LINE    = PS_USERSTYLE,   /* User defined line style */
};

enum key_msg_flag {
	KEYMSG_CHAR_FLAG    = 2,
	KEYMSG_DOWN_FLAG    = 1,
	KEYMSG_UP_FLAG      = 1,

	KEYMSG_CHAR         = 0x40000,
	KEYMSG_DOWN         = 0x10000,
	KEYMSG_UP           = 0x20000,
	KEYMSG_FIRSTDOWN    = 0x80000,
};

enum music_state_flag {
	MUSIC_MODE_NOT_OPEN = 0x0,
	MUSIC_MODE_NOT_READY = 0x20C,
	MUSIC_MODE_PAUSE = 0x211,
	MUSIC_MODE_PLAY = 0x20E,
	MUSIC_MODE_STOP = 0x20D,
	MUSIC_MODE_OPEN = 0x212,
	MUSIC_MODE_SEEK = 0x210,
};

enum initmode_flag {
	INIT_DEFAULT        = 0x0,
	INIT_NOBORDER       = 0x1,
	INIT_CHILD          = 0x2,
	INIT_TOPMOST        = 0x4,
	INIT_RENDERMANUAL   = 0x8,
	INIT_NOFORCEEXIT    = 0x10,
	INIT_UNICODE        = 0x20,
	INIT_WITHLOGO       = 0x100,
	INIT_ANIMATION      = INIT_DEFAULT | INIT_RENDERMANUAL | INIT_NOFORCEEXIT,
};

enum rendermode_e {
	RENDER_AUTO,
	RENDER_MANUAL,
};

typedef enum key_code_e {
	key_mouse_l     = 0x01,
	key_mouse_r     = 0x02,
	key_mouse_m     = 0x04,
	key_back        = 0x08,
	key_tab         = 0x09,
	key_enter       = 0x0d,
	key_shift       = 0x10,
	key_control     = 0x11,
	key_menu        = 0x12,
	key_pause       = 0x13,
	key_capslock    = 0x14,
	key_esc         = 0x1b,
	key_space       = 0x20,

	key_pageup      = 0x21,
	key_pagedown    = 0x22,
	key_home        = 0x23,
	key_end         = 0x24,

	key_left        = 0x25,
	key_up          = 0x26,
	key_right       = 0x27,
	key_down        = 0x28,

	key_print       = 0x2a,
	key_snapshot    = 0x2c,
	key_insert      = 0x2d,
	key_delete      = 0x2e,

	key_0           = 0x30,
	key_1           = 0x31,
	key_2           = 0x32,
	key_3           = 0x33,
	key_4           = 0x34,
	key_5           = 0x35,
	key_6           = 0x36,
	key_7           = 0x37,
	key_8           = 0x38,
	key_9           = 0x39,

	key_A           = 0x41,
	key_Z           = 0x5a,
	key_win_l       = 0x5b,
	key_win_r       = 0x5c,

	key_sleep       = 0x5f,

	key_num0        = 0x60,
	key_num1        = 0x61,
	key_num2        = 0x62,
	key_num3        = 0x63,
	key_num4        = 0x64,
	key_num5        = 0x65,
	key_num6        = 0x66,
	key_num7        = 0x67,
	key_num8        = 0x68,
	key_num9        = 0x69,

	key_multiply    = 0x6a,
	key_add         = 0x6b,
	key_separator   = 0x6c,
	key_subtract    = 0x6d,
	key_decimal     = 0x6e,
	key_divide      = 0x6f,

	key_f1          = 0x70,
	key_f2          = 0x71,
	key_f3          = 0x72,
	key_f4          = 0x73,
	key_f5          = 0x74,
	key_f6          = 0x75,
	key_f7          = 0x76,
	key_f8          = 0x77,
	key_f9          = 0x78,
	key_f10         = 0x79,
	key_f11         = 0x7a,
	key_f12         = 0x7b,

	key_numlock     = 0x90,
	key_scrolllock  = 0x91,

	key_shift_l     = 0xa0,
	key_shift_r     = 0xa1,
	key_control_l   = 0xa2,
	key_control_r   = 0xa3,
	key_menu_l      = 0xa4,
	key_menu_r      = 0xa5,

	key_semicolon   = 0xba,
	key_plus        = 0xbb,
	key_comma       = 0xbc,
	key_minus       = 0xbd,
	key_period      = 0xbe,
	key_slash       = 0xbf,
	key_tilde       = 0xc0,
	key_lbrace      = 0xdb,
	key_backslash   = 0xdc,
	key_rbrace      = 0xdd,
	key_quote       = 0xde,

	key_ime_process = 0xe5,
}key_code_e;

typedef enum key_msg_e {
	key_msg_down    = 1,
	key_msg_up      = 2,
	key_msg_char    = 4,
}key_msg_e;
typedef enum key_flag_e {
	key_flag_shift  = 0x100,
	key_flag_ctrl   = 0x200,
}key_flag_e;

typedef enum mouse_msg_e {
	mouse_msg_down      = 0x10,
	mouse_msg_up        = 0x20,
	mouse_msg_move      = 0x40,
	mouse_msg_wheel     = 0x80,
}mouse_msg_e;
typedef enum mouse_flag_e {
	mouse_flag_left     = 1,
	mouse_flag_right    = 2,
	mouse_flag_mid      = 4,
	mouse_flag_shift    = 0x100,
	mouse_flag_ctrl     = 0x200,
}mouse_flag_e;

typedef enum pattern_type_e {
	pattern_none            = 0,
	pattern_lineargradient  = 1,
	pattern_pathgradient    = 2,
	pattern_texture         = 3,
}pattern_type_e;

typedef DWORD color_t;

struct viewporttype {
	int left;
	int top;
	int right;
	int bottom;
	int clipflag;
};

struct textsettingstype {
	int font;
	int direction;
	int charsize;
	int horiz;
	int vert;
};

struct linestyletype {
	int linestyle;
	unsigned short upattern;
	int thickness;
};

typedef struct key_msg {
	int             key;
	key_msg_e       msg;
	unsigned int    flags;
}key_msg;

typedef struct mouse_msg {
	int             x;
	int             y;
	mouse_msg_e     msg;
	unsigned int    flags;
	int             wheel;
	bool is_left() { return (flags & mouse_flag_left) != 0; }
	bool is_right() { return (flags & mouse_flag_right) != 0; }
	bool is_mid() { return (flags & mouse_flag_mid) != 0; }
	bool is_down() { return msg == mouse_msg_down; }
	bool is_up() { return msg == mouse_msg_up; }
	bool is_move() { return msg == mouse_msg_move; }
	bool is_wheel() { return msg == mouse_msg_wheel; }
}mouse_msg;

typedef struct ege_point {
	float x;
	float y;
}ege_point;

typedef struct ege_rect {
	float x;
	float y;
	float w;
	float h;
}ege_rect;

typedef struct ege_colpoint {
	float   x;
	float   y;
	color_t color;
}ege_colpoint;

// Ϣ
struct MOUSEMSG {
	UINT uMsg;              // ǰϢ
	bool mkCtrl;            // Ctrl Ƿ
	bool mkShift;           // Shift Ƿ
	bool mkLButton;         // Ƿ
	bool mkMButton;         // мǷ
	bool mkRButton;         // ҼǷ
	short x;                // ǰ x 
	short y;                // ǰ y 
	short wheel;            // ֵֹ(120Ϊ)
};

struct msg_createwindow {
	HANDLE hEvent;
	HWND hwnd;
	LPCWSTR classname;
	DWORD style;
	DWORD exstyle;
	size_t id;
	LPVOID param;
};


//
#define MUSIC_ERROR  0xFFFFFFFF


typedef void (CALLBACK_PROC)();
typedef int (__stdcall MSG_KEY_PROC  )(void*, unsigned, int);
typedef int (__stdcall MSG_MOUSE_PROC)(void*, unsigned, int, int, int);
typedef CALLBACK_PROC       * LPCALLBACK_PROC;
typedef MSG_KEY_PROC        * LPMSG_KEY_PROC;
typedef MSG_MOUSE_PROC      * LPMSG_MOUSE_PROC;

/*
ע⣺ºעͺ'###'ĺʾδʵ
*/

struct VECTOR3D;

// 3d 㸨
void EGEAPI rotate_point3d_x(VECTOR3D  * pt, float r); //ȣֶ
void EGEAPI rotate_point3d_y(VECTOR3D  * pt, float r);
void EGEAPI rotate_point3d_z(VECTOR3D  * pt, float r);

struct VECTOR3D {
	float x, y, z;
	VECTOR3D() {
		x = 0; y = 0; z = 0;
	}
	VECTOR3D(float _x, float _y) {
		x = _x; y = _y; z = 0;
	}
	VECTOR3D(float _x, float _y, float _z) {
		x = _x; y = _y; z = _z;
	}
	VECTOR3D& operator = (const VECTOR3D& _fp)  {
		x = _fp.x; y = _fp.y; z = _fp.z;
		return *this;
	}
	VECTOR3D& operator += (const VECTOR3D& _fp);
	VECTOR3D& operator -= (const VECTOR3D& _fp);
	VECTOR3D operator + (const VECTOR3D& _fp) const;
	VECTOR3D operator - (const VECTOR3D& _fp) const;
	VECTOR3D& operator *= (float f); //
	VECTOR3D operator * (float f) const; //
	float operator * (const VECTOR3D& _fp) const; //
	VECTOR3D operator & (const VECTOR3D& _fp) const; //
	VECTOR3D& operator &= (const VECTOR3D& _fp); //
	float GetModule() const;
	float GetSqrModule() const {
		return float(x*x + y*y + z*z);
	}
	VECTOR3D& SetModule(float m) {
		float t = m / GetModule();
		*this *= t;
		return *this;
	}
	VECTOR3D& Rotate(float rad, const VECTOR3D& v); //תֶradΪ
	VECTOR3D& Rotate(float rad, float x, float y, float z) {
		VECTOR3D v(x, y, z);
		return Rotate(rad, v);
	}
	VECTOR3D& Rotate(const VECTOR3D& e, const VECTOR3D& s = VECTOR3D(0.0f, 0.0f, 1.0f)); //se֮ļнȷת
	static float GetAngel(const VECTOR3D& e, const VECTOR3D& s = VECTOR3D(0.0f, 0.0f, 1.0f));
};


class IMAGE;
typedef IMAGE *PIMAGE;
typedef const IMAGE *PCIMAGE;

// ͼغ
void EGEAPI setinitmode(int mode, int x = CW_USEDEFAULT, int y = CW_USEDEFAULT); //óʼģʽmode=0Ϊͨ1Ϊޱ߿򴰿ڣxyǳʼ
int  EGEAPI getinitmode();
void EGEAPI initgraph(int Width, int Height, int Flag);        // ʼͼλ
// Debug Ĭϲʾ LOGORelease ģʽĬʾ
#if !defined(NDEBUG) || defined(DEBUG) || defined(_DEBUG)
inline void EGEAPI initgraph(int Width, int Height) {
	initgraph(Width, Height, getinitmode());
}
#else
inline void EGEAPI initgraph(int Width, int Height) {
	initgraph(Width, Height, getinitmode()|INIT_WITHLOGO);
}
#endif
void EGEAPI initgraph(int* gdriver, int* gmode, const char* path);  //  Borland C++ 3.1 أֻʹ 640x480x24bit
void EGEAPI closegraph();                                           // رͼλ
bool EGEAPI is_run();                                               // жUIǷ˳
void EGEAPI setcaption(LPCSTR  caption);
void EGEAPI setcaption(LPCWSTR caption);
void EGEAPI seticon(int icon_id);
int  EGEAPI attachHWND(HWND hWnd);

void EGEAPI movewindow(int x, int y, bool redraw = true);	//ƶ
void EGEAPI resizewindow(int width, int height);			//贰ڳߴ

void EGEAPI setrendermode(rendermode_e mode);

// ͼ
PIMAGE  gettarget();
int     settarget(PIMAGE pbuf); //  NULL ôΪͼĿ

void EGEAPI cleardevice(PIMAGE pimg = NULL);                   // 

void EGEAPI getviewport(int *pleft, int *ptop, int *pright, int *pbottom, int *pclip = 0, PCIMAGE pimg = NULL); // ȡͼϢ
void EGEAPI setviewport(int left, int top, int right, int bottom, int clip = 1, PIMAGE pimg = NULL);           // ͼ
void EGEAPI clearviewport(PIMAGE pimg = NULL);                                                                 // ͼ

EGE_DEPRECATE(setactivepage)
void EGEAPI setactivepage(int page); // õǰͼҳͼĬϵ壬Χ0-1ĬΪ0
EGE_DEPRECATE(setvisualpage)
void EGEAPI setvisualpage(int page); // õǰʾҳʾϵҳΧ0-1ĬΪ0
EGE_DEPRECATE(swappage)
void EGEAPI swappage();
void EGEAPI window_getviewport(struct viewporttype * viewport);
void EGEAPI window_getviewport(int* left, int* top, int* right, int* bottom);
void EGEAPI window_setviewport(int  left, int  top, int  right, int  bottom);

// ͼ
EGE_DEPRECATE(getlinestyle)
void EGEAPI getlinestyle(int *plinestyle, unsigned short *pupattern = NULL, int *pthickness = NULL, PCIMAGE pimg = NULL); // ȡǰ
void EGEAPI setlinestyle(int linestyle, unsigned short upattern = 0, int thickness = 1, PIMAGE pimg = NULL);          // õǰ
void EGEAPI setlinewidth(float width, PIMAGE pimg = NULL);          // õǰ߿
//EGE_DEPRECATE(getfillstyle)
//void getfillstyle(color_t *pcolor, int *ppattern = NULL, PIMAGE pimg = NULL);           // ȡ ###
EGE_DEPRECATE(setfillstyle)
void EGEAPI setfillstyle(int pattern, color_t color, PIMAGE pimg = NULL);  // 

void EGEAPI setwritemode(int mode, PIMAGE pimg = NULL);         // ûͼλģʽ

//void EGEAPI graphdefaults(PIMAGE pimg = NULL);                  // лͼΪĬֵ ###

// ɫʺ
color_t EGEAPI getcolor(PCIMAGE pimg = NULL);                   // ȡǰͼǰɫ
color_t EGEAPI getfillcolor(PCIMAGE pimg = NULL);               // ȡǰͼɫ
color_t EGEAPI getbkcolor(PCIMAGE pimg = NULL);                 // ȡǰͼɫ
void EGEAPI setcolor(color_t color, PIMAGE pimg = NULL);        // õǰͼǰɫ
void EGEAPI setfillcolor(color_t color, PIMAGE pimg = NULL);    // õǰͼɫ
void EGEAPI setbkcolor(color_t color, PIMAGE pimg = NULL);      // õǰͼɫòɫ滻
void EGEAPI setbkcolor_f(color_t color, PIMAGE pimg = NULL);    // õǰͼɫֻò滭
void EGEAPI setfontbkcolor(color_t color, PIMAGE pimg = NULL);  // õǰֱɫ
void EGEAPI setbkmode(int iBkMode, PIMAGE pimg = NULL);         // ñģʽ(0=OPAQUE, 1=TRANSPARENT)

// ݺ
#define RGBtoGRAY   rgb2gray
#define RGBtoHSL    rgb2hsl
#define RGBtoHSV    rgb2hsv
#define HSLtoRGB    hsl2rgb
#define HSVtoRGB    hsv2rgb

// ɫģת
color_t     EGEAPI rgb2gray(color_t rgb);
void        EGEAPI rgb2hsl(color_t rgb, float *H, float *S, float *L);
void        EGEAPI rgb2hsv(color_t rgb, float *H, float *S, float *V);
color_t     EGEAPI hsl2rgb(float H, float S, float L);
color_t     EGEAPI hsv2rgb(float H, float S, float V);

//  Alpha ͨɫ src Ϊɫdst Ϊǰɫл
color_t     EGEAPI alphablend(color_t dst, color_t src); // ʹ EGEGET_A(src) Ϊ Alpha ֵ
color_t     EGEAPI alphablend(color_t dst, color_t src, unsigned char alpha);


// ͼ

color_t     EGEAPI getpixel  (int x, int y, PCIMAGE pimg = NULL);               // ȡɫ
void        EGEAPI putpixel  (int x, int y, color_t color, PIMAGE pimg = NULL); // 
color_t     EGEAPI getpixel_f(int x, int y, PCIMAGE pimg = NULL);               // ȡɫ
void        EGEAPI putpixel_f(int x, int y, color_t color, PIMAGE pimg = NULL); // 껭
void        EGEAPI putpixels  (int nPoint, int* pPoints, PIMAGE pimg = NULL);   // 
void        EGEAPI putpixels_f(int nPoint, int* pPoints, PIMAGE pimg = NULL);   // 

void        EGEAPI putpixel_withalpha  (int x, int y, color_t color, PIMAGE pimg = NULL); // ͸Ȼ
void        EGEAPI putpixel_withalpha_f(int x, int y, color_t color, PIMAGE pimg = NULL); // ͸Ⱦ껭

void EGEAPI moveto(int x, int y, PIMAGE pimg = NULL);                      // ƶǰ()
void EGEAPI moverel(int dx, int dy, PIMAGE pimg = NULL);                   // ƶǰ()

void EGEAPI line(int x1, int y1, int x2, int y2, PIMAGE pimg = NULL);      // 
void EGEAPI linerel(int dx, int dy, PIMAGE pimg = NULL);                   // ()
void EGEAPI lineto(int x, int y, PIMAGE pimg = NULL);                      // ()
void EGEAPI line_f(float x1, float y1, float x2, float y2, PIMAGE pimg = NULL);  // 
void EGEAPI linerel_f(float dx, float dy, PIMAGE pimg = NULL);                   // ()
void EGEAPI lineto_f(float x, float y, PIMAGE pimg = NULL);                      // ()


void EGEAPI rectangle(int left, int top, int right, int bottom, PIMAGE pimg = NULL);   // 

//void EGEAPI getarccoords(int *px, int *py, int *pxstart, int *pystart, int *pxend, int *pyend, PIMAGE pimg = NULL);    // ȡԲϢ ###
void EGEAPI arc(int x, int y, int stangle, int endangle, int radius, PIMAGE pimg = NULL);                  // Բ
void EGEAPI circle(int x, int y, int radius, PIMAGE pimg = NULL);                                          // Բ
void EGEAPI pieslice(int x, int y, int stangle, int endangle, int radius, PIMAGE pimg = NULL);             // Բ
void EGEAPI ellipse(int x, int y, int stangle, int endangle, int xradius, int yradius, PIMAGE pimg = NULL);// Բ
void EGEAPI fillellipse(int x, int y, int xradius, int yradius, PIMAGE pimg = NULL);                       // Բ
void EGEAPI sector(int x, int y, int stangle, int endangle, int xradius, int yradius, PIMAGE pimg = NULL); // Բ

void EGEAPI arcf(float x, float y, float stangle, float endangle, float radius, PIMAGE pimg = NULL);                    // Բ
void EGEAPI circlef(float x, float y, float radius, PIMAGE pimg = NULL);                                                // Բ
void EGEAPI pieslicef(float x, float y, float stangle, float endangle, float radius, PIMAGE pimg = NULL);               // Բ
void EGEAPI ellipsef(float x, float y, float stangle, float endangle, float xradius, float yradius, PIMAGE pimg = NULL);// Բ
void EGEAPI fillellipsef(float x, float y, float xradius, float yradius, PIMAGE pimg = NULL);                           // Բ
void EGEAPI sectorf(float x, float y, float stangle, float endangle, float xradius, float yradius, PIMAGE pimg = NULL); // Բ

void EGEAPI bar(int left, int top, int right, int bottom, PIMAGE pimg = NULL);                             // ޱ߿
void EGEAPI bar3d(int left, int top, int right, int bottom, int depth, int topflag, PIMAGE pimg = NULL);   // б߿ά

void EGEAPI drawpoly(int numpoints, const int *polypoints, PIMAGE pimg = NULL);     // 
void EGEAPI drawlines(int numlines, const int *polypoints, PIMAGE pimg = NULL);     // ߣչ
void EGEAPI drawbezier(int numpoints, const int *polypoints, PIMAGE pimg = NULL);   // bezierߣչ
void EGEAPI fillpoly(int numpoints, const int *polypoints, PIMAGE pimg = NULL);     // Ķ
void EGEAPI fillpoly_gradient(int numpoints, const ege_colpoint* polypoints, PIMAGE pimg = NULL); // Ķ
void EGEAPI floodfill(int x, int y, int border, PIMAGE pimg = NULL);                // ߽ɫ
void EGEAPI floodfillsurface(int x, int y, color_t areacolor, PIMAGE pimg = NULL);  // ʼɫ

// ߼ͼAA
// ege new_api
void EGEAPI ege_enable_aa(bool enable, PIMAGE pimg = NULL);

void EGEAPI ege_line(float x1, float y1, float x2, float y2, PIMAGE pimg = NULL);
void EGEAPI ege_drawpoly(int numpoints, ege_point* polypoints, PIMAGE pimg = NULL);
void EGEAPI ege_drawcurve(int numpoints, ege_point* polypoints, PIMAGE pimg = NULL);
void EGEAPI ege_rectangle(float x, float y, float w, float h, PIMAGE pimg = NULL);
void EGEAPI ege_ellipse(float x, float y, float w, float h, PIMAGE pimg = NULL);
void EGEAPI ege_pie(float x, float y, float w, float h, float stangle, float sweepAngle, PIMAGE pimg = NULL);

void EGEAPI ege_arc(float x, float y, float w, float h, float stangle, float sweepAngle, PIMAGE pimg = NULL);
void EGEAPI ege_bezier(int numpoints, ege_point* polypoints, PIMAGE pimg = NULL);

void EGEAPI ege_fillpoly(int numpoints, ege_point* polypoints, PIMAGE pimg = NULL);
void EGEAPI ege_fillrect(float x, float y, float w, float h, PIMAGE pimg = NULL);
void EGEAPI ege_fillellipse(float x, float y, float w, float h, PIMAGE pimg = NULL);
void EGEAPI ege_fillpie(float x, float y, float w, float h, float stangle, float sweepAngle, PIMAGE pimg = NULL);

void EGEAPI ege_setpattern_none(PIMAGE pimg = NULL);
void EGEAPI ege_setpattern_lineargradient(float x1, float y1, color_t c1, float x2, float y2, color_t c2, PIMAGE pimg = NULL);
void EGEAPI ege_setpattern_pathgradient(ege_point center, color_t centercolor,
	int count, ege_point* points, int colcount, color_t* pointscolor, PIMAGE pimg = NULL);
void EGEAPI ege_setpattern_ellipsegradient(ege_point center, color_t centercolor,
	float x, float y, float w, float h, color_t color, PIMAGE pimg = NULL);
void EGEAPI ege_setpattern_texture(PIMAGE srcimg, float x, float y, float w, float h, PIMAGE pimg = NULL);

void EGEAPI ege_drawtext(LPCSTR  textstring, float x, float y, PIMAGE pimg = NULL);
void EGEAPI ege_drawtext(LPCWSTR textstring, float x, float y, PIMAGE pimg = NULL);

void EGEAPI ege_setalpha(int alpha, PIMAGE pimg = NULL);
void EGEAPI ege_gentexture(bool gen, PIMAGE pimg = NULL);
void EGEAPI ege_puttexture(PCIMAGE srcimg, float x, float y, float w, float h, PIMAGE pimg = NULL);
void EGEAPI ege_puttexture(PCIMAGE srcimg, ege_rect dest, PIMAGE pimg = NULL);
void EGEAPI ege_puttexture(PCIMAGE srcimg, ege_rect dest, ege_rect src, PIMAGE pimg = NULL);
//

//int  EGEAPI Begin2d();
//void EGEAPI EndRender();

//ʱ亯ºڶ߳ʹãֻܸͼ̵߳ã
void EGEAPI ege_sleep(long ms);     // ӳms
void EGEAPI delay(long ms);         // ӳms
void EGEAPI delay_ms(long ms);      // ƽӳms
void EGEAPI delay_fps(int fps);    // ƽӳ1000/fps룬ȶ֡ʿ
void EGEAPI delay_fps(long fps);    // ƽӳ1000/fps룬ȶ֡ʿ
void EGEAPI delay_fps(double fps);  // ƽӳ1000/fps룬ȶ֡ʿ
void EGEAPI delay_jfps(int fps);   // ƽӳ1000/fps룬ȶ߼֡ʿƣͼ֡
void EGEAPI delay_jfps(long fps);   // ƽӳ1000/fps룬ȶ߼֡ʿƣͼ֡
void EGEAPI delay_jfps(double fps); // ƽӳ1000/fps룬ȶ߼֡ʿƣͼ֡
// ºԶ߳ʹãͼ(worker)̵߳sleepʹ
void EGEAPI api_sleep(long dwMilliseconds);
double EGEAPI fclock(); // ȡΪλĸʱ䣬ֻڼʱã0.01룬

// غ
void EGEAPI outtext(LPCSTR  textstring, PIMAGE pimg = NULL);                   // ڵǰλ
void EGEAPI outtext(LPCWSTR textstring, PIMAGE pimg = NULL);                   // ڵǰλ
void EGEAPI outtext(CHAR  c, PIMAGE pimg = NULL);                              // ڵǰλַ
void EGEAPI outtext(WCHAR c, PIMAGE pimg = NULL);                              // ڵǰλַ
void EGEAPI outtextxy(int x, int y, LPCSTR  textstring, PIMAGE pimg = NULL);   // ָλ
void EGEAPI outtextxy(int x, int y, LPCWSTR textstring, PIMAGE pimg = NULL);   // ָλ
void EGEAPI outtextxy(int x, int y, CHAR c, PIMAGE pimg = NULL);               // ָλַ
void EGEAPI outtextxy(int x, int y, WCHAR c, PIMAGE pimg = NULL);              // ָλַ
void EGEAPI outtextrect(int x, int y, int w, int h, LPCSTR  textstring, PIMAGE pimg = NULL); // ָηΧ
void EGEAPI outtextrect(int x, int y, int w, int h, LPCWSTR textstring, PIMAGE pimg = NULL); // ָηΧ
void EGEAPI xyprintf(int x, int y, LPCSTR  fmt, ...); // ָλʽַָͼĿsettarget
void EGEAPI xyprintf(int x, int y, LPCWSTR fmt, ...); // ָλʽַָͼĿsettarget
void EGEAPI rectprintf(int x, int y, int w, int h, LPCSTR  fmt, ...); // ָʽַָͼĿsettarget
void EGEAPI rectprintf(int x, int y, int w, int h, LPCWSTR fmt, ...); // ָʽַָͼĿsettarget
int  EGEAPI textwidth(LPCSTR  textstring, PIMAGE pimg = NULL);                 // ȡַռõؿ
int  EGEAPI textwidth(LPCWSTR textstring, PIMAGE pimg = NULL);                 // ȡַռõؿ
int  EGEAPI textwidth(CHAR  c, PIMAGE pimg = NULL);
int  EGEAPI textwidth(WCHAR c, PIMAGE pimg = NULL);
int  EGEAPI textheight(LPCSTR  textstring, PIMAGE pimg = NULL);                // ȡַռõظ
int  EGEAPI textheight(LPCWSTR textstring, PIMAGE pimg = NULL);                // ȡַռõظ
int  EGEAPI textheight(CHAR  c, PIMAGE pimg = NULL);
int  EGEAPI textheight(WCHAR c, PIMAGE pimg = NULL);
void EGEAPI settextjustify(int horiz, int vert, PIMAGE pimg = NULL);

// õǰʽ()
//      nHeight: ַƽ߶ȣ
//      nWidth: ַƽ(0 ʾӦ)
//      lpszFace: ƣ
//      nEscapement: ַдǶ(λ 0.1 )
//      nOrientation: ÿַдǶ(λ 0.1 )
//      nWeight: ַıʻϸ(0 ʾĬϴϸ)
//      bItalic: Ƿб壻
//      bUnderline: Ƿ»ߣ
//      bStrikeOut: Ƿɾߣ
//      fbCharSet: ַָ
//      fbOutPrecision: ֵָȣ
//      fbClipPrecision: ֵָļȣ
//      fbQuality: ֵָ
//      fbPitchAndFamily: ָԳ淽ʽϵС
void EGEAPI setfont(int nHeight, int nWidth, LPCSTR lpszFace,  PIMAGE pimg = NULL);
void EGEAPI setfont(int nHeight, int nWidth, LPCWSTR lpszFace, PIMAGE pimg = NULL);
void EGEAPI setfont(int nHeight, int nWidth, LPCSTR lpszFace,  int nEscapement, int nOrientation,
					int nWeight, int bItalic, int bUnderline, int bStrikeOut, PIMAGE pimg = NULL);
void EGEAPI setfont(int nHeight, int nWidth, LPCWSTR lpszFace, int nEscapement, int nOrientation,
					int nWeight, int bItalic, int bUnderline, int bStrikeOut, PIMAGE pimg = NULL);
void EGEAPI setfont(int nHeight, int nWidth, LPCSTR lpszFace,  int nEscapement, int nOrientation,
					int nWeight, int bItalic, int bUnderline, int bStrikeOut, BYTE fbCharSet,
					BYTE fbOutPrecision, BYTE fbClipPrecision, BYTE fbQuality, BYTE fbPitchAndFamily, PIMAGE pimg = NULL);
void EGEAPI setfont(int nHeight, int nWidth, LPCWSTR lpszFace, int nEscapement, int nOrientation,
					int nWeight, int bItalic, int bUnderline, int bStrikeOut, BYTE fbCharSet,
					BYTE fbOutPrecision, BYTE fbClipPrecision, BYTE fbQuality, BYTE fbPitchAndFamily, PIMAGE pimg = NULL);
void EGEAPI setfont(const LOGFONTA *font, PIMAGE pimg = NULL); // õǰʽ
void EGEAPI setfont(const LOGFONTW *font, PIMAGE pimg = NULL); // õǰʽ
void EGEAPI getfont(LOGFONTA *font, PCIMAGE pimg = NULL);      // ȡǰʽ
void EGEAPI getfont(LOGFONTW *font, PCIMAGE pimg = NULL);      // ȡǰʽ


//ͼƬ
#define getmaxx getwidth
#define getmaxy getheight

int EGEAPI getwidth(PCIMAGE pimg = NULL);          // ȡͼƬ
int EGEAPI getheight(PCIMAGE pimg = NULL);         // ȡͼƬ߶
int EGEAPI getx(PCIMAGE pimg = NULL);              // ȡǰ x 
int EGEAPI gety(PCIMAGE pimg = NULL);              // ȡǰ y 

PIMAGE         EGEAPI newimage();                      //  PIMAGE
PIMAGE         EGEAPI newimage(int width, int height); //  PIMAGE
void           EGEAPI delimage(PCIMAGE pImg);          // ɾ PIMAGE
color_t*       EGEAPI getbuffer(PIMAGE pImg);
const color_t* EGEAPI getbuffer(PCIMAGE pImg);

int  EGEAPI resize(PIMAGE pDstImg, int width, int height); //ߴ
void EGEAPI getimage(PIMAGE pDstImg, int srcX, int srcY, int srcWidth, int srcHeight);                             // Ļȡͼ
void EGEAPI getimage(PIMAGE pDstImg, PCIMAGE pSrcImg, int srcX, int srcY, int srcWidth, int srcHeight);            // һ PIMAGE лȡͼ
int  EGEAPI getimage(PIMAGE pDstImg, LPCSTR  pImgFile, int zoomWidth = 0, int zoomHeight = 0);                     // ͼƬļȡͼ(bmp/jpg/gif/emf/wmf)
int  EGEAPI getimage(PIMAGE pDstImg, LPCWSTR pImgFile, int zoomWidth = 0, int zoomHeight = 0);                     // ͼƬļȡͼ(bmp/jpg/gif/emf/wmf)
int  EGEAPI getimage(PIMAGE pDstImg, LPCSTR  pResType, LPCSTR  pResName, int zoomWidth = 0, int zoomHeight = 0);   // Դļȡͼ(bmp/jpg/gif/emf/wmf)
int  EGEAPI getimage(PIMAGE pDstImg, LPCWSTR pResType, LPCWSTR pResName, int zoomWidth = 0, int zoomHeight = 0);   // Դļȡͼ(bmp/jpg/gif/emf/wmf)
void EGEAPI putimage(int dstX, int dstY, PCIMAGE pSrcImg, DWORD dwRop = SRCCOPY);                                  // ͼĻ
void EGEAPI putimage(int dstX, int dstY, int dstWidth, int dstHeight, PCIMAGE pSrcImg, int srcX, int srcY, DWORD dwRop = SRCCOPY);                                // ͼĻ(ָ)
void EGEAPI putimage(int dstX, int dstY, int dstWidth, int dstHeight, PCIMAGE pSrcImg, int srcX, int srcY, int srcWidth, int srcHeight, DWORD dwRop = SRCCOPY);   // ͼĻ(ָԴߺĿ߽)
void EGEAPI putimage(PIMAGE pDstImg, int dstX, int dstY, PCIMAGE pSrcImg, DWORD dwRop = SRCCOPY);                                                                 // ͼһͼ
void EGEAPI putimage(PIMAGE pDstImg, int dstX, int dstY, int dstWidth, int dstHeight, PCIMAGE pSrcImg, int srcX, int srcY, DWORD dwRop = SRCCOPY);                // ͼһͼ(ָ)
void EGEAPI putimage(PIMAGE pDstImg, int dstX, int dstY, int dstWidth, int dstHeight, PCIMAGE pSrcImg, int srcX, int srcY, int srcWidth, int srcHeight, DWORD dwRop = SRCCOPY);   // ͼһͼ(ָԴߺĿ߽)
int  EGEAPI saveimage(PCIMAGE pimg, LPCSTR  filename);
int  EGEAPI saveimage(PCIMAGE pimg, LPCWSTR filename);
int  EGEAPI savepng(PCIMAGE pimg, LPCSTR  filename, int bAlpha = 0);
int  EGEAPI savepng(PCIMAGE pimg, LPCWSTR filename, int bAlpha = 0);
int  EGEAPI getimage_pngfile(PIMAGE pimg, LPCSTR  filename);
int  EGEAPI getimage_pngfile(PIMAGE pimg, LPCWSTR filename);

int EGEAPI putimage_transparent(
	PIMAGE imgdest,         // handle to dest
	PCIMAGE imgsrc,         // handle to source
	int nXOriginDest,       // x-coord of destination upper-left corner
	int nYOriginDest,       // y-coord of destination upper-left corner
	color_t crTransparent,  // color to make transparent
	int nXOriginSrc = 0,    // x-coord of source upper-left corner
	int nYOriginSrc = 0,    // y-coord of source upper-left corner
	int nWidthSrc = 0,      // width of source rectangle
	int nHeightSrc = 0      // height of source rectangle
);
int EGEAPI putimage_alphablend(
	PIMAGE imgdest,         // handle to dest
	PCIMAGE imgsrc,         // handle to source
	int nXOriginDest,       // x-coord of destination upper-left corner
	int nYOriginDest,       // y-coord of destination upper-left corner
	unsigned char alpha,    // alpha
	int nXOriginSrc = 0,    // x-coord of source upper-left corner
	int nYOriginSrc = 0,    // y-coord of source upper-left corner
	int nWidthSrc = 0,      // width of source rectangle
	int nHeightSrc = 0      // height of source rectangle
);
int EGEAPI putimage_alphatransparent(
	PIMAGE imgdest,         // handle to dest
	PCIMAGE imgsrc,         // handle to source
	int nXOriginDest,       // x-coord of destination upper-left corner
	int nYOriginDest,       // y-coord of destination upper-left corner
	color_t crTransparent,  // color to make transparent
	unsigned char alpha,    // alpha
	int nXOriginSrc = 0,    // x-coord of source upper-left corner
	int nYOriginSrc = 0,    // y-coord of source upper-left corner
	int nWidthSrc = 0,      // width of source rectangle
	int nHeightSrc = 0      // height of source rectangle
);
int EGEAPI putimage_withalpha(
	PIMAGE imgdest,         // handle to dest
	PCIMAGE imgsrc,         // handle to source
	int nXOriginDest,       // x-coord of destination upper-left corner
	int nYOriginDest,       // y-coord of destination upper-left corner
	int nXOriginSrc = 0,    // x-coord of source upper-left corner
	int nYOriginSrc = 0,    // y-coord of source upper-left corner
	int nWidthSrc = 0,      // width of source rectangle
	int nHeightSrc = 0      // height of source rectangle
);
int EGEAPI putimage_alphafilter(
	PIMAGE imgdest,         // handle to dest
	PCIMAGE imgsrc,         // handle to source
	int nXOriginDest,       // x-coord of destination upper-left corner
	int nYOriginDest,       // y-coord of destination upper-left corner
	PCIMAGE imgalpha,       // alpha
	int nXOriginSrc,        // x-coord of source upper-left corner
	int nYOriginSrc,        // y-coord of source upper-left corner
	int nWidthSrc,          // width of source rectangle
	int nHeightSrc          // height of source rectangle
);
int EGEAPI imagefilter_blurring (
	PIMAGE imgdest,         // handle to dest
	int intensity,
	int alpha,
	int nXOriginDest = 0,
	int nYOriginDest = 0,
	int nWidthDest = 0,
	int nHeightDest = 0
);
int EGEAPI putimage_rotate(
	PIMAGE imgdest,
	PCIMAGE imgtexture,
	int nXOriginDest,
	int nYOriginDest,
	float centerx,
	float centery,
	float radian,
	int btransparent = 0,            // transparent (1) or not (0)
	int alpha = -1,                  // in range[0, 256], alpha== -1 means no alpha
	int smooth = 0
);

int EGEAPI putimage_rotatezoom(
	PIMAGE imgdest,
	PCIMAGE imgtexture,
	int nXOriginDest,
	int nYOriginDest,
	float centerx,
	float centery,
	float radian,
	float zoom,
	int btransparent = 0,            // transparent (1) or not (0)
	int alpha = -1,                  // in range[0, 256], alpha== -1 means no alpha
	int smooth = 0
);


// 

HWND        EGEAPI getHWnd();         // ȡͼھ
HINSTANCE   EGEAPI getHInstance();
HDC         EGEAPI getHDC(PCIMAGE pImg = NULL);

PVOID       EGEAPI getProcfunc();
int         EGEAPI getGraphicsVer();   // ȡǰ汾
float       EGEAPI getfps();           // ȡǰ֡

//
void            EGEAPI randomize();
unsigned int    EGEAPI random(unsigned int n);
double          EGEAPI randomf();

//߼뺯
// title Ի⣬ text Իʾ֣ bufݵַָ룬 lenָbuf󳤶ȣҲͬʱݳ
int EGEAPI inputbox_getline(LPCSTR  title, LPCSTR  text, LPSTR  buf, int len);  //Իû룬ǰͣط0ʾЧ0ΪЧ
int EGEAPI inputbox_getline(LPCWSTR title, LPCWSTR text, LPWSTR buf, int len);  //Իû룬ǰͣط0ʾЧ0ΪЧ


//̴
int     EGEAPI kbmsg();
key_msg EGEAPI getkey();
EGE_DEPRECATE(getchEx)
int     EGEAPI getchEx(int flag);
EGE_DEPRECATE(kbhitEx)
int     EGEAPI kbhitEx(int flag);
int     EGEAPI keystate(int key);       // üΪkeyļkey_code_eǷ£keyʹ갴ļ룬õ״̬
void    EGEAPI flushkey();              // ռϢ

#if !defined(_INC_CONIO) && !defined(_CONIO_H_)
#define _INC_CONIO
#define _CONIO_H_
int EGEAPI getch();
int EGEAPI kbhit();
#else
#define getch getchEx
#define kbhit kbhitEx
#endif

//괦
int         EGEAPI mousemsg();                  // ǷϢ
mouse_msg   EGEAPI getmouse();                  // ȡһϢûУ͵ȴ
EGE_DEPRECATE(GetMouseMsg)
MOUSEMSG    EGEAPI GetMouseMsg();               // ƼʹõĺȡһϢûУ͵ȴ

void        EGEAPI flushmouse();                // Ϣ
int         EGEAPI showmouse(int bShow);        // Ƿʾ
int         EGEAPI mousepos(int *x, int *y); // ȡǰλ

/*
callback function define as:
int __stdcall on_msg_key(void* param, unsigned msg, int key);
msg: see 'enum message_event'
key: keycode
return zero means process this message, otherwise means pass it and then process with 'getkey' function
*/
//int message_addkeyhandler(void* param, LPMSG_KEY_PROC func);        //ü̻ص
/*
callback function define as:
int __stdcall on_msg_mouse(void* param, unsigned msg, int key, int x, int y);
msg: see 'enum message_event'
key: see 'enum message_mouse', if msg==MSG_EVENT_WHELL, key is a int number that indicates the distance the wheel is rotated, expressed in multiples or divisions of WHEEL_DELTA, which is 120.
x,y: current mouse (x, y)
return zero means process this message, otherwise means pass it and then process with 'GetMouseMsg' function
*/
//int message_addmousehandler(void* param, LPMSG_MOUSE_PROC func);    //ص
int EGEAPI SetCloseHandler(LPCALLBACK_PROC func);


class MUSIC
{
public:
	MUSIC();
	virtual ~MUSIC();
	operator HWND()const{ return (HWND)m_dwCallBack; }
public:
	int   IsOpen() { return (m_DID != MUSIC_ERROR) ? 1 : 0; }
	DWORD OpenFile(LPCSTR  filepath);
	DWORD OpenFile(LPCWSTR filepath);
	DWORD Play(DWORD dwFrom = MUSIC_ERROR, DWORD dwTo = MUSIC_ERROR);
	DWORD Pause();
	DWORD Seek(DWORD dwTo); //λöλλΪms
	DWORD SetVolume(float value);
	DWORD Close();
	DWORD Stop();
	DWORD GetPosition();
	DWORD GetLength();
	// ºGetPlayStatusķֵΪ֮һ忴׺
	// MUSIC_MODE_NOT_OPEN   //ûȷ
	// MUSIC_MODE_NOT_READY  //豸û׼ ʹã
	// MUSIC_MODE_PAUSE  //ͣ
	// MUSIC_MODE_PLAY   //ڲ
	// MUSIC_MODE_STOP   //ɹ򿪺󣬻߲״̬
	// MUSIC_MODE_OPEN   // ʹã
	// MUSIC_MODE_SEEK   //λ ʹã
	DWORD GetPlayStatus();
private:
	DWORD       m_DID;
	PVOID       m_dwCallBack;
};

/* ѹ */
/* ѹʱdestҪ֤ССΪsourceLen * 1.001 + 16 */
/* compress/compress2ǰ*destLenֵʾdestСʱֵʾʵʴС */
/* compress2 level 0-90ѹ9ѹcompressʹĬֵ6 */
int             EGEAPI ege_compress(void *dest, unsigned long *destLen, const void *source, unsigned long sourceLen);
int             EGEAPI ege_compress2(void *dest, unsigned long *destLen, const void *source, unsigned long sourceLen, int level);
int             EGEAPI ege_uncompress(void *dest, unsigned long *destLen, const void *source, unsigned long sourceLen);
unsigned long   EGEAPI ege_uncompress_size(const void *source, unsigned long sourceLen); /* 0ʾʾС */

NAMESPACE_EGE_R

#ifndef _GRAPH_LIB_BUILD_

#if defined(_MSC_VER) && (defined(HIDE_CONSOLE) || !defined(SHOW_CONSOLE))
#pragma comment( linker, "/subsystem:\"windows\" /entry:\"mainCRTStartup\"" )
#endif

#define Sleep(ms) delay_ms(ms)

#endif

#if !defined(_MSC_VER)
#define WinMain(...) WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
#elif defined(_CONSOLE)
#if (_MSC_VER > 1200)
#define WinMain(...) main(int argc, char* argv[])
#else
#define WinMain main
#endif
#endif

#endif
