
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/ear.zip" ),
}
local prefabs = {}

local start_inv = 
{
		"eardress",
		"earpop",
}

local function applyupgrades(inst)

	local max_upgrades = 20
	local upgrades = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil (150 + upgrades * 5)
	inst.components.sanity.max = math.ceil (100 + upgrades * 7.5)
	inst.components.health.maxhealth = math.ceil (100 + upgrades * 7.5)
	inst.components.talker:Say(" - -b  Level Up! : ".. (inst.level))
	
	if inst.level >19 then
		inst.components.talker:Say("OTL Level : Max!")
	end

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
end

local function oneat(inst, food)
	local summonchance1 = 0.05	
	local summonchance2 = 0.02
    if math.random() < summonchance1 and food and food.components.edible.foodtype == "MEAT" then
		inst.level = inst.level + 1
		applyupgrades(inst)	
		inst.components.sanity:DoDelta(inst.components.sanity.max*0.5)
		inst.components.health:DoDelta(inst.components.health.maxhealth*0.5)
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()
		
		inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
	end
	
	if math.random() < summonchance2 and food then
		inst.components.sanity:DoDelta(inst.components.sanity.max)
		inst.components.health:DoDelta(inst.components.health.maxhealth)
		inst.components.talker:Say("WoW Power! I'm so lucky !")
	end
end

local function updatestats(inst)
	if GetClock():IsDay() and not GetWorld():IsCave() then
		inst.components.hunger:DoDelta(-inst.components.hunger.max*0.33)
		inst.components.sanity:DoDelta(-inst.components.sanity.max*0.15)
		inst.components.combat.damagemultiplier = 1
		inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED*0.9
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED*0.9
 	elseif GetClock():IsDusk() and not GetWorld():IsCave() then
		inst.components.combat.damagemultiplier = 1.1
		inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED
	elseif GetClock():IsNight() and not GetWorld():IsCave() then
		inst.components.combat.damagemultiplier = 1.2
		inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED*1.1
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED*1.1
	end
end



local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			--re-set these from the save data, because of load-order clipping issues
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end

end

local function onsave(inst, data)
	data.level = inst.level
	data.charge_time = inst.charge_time
end

local fn = function(inst)
	
	inst.soundsname = "willow"

	inst.MiniMapEntity:SetIcon( "ear.tex" )

	inst.level = 0
	table.insert(inst.components.eater.foodprefs, "MEAT")
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(100)
	inst.components.health:SetMaxHealth(100)
	inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED
	inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED
	inst.components.combat.damagemultiplier = 1.1

	inst.components.sanity.night_drain_mult = 1.2
	inst.components.sanity.neg_aura_mult = 1.2
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)

	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
	
	inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())
	inst:ListenForEvent( "daytime", function() updatestats(inst) end , GetWorld())
	inst:ListenForEvent( "nighttime", function() updatestats(inst) end , GetWorld())
	updatestats(inst)

	local eardress = Recipe("eardress", {Ingredient("feather_robin", 5), Ingredient("feather_robin_winter", 2), Ingredient("feather_crow", 9)}, RECIPETABS.DRESS, {SCIENCE = 0})
	eardress.atlas = "images/inventoryimages/eardress.xml"
	eardress.sortkey = 1
	local earhat = Recipe("earhat", {Ingredient("tentaclespots", 5), Ingredient("livinglog", 2), Ingredient("nightmarefuel", 9)}, RECIPETABS.MAGIC, {MAGIC = 2})
	earhat.atlas = "images/inventoryimages/earhat.xml"
	earhat.sortkey = 1
	local earpop = Recipe("earpop", {Ingredient("butterflywings", 5), Ingredient("twigs", 2), Ingredient("honey", 9)}, RECIPETABS.SURVIVAL, {SCIENCE = 0})
	earpop.atlas = "images/inventoryimages/earpop.xml"
	earpop.sortkey = 1
	
	TheInput:AddKeyUpHandler(KEY_F12, function()
		inst.components.talker:Say(" - -b  Level Up! : ".. (inst.level))
	end)
	
end


return MakePlayerCharacter("ear", prefabs, assets, fn, start_inv)
