/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage;

import java.nio.ByteBuffer;
import java.util.Objects;
import jdk.internal.jimage.BasicImageReader;
import jdk.internal.jimage.ImageStream;
import jdk.internal.jimage.ImageStrings;
import jdk.internal.jimage.ImageStringsReader;

public class ImageLocation {
    public static final int ATTRIBUTE_END = 0;
    public static final int ATTRIBUTE_MODULE = 1;
    public static final int ATTRIBUTE_PARENT = 2;
    public static final int ATTRIBUTE_BASE = 3;
    public static final int ATTRIBUTE_EXTENSION = 4;
    public static final int ATTRIBUTE_OFFSET = 5;
    public static final int ATTRIBUTE_COMPRESSED = 6;
    public static final int ATTRIBUTE_UNCOMPRESSED = 7;
    public static final int ATTRIBUTE_COUNT = 8;
    protected final long[] attributes;
    protected final ImageStrings strings;

    public ImageLocation(long[] attributes, ImageStrings strings) {
        this.attributes = Objects.requireNonNull(attributes);
        this.strings = Objects.requireNonNull(strings);
    }

    ImageStrings getStrings() {
        return this.strings;
    }

    private static int attributeLength(int data) {
        return (data & 7) + 1;
    }

    private static int attributeKind(int data) {
        return data >>> 3;
    }

    static long[] decompress(ByteBuffer bytes) {
        Objects.requireNonNull(bytes);
        long[] attributes = new long[8];
        if (bytes != null) {
            int data;
            int kind;
            while (bytes.hasRemaining() && (kind = ImageLocation.attributeKind(data = bytes.get() & 0xFF)) != 0) {
                if (kind < 0 || 8 <= kind) {
                    throw new InternalError("Invalid jimage attribute kind: " + kind);
                }
                int length = ImageLocation.attributeLength(data);
                long value = 0L;
                for (int j = 0; j < length; ++j) {
                    value <<= 8;
                    if (!bytes.hasRemaining()) {
                        throw new InternalError("Missing jimage attribute data");
                    }
                    value |= (long)(bytes.get() & 0xFF);
                }
                attributes[kind] = value;
            }
        }
        return attributes;
    }

    public static byte[] compress(long[] attributes) {
        Objects.requireNonNull(attributes);
        ImageStream stream = new ImageStream(16);
        for (int kind = 1; kind < 8; ++kind) {
            long value = attributes[kind];
            if (value == 0L) continue;
            int n = 63 - Long.numberOfLeadingZeros(value) >> 3;
            stream.put(kind << 3 | n);
            for (int i = n; i >= 0; --i) {
                stream.put((int)(value >> (i << 3)));
            }
        }
        stream.put(0);
        return stream.toArray();
    }

    public boolean verify(String name) {
        Objects.requireNonNull(name);
        return name.equals(this.getFullName());
    }

    long getAttribute(int kind) {
        if (kind < 0 || 8 <= kind) {
            throw new InternalError("Invalid jimage attribute kind: " + kind);
        }
        return this.attributes[kind];
    }

    String getAttributeString(int kind) {
        if (kind < 0 || 8 <= kind) {
            throw new InternalError("Invalid jimage attribute kind: " + kind);
        }
        return this.getStrings().get((int)this.attributes[kind]);
    }

    public String getModule() {
        return this.getAttributeString(1);
    }

    public int getModuleOffset() {
        return (int)this.getAttribute(1);
    }

    public String getBase() {
        return this.getAttributeString(3);
    }

    public int getBaseOffset() {
        return (int)this.getAttribute(3);
    }

    public String getParent() {
        return this.getAttributeString(2);
    }

    public int getParentOffset() {
        return (int)this.getAttribute(2);
    }

    public String getExtension() {
        return this.getAttributeString(4);
    }

    public int getExtensionOffset() {
        return (int)this.getAttribute(4);
    }

    public String getFullName() {
        return this.getFullName(false);
    }

    public String getFullName(boolean modulesPrefix) {
        StringBuilder builder = new StringBuilder();
        if (this.getModuleOffset() != 0) {
            if (modulesPrefix) {
                builder.append("/modules");
            }
            builder.append('/');
            builder.append(this.getModule());
            builder.append('/');
        }
        if (this.getParentOffset() != 0) {
            builder.append(this.getParent());
            builder.append('/');
        }
        builder.append(this.getBase());
        if (this.getExtensionOffset() != 0) {
            builder.append('.');
            builder.append(this.getExtension());
        }
        return builder.toString();
    }

    String buildName(boolean includeModule, boolean includeParent, boolean includeName) {
        StringBuilder builder = new StringBuilder();
        if (includeModule && this.getModuleOffset() != 0) {
            builder.append("/modules/");
            builder.append(this.getModule());
        }
        if (includeParent && this.getParentOffset() != 0) {
            builder.append('/');
            builder.append(this.getParent());
        }
        if (includeName) {
            if (includeModule || includeParent) {
                builder.append('/');
            }
            builder.append(this.getBase());
            if (this.getExtensionOffset() != 0) {
                builder.append('.');
                builder.append(this.getExtension());
            }
        }
        return builder.toString();
    }

    public long getContentOffset() {
        return this.getAttribute(5);
    }

    public long getCompressedSize() {
        return this.getAttribute(6);
    }

    public long getUncompressedSize() {
        return this.getAttribute(7);
    }

    static ImageLocation readFrom(BasicImageReader reader, int offset) {
        Objects.requireNonNull(reader);
        long[] attributes = reader.getAttributes(offset);
        ImageStringsReader strings = reader.getStrings();
        return new ImageLocation(attributes, strings);
    }
}

