/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.jimage.ImageReader;

public class ImageReaderFactory {
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final Path BOOT_MODULES_JIMAGE = Paths.get(JAVA_HOME, "lib", "modules");
    private static final Map<Path, ImageReader> readers = new ConcurrentHashMap<Path, ImageReader>();

    private ImageReaderFactory() {
    }

    public static ImageReader get(Path jimage) throws IOException {
        Objects.requireNonNull(jimage);
        ImageReader reader = readers.get(jimage);
        if (reader != null) {
            return reader;
        }
        reader = ImageReader.open(jimage);
        ImageReader r = readers.putIfAbsent(jimage, reader);
        if (r == null) {
            return reader;
        }
        reader.close();
        return r;
    }

    public static ImageReader getImageReader() {
        try {
            return ImageReaderFactory.get(BOOT_MODULES_JIMAGE);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }
}

