/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage;

import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.util.Objects;
import jdk.internal.jimage.BasicImageReader;
import jdk.internal.jimage.ImageStrings;

public class ImageStringsReader
implements ImageStrings {
    public static final int HASH_MULTIPLIER = 16777619;
    private final BasicImageReader reader;

    ImageStringsReader(BasicImageReader reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    @Override
    public String get(int offset) {
        return this.reader.getString(offset);
    }

    @Override
    public int add(String string) {
        throw new InternalError("Can not add strings at runtime");
    }

    private static int hashCode(byte[] bytes, int offset, int count, int seed) {
        Objects.requireNonNull(bytes);
        if (offset < 0 || count < 0 || offset > bytes.length - count) {
            throw new IndexOutOfBoundsException("offset=" + offset + ", count=" + count);
        }
        int limit = offset + count;
        if (limit < 0 || limit > bytes.length) {
            throw new IndexOutOfBoundsException("limit=" + limit);
        }
        for (int i = offset; i < limit; ++i) {
            seed = seed * 16777619 ^ bytes[i] & 0xFF;
        }
        return seed & Integer.MAX_VALUE;
    }

    public static int hashCode(byte[] bytes, int seed) {
        return ImageStringsReader.hashCode(bytes, 0, bytes.length, seed);
    }

    public static int hashCode(byte[] bytes) {
        return ImageStringsReader.hashCode(bytes, 0, bytes.length, 16777619);
    }

    public static int hashCode(String string, int seed) {
        return ImageStringsReader.hashCode(ImageStringsReader.mutf8FromString(string), seed);
    }

    public static int hashCode(String string) {
        return ImageStringsReader.hashCode(ImageStringsReader.mutf8FromString(string), 16777619);
    }

    static int charsFromMUTF8Length(byte[] bytes, int offset, int count) {
        byte ch;
        int length = 0;
        for (int i = offset; i < offset + count && (ch = bytes[i]) != 0; ++i) {
            if ((ch & 0xC0) == 128) continue;
            ++length;
        }
        return length;
    }

    static void charsFromMUTF8(char[] chars, byte[] bytes, int offset, int count) throws UTFDataFormatException {
        byte ch;
        int j = 0;
        for (int i = offset; i < offset + count && (ch = bytes[i]) != 0; ++i) {
            boolean is_unicode = (ch & 0x80) != 0;
            int uch = ch & 0x7F;
            if (is_unicode) {
                int mask = 64;
                while ((uch & mask) != 0) {
                    if (((ch = bytes[++i]) & 0xC0) != 128) {
                        throw new UTFDataFormatException("bad continuation 0x" + Integer.toHexString(ch));
                    }
                    uch = (uch & ~mask) << 6 | ch & 0x3F;
                    mask <<= 5;
                }
                if ((uch & 0xFFFF) != uch) {
                    throw new UTFDataFormatException("character out of range \\u" + Integer.toHexString(uch));
                }
            }
            chars[j++] = (char)uch;
        }
    }

    public static String stringFromMUTF8(byte[] bytes, int offset, int count) {
        int length = ImageStringsReader.charsFromMUTF8Length(bytes, offset, count);
        char[] chars = new char[length];
        try {
            ImageStringsReader.charsFromMUTF8(chars, bytes, offset, count);
        }
        catch (UTFDataFormatException ex) {
            throw new InternalError("Attempt to convert non modified UTF-8 byte sequence", ex);
        }
        return new String(chars);
    }

    public static String stringFromMUTF8(byte[] bytes) {
        return ImageStringsReader.stringFromMUTF8(bytes, 0, bytes.length);
    }

    static int charsFromByteBufferLength(ByteBuffer buffer) {
        int length = 0;
        while (buffer.hasRemaining()) {
            byte ch = buffer.get();
            if (ch == 0) {
                return length;
            }
            if ((ch & 0xC0) == 128) continue;
            ++length;
        }
        throw new InternalError("No terminating zero byte for modified UTF-8 byte sequence");
    }

    static void charsFromByteBuffer(char[] chars, ByteBuffer buffer) {
        int j = 0;
        while (buffer.hasRemaining()) {
            byte ch = buffer.get();
            if (ch == 0) {
                return;
            }
            boolean is_unicode = (ch & 0x80) != 0;
            int uch = ch & 0x7F;
            if (is_unicode) {
                int mask = 64;
                while ((uch & mask) != 0) {
                    ch = buffer.get();
                    if ((ch & 0xC0) != 128) {
                        throw new InternalError("Bad continuation in modified UTF-8 byte sequence: " + ch);
                    }
                    uch = (uch & ~mask) << 6 | ch & 0x3F;
                    mask <<= 5;
                }
            }
            if ((uch & 0xFFFF) != uch) {
                throw new InternalError("UTF-32 char in modified UTF-8 byte sequence: " + uch);
            }
            chars[j++] = (char)uch;
        }
        throw new InternalError("No terminating zero byte for modified UTF-8 byte sequence");
    }

    public static String stringFromByteBuffer(ByteBuffer buffer) {
        int length = ImageStringsReader.charsFromByteBufferLength(buffer);
        buffer.rewind();
        char[] chars = new char[length];
        ImageStringsReader.charsFromByteBuffer(chars, buffer);
        return new String(chars);
    }

    static int mutf8FromCharsLength(char[] chars) {
        int length = 0;
        for (char ch : chars) {
            int uch = ch & 0xFFFF;
            if ((uch & 0xFFFFFF80) != 0) {
                int mask = -64;
                int n = 0;
                do {
                    ++n;
                } while (((uch >>= 6) & (mask >>= 1)) != 0);
                length += n + 1;
                continue;
            }
            if (uch == 0) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    static void mutf8FromChars(byte[] bytes, int offset, char[] chars) {
        int j = offset;
        byte[] buffer = new byte[8];
        for (char ch : chars) {
            int uch = ch & 0xFFFF;
            if ((uch & 0xFFFFFF80) != 0) {
                int mask = -64;
                int n = 0;
                do {
                    buffer[n++] = (byte)(0x80 | uch & 0x3F);
                } while (((uch >>= 6) & (mask >>= 1)) != 0);
                buffer[n] = (byte)(mask << 1 | uch);
                do {
                    bytes[j++] = buffer[n--];
                } while (0 <= n);
                continue;
            }
            if (uch == 0) {
                bytes[j++] = -64;
                bytes[j++] = -128;
                continue;
            }
            bytes[j++] = (byte)uch;
        }
    }

    public static byte[] mutf8FromString(String string) {
        char[] chars = string.toCharArray();
        int length = ImageStringsReader.mutf8FromCharsLength(chars);
        byte[] bytes = new byte[length];
        ImageStringsReader.mutf8FromChars(bytes, 0, chars);
        return bytes;
    }
}

