/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.security.JarAsBLOBVerifier;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.JarUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class SignedAsBlobJarFile
extends JarFile
implements ResourceObject {
    private final URL resourceURL;
    private final String resourceVersion;
    private final CodeSource codeSource;

    public SignedAsBlobJarFile(File file, JarAsBLOBVerifier jarAsBLOBVerifier) throws IOException {
        super(file);
        this.resourceURL = jarAsBLOBVerifier.getJarLocation();
        this.resourceVersion = jarAsBLOBVerifier.getJarVersion();
        this.codeSource = SignedAsBlobJarFile.getCodeSource(jarAsBLOBVerifier);
        if (Cache.DEBUG) {
            Trace.println("SignedAsBlobJarFile.const");
        }
    }

    private SignedAsBlobJarFile(File file, URL uRL, String string, CodeSource codeSource) throws IOException {
        super(file);
        this.resourceURL = uRL;
        this.resourceVersion = string;
        this.codeSource = codeSource;
    }

    private static CodeSource getCodeSource(JarAsBLOBVerifier jarAsBLOBVerifier) {
        JarVerifier.CodeSourceCache codeSourceCache = jarAsBLOBVerifier.getCodeSourceCache();
        if (codeSourceCache != null && codeSourceCache.getCodeSources().size() == 1) {
            CodeSource codeSource = codeSourceCache.getCodeSources().iterator().next();
            return SignedAsBlobJarFile.cloneCodeSource(codeSource);
        }
        return SignedAsBlobJarFile.getUnverifiedCodeSource(jarAsBLOBVerifier.getJarLocation());
    }

    Enumeration<String> entryNames(CodeSource[] codeSourceArray) {
        for (int i = 0; i < codeSourceArray.length; ++i) {
            if (!this.codeSource.equals(codeSourceArray[i])) continue;
            final Enumeration<JarEntry> enumeration = super.entries();
            return new Enumeration<String>(){
                private JarEntry next;

                @Override
                public boolean hasMoreElements() {
                    if (this.next == null && enumeration.hasMoreElements()) {
                        this.next = (JarEntry)enumeration.nextElement();
                        if (this.next != null) {
                            while (JarUtil.canSkipEntry(this.next) && enumeration.hasMoreElements()) {
                                this.next = (JarEntry)enumeration.nextElement();
                                if (this.next != null) continue;
                            }
                        }
                    }
                    return this.next != null;
                }

                @Override
                public String nextElement() {
                    JarEntry jarEntry = this.next;
                    this.next = null;
                    return jarEntry.getName();
                }
            };
        }
        return Collections.emptyEnumeration();
    }

    private static CodeSource getUnverifiedCodeSource(URL uRL) {
        return new CodeSource(uRL, (Certificate[])null);
    }

    CodeSource[] getCodeSources(URL uRL) {
        return new CodeSource[]{this.codeSource};
    }

    CodeSource getCodeSource(URL uRL, String string) {
        if (!JarUtil.isSigningRelated(string) && !string.endsWith("/")) {
            return this.getCodeSources(uRL)[0];
        }
        return SignedAsBlobJarFile.getUnverifiedCodeSource(uRL);
    }

    @Override
    public ZipEntry getEntry(String string) {
        JarEntry jarEntry = (JarEntry)super.getEntry(string);
        if (jarEntry == null) {
            return null;
        }
        return new BlobJarEntry(jarEntry);
    }

    @Override
    public void doClose() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            return new SignedAsBlobJarFile(new File(this.getName()), this.resourceURL, this.resourceVersion, SignedAsBlobJarFile.cloneCodeSource(this.codeSource));
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            return null;
        }
    }

    @Override
    public URL getResourceURL() {
        return this.resourceURL;
    }

    @Override
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public Enumeration<JarEntry> entries() {
        final Enumeration<JarEntry> enumeration = super.entries();
        return new Enumeration<JarEntry>(){

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            @Override
            public JarEntry nextElement() {
                try {
                    JarEntry jarEntry = (JarEntry)enumeration.nextElement();
                    return new BlobJarEntry(jarEntry);
                }
                catch (InternalError internalError) {
                    throw new InternalError("Error in CachedJarFile entries");
                }
            }
        };
    }

    private static CodeSource cloneCodeSource(CodeSource codeSource) {
        return new CodeSource(codeSource.getLocation(), codeSource.getCertificates());
    }

    private class BlobJarEntry
    extends JarEntry {
        public BlobJarEntry(JarEntry jarEntry) {
            super(jarEntry);
        }

        @Override
        public Certificate[] getCertificates() {
            return SignedAsBlobJarFile.this.codeSource.getCertificates();
        }

        @Override
        public CodeSigner[] getCodeSigners() {
            return SignedAsBlobJarFile.this.codeSource.getCodeSigners();
        }
    }
}

