/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.nativesandbox;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import com.sun.deploy.nativesandbox.NativeSandboxJNLPService;
import com.sun.deploy.nativesandbox.NativeSandboxOutputStream;
import com.sun.deploy.nativesandbox.comm.Request;
import com.sun.deploy.nativesandbox.comm.Response;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.BufferUtil;
import com.sun.deploy.util.ByteBufferWrapper;
import com.sun.deploy.util.SyncFileAccess;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class NativeSandboxBrokerImpl
implements NativeSandboxBroker {
    private static final boolean TRACE = false;
    private static final AccessControlContext ACC_INSTANCE;
    private static final String[] showDocumentWhiteList;
    private static final String[] denyLAPKeys;
    private static final Object clientWriteLock;
    private static NativeSandboxJNLPService jnlpService;
    public static final int NSB_BUFFER_SIZE = 0x100000;
    public static final String NSB_WRITE_PIPE = "NSBWP";
    public static final String NSB_READ_PIPE = "NSBRP";
    private static final int NSB_COMMAND_WRITE = 0;
    private static final int NSB_COMMAND_APPEND = 1;
    private static final int NSB_COMMAND_DELETE = 2;
    private static final int NSB_COMMAND_DELETEONEXIT = 3;
    private static final int NSB_COMMAND_RENAME = 4;
    private static final int NSB_COMMAND_SHOWDOCUMENT = 5;
    private static final int NSB_COMMAND_BUFFERSIZE = 6;
    private static final int NSB_COMMAND_OPENFILEDIALOG = 7;
    private static final int NSB_COMMAND_OPENMULTIFILEDIALOG = 8;
    private static final int NSB_COMMAND_SAVEFILE = 9;
    private static final int NSB_COMMAND_RAF = 10;
    private static final int NSB_COMMAND_OPENFILE = 11;
    private static final int NSB_COMMAND_OPENFILES = 12;
    private static final int NSB_COMMAND_REMOVEASSOCIATION = 13;
    private static final int NSB_COMMAND_REMOVESHORTCUTS = 14;
    private static final int NSB_COMMAND_REQUESTASSOCIATION = 15;
    private static final int NSB_COMMAND_REQUESTSHORTCUT = 16;
    private static final int NSB_COMMAND_MUFFIN_CREATE = 17;
    private static final int NSB_COMMAND_MUFFIN_GET = 18;
    private static final int NSB_COMMAND_MUFFIN_DELETE = 19;
    private static final int NSB_COMMAND_MUFFIN_SET_TAG = 20;
    private static final int NSB_COMMAND_PARENT_WINDOW = 21;
    private static final int NSB_COMMAND_SET_PROP = 22;
    private final long readPipe;
    private final long writePipe;
    private static final ArrayList<String> verifiedPaths;
    private static final HashMap<String, RandomAccessFile> rafsFile;
    private static final Map<Integer, Long> windowParents;
    private ByteBufferWrapper byteBuffer = null;
    private byte[] buffer = null;
    private int currentBufferSize = 0;

    public NativeSandboxBrokerImpl(long l, long l2) {
        this.readPipe = l;
        this.writePipe = l2;
        this.allocateBuffers(0x100000);
    }

    public static long[] getNativeSandboxPipeHandles() {
        return NativeSandboxBrokerImpl.getNativeSandboxPipeHandles0();
    }

    private synchronized void allocateBuffers(int n) {
        if (this.byteBuffer == null || this.byteBuffer.capacity() < n) {
            this.byteBuffer = BufferUtil.allocateDirect(n);
            this.byteBuffer.order(ByteOrder.nativeOrder());
            this.currentBufferSize = n;
        }
        if (this.buffer == null || this.buffer.length < n) {
            this.buffer = new byte[n];
            this.currentBufferSize = n;
        }
    }

    private static native long[] getNativeSandboxPipeHandles0();

    private int readPipe(byte[] byArray) {
        this.byteBuffer.rewind();
        int n = this.readPipe0(this.readPipe, this.byteBuffer.getBuffer());
        this.byteBuffer.getBuffer().get(byArray);
        return n;
    }

    private native int readPipe0(long var1, ByteBuffer var3);

    private int writePipe(byte[] byArray, int n) {
        this.byteBuffer.rewind();
        this.byteBuffer.getBuffer().put(byArray, 0, n);
        return this.writePipe0(this.writePipe, this.byteBuffer.getBuffer(), n);
    }

    private native int writePipe0(long var1, ByteBuffer var3, int var4);

    private synchronized Response sendRequest(Request request) {
        int n;
        byte[] byArray = this.getObjectBytes(request);
        if (byArray == null || byArray.length <= 0) {
            Trace.println("NativeSandboxBroker.sendRequest() failed", TraceLevel.BASIC);
            return null;
        }
        if (this.currentBufferSize < byArray.length) {
            this.allocateBuffers(byArray.length);
            Request request2 = new Request(6);
            request2.setSize(byArray.length);
            byte[] byArray2 = this.getObjectBytes(request2);
            if (byArray2 == null || byArray2.length <= 0) {
                Trace.println("NativeSandboxBroker.sendRequest() failed", TraceLevel.BASIC);
                return null;
            }
            int n2 = this.writePipe(byArray2, byArray2.length);
            if (n2 < 0) {
                Trace.println("NativeSandboxBroker.sendRequest() failed", TraceLevel.BASIC);
                return null;
            }
        }
        if ((n = this.writePipe(byArray, byArray.length)) < 0) {
            Trace.println("NativeSandboxBroker.sendRequest() failed", TraceLevel.BASIC);
            return null;
        }
        int n3 = this.readPipe(this.buffer);
        if (n3 <= 0) {
            Trace.println("NativeSandboxBroker.sendRequest() failed", TraceLevel.BASIC);
        }
        Response response = (Response)this.getObjectFromBytes(this.buffer, n3, true);
        return response;
    }

    public void runNativeSandboxBroker() {
        boolean bl = true;
        block28: do {
            Object object;
            int n;
            if ((n = this.readPipe(this.buffer)) <= 0) {
                Trace.println("NativeSandboxBroker.runNativeSandboxBroker() failed", TraceLevel.BASIC);
                break;
            }
            Request request = (Request)this.getObjectFromBytes(this.buffer, n, false);
            Response response = new Response(request.getCommand());
            boolean bl2 = false;
            try {
                switch (request.getCommand()) {
                    case 0: {
                        bl2 = this.writeFile(request);
                        break;
                    }
                    case 1: {
                        bl2 = this.appendFile(request);
                        break;
                    }
                    case 2: {
                        bl2 = this.deleteFile(request);
                        break;
                    }
                    case 3: {
                        bl2 = this.deleteOnExitFile(request);
                        break;
                    }
                    case 4: {
                        bl2 = this.renameFile(request);
                        break;
                    }
                    case 5: {
                        bl2 = this.showDocument(request);
                        break;
                    }
                    case 6: {
                        this.allocateBuffers(request.getSize());
                        continue block28;
                    }
                    case 7: {
                        object = this.openFileDialog(request);
                        if (object != null) {
                            response.setFileList(new String[]{object});
                            bl2 = true;
                        }
                        break;
                    }
                    case 8: {
                        String[] stringArray = this.openMultiFileDialog(request);
                        if (stringArray != null & stringArray.length > 0) {
                            response.setFileList(stringArray);
                            bl2 = true;
                        }
                        break;
                    }
                    case 9: {
                        object = this.saveFile(request);
                        if (object != null) {
                            response.setFileList(new String[]{object});
                            bl2 = true;
                        }
                        break;
                    }
                    case 10: {
                        NativeSandboxBroker.RAF rAF = this.sendRAF(request);
                        if (rAF != null) {
                            response.setRAF(rAF);
                            bl2 = true;
                        }
                        break;
                    }
                    case 11: {
                        bl2 = this.openFile(request);
                        break;
                    }
                    case 12: {
                        bl2 = this.openFiles(request);
                        break;
                    }
                    case 13: {
                        bl2 = this.removeAssociation(request);
                        break;
                    }
                    case 14: {
                        bl2 = this.removeShortcuts(request);
                        break;
                    }
                    case 15: {
                        bl2 = this.requestAssociation(request);
                        break;
                    }
                    case 16: {
                        bl2 = this.requestShortcut(request);
                        break;
                    }
                    case 17: {
                        long l = this.createMuffin(request);
                        response.setLongResult(l);
                        bl2 = true;
                        break;
                    }
                    case 19: {
                        this.deleteMuffin(request);
                        bl2 = true;
                        break;
                    }
                    case 18: {
                        object = this.getMuffin(request);
                        if (object != null) {
                            response.setFileList(new String[]{object});
                            bl2 = true;
                        }
                        break;
                    }
                    case 20: {
                        this.setMuffinTag(request);
                        bl2 = true;
                        break;
                    }
                    case 21: {
                        this.parentWindow(request);
                        bl2 = true;
                        break;
                    }
                    case 22: {
                        this.setProperty(request);
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl2 = false;
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                response.setException(iOException.getMessage());
            }
            catch (Exception exception) {
                bl2 = false;
            }
            response.setBooleanResult(bl2);
            object = this.getObjectBytes(response);
            if (object == null || ((Object)object).length <= 0) {
                Trace.println("NativeSandboxBroker.runNativeSandboxBroker() failed", TraceLevel.BASIC);
                continue;
            }
            int n2 = this.writePipe((byte[])object, ((Object)object).length);
            if (n2 >= 0) continue;
            Trace.println("NativeSandboxBroker.runNativeSandboxBroker() failed", TraceLevel.BASIC);
        } while (bl);
    }

    private boolean isValidCacheEntryPath(String string) {
        String string2 = Config.getSandboxTrustedCertificateFile();
        if (string.equals(string2)) {
            return true;
        }
        String string3 = Config.getSplashDir();
        if (string.startsWith(string3)) {
            return true;
        }
        String string4 = Config.getDefaultCacheDirectory();
        if (string.startsWith(string4)) {
            String string5 = string.substring(string4.length());
            String[] stringArray = string5.split("\\\\");
            if (stringArray.length != 4) {
                return false;
            }
            if (!stringArray[0].isEmpty()) {
                return false;
            }
            if (!stringArray[1].equals("6.0")) {
                return false;
            }
            if (!stringArray[2].matches("^[0-9]{1}$") && !stringArray[2].matches("^[0-9]{2}$")) {
                return false;
            }
            int n = Integer.parseInt(stringArray[2]);
            return n >= 0 && n <= 63;
        }
        return false;
    }

    private boolean isLAPFile(String string) {
        String string2;
        return string.length() > 5 && (string2 = string.substring(string.length() - 4)).equalsIgnoreCase(".lap") && this.isValidCacheEntryPath(string);
    }

    private boolean isLAPFileDataValid(byte[] byArray) {
        try {
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(byArray));
            for (int i = 0; i < denyLAPKeys.length; ++i) {
                String string = (String)properties.get(denyLAPKeys[i]);
                if (string == null) continue;
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean verifyFilePath(String string) {
        if (string == null) {
            return false;
        }
        if (verifiedPaths.contains(string)) {
            return true;
        }
        if (string.contains("..") || string.contains("/")) {
            return false;
        }
        if (!this.isValidCacheEntryPath(string)) {
            return false;
        }
        verifiedPaths.add(string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(Request request) throws IOException {
        if (!this.verifyFilePath(request.getPath1())) {
            return false;
        }
        if (this.isLAPFile(request.getPath1()) && !this.isLAPFileDataValid(request.getData())) {
            return false;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(request.getData());
        FilterOutputStream filterOutputStream = null;
        SyncFileAccess.FileOutputStreamLock fileOutputStreamLock = null;
        FileOutputStream fileOutputStream = null;
        try {
            SyncFileAccess syncFileAccess = new SyncFileAccess(new File(request.getPath1()));
            fileOutputStreamLock = syncFileAccess.openLockFileOutputStream(false, 1000, false);
            fileOutputStream = fileOutputStreamLock.getFileOutputStream();
            if (fileOutputStream == null) {
                fileOutputStream = new FileOutputStream(new File(request.getPath1()));
            }
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = new byte[request.getData().length];
            int n = byteArrayInputStream.read(byArray);
            while (n >= 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                n = byteArrayInputStream.read(byArray);
            }
        }
        finally {
            if (fileOutputStreamLock != null) {
                fileOutputStreamLock.release();
            } else if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            if (byteArrayInputStream != null) {
                ((InputStream)byteArrayInputStream).close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean appendFile(Request request) {
        if (!this.verifyFilePath(request.getPath1())) {
            return false;
        }
        if (this.isLAPFile(request.getPath1())) {
            return false;
        }
        InputStream inputStream = null;
        SyncFileAccess.RandomAccessFileLock randomAccessFileLock = null;
        RandomAccessFile randomAccessFile = null;
        try {
            SyncFileAccess syncFileAccess = new SyncFileAccess(new File(request.getPath1()));
            randomAccessFileLock = syncFileAccess.openLockRandomAccessFile("rw", 1000, false);
            randomAccessFile = randomAccessFileLock != null ? randomAccessFileLock.getRandomAccessFile() : new RandomAccessFile(request.getPath1(), "rw");
            inputStream = new ByteArrayInputStream(request.getData());
            if (request.getOffset() >= 0L) {
                randomAccessFile.seek(request.getOffset());
            } else {
                randomAccessFile.seek(randomAccessFile.length());
            }
            byte[] byArray = new byte[request.getData().length];
            int n = inputStream.read(byArray);
            while (n >= 0) {
                randomAccessFile.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (randomAccessFileLock != null) {
                    randomAccessFileLock.release();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        return true;
    }

    private boolean deleteFile(Request request) {
        if (!this.verifyFilePath(request.getPath1())) {
            return false;
        }
        File file = new File(request.getPath1());
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    private boolean deleteOnExitFile(Request request) {
        if (!this.verifyFilePath(request.getPath1())) {
            return false;
        }
        File file = new File(request.getPath1());
        if (file.exists()) {
            file.deleteOnExit();
        }
        return true;
    }

    private boolean renameFile(Request request) {
        if (!this.verifyFilePath(request.getPath1()) || !this.isValidCacheEntryPath(request.getPath1()) || this.isLAPFile(request.getPath1()) || !this.verifyFilePath(request.getPath2()) || !this.isValidCacheEntryPath(request.getPath2()) || this.isLAPFile(request.getPath2())) {
            return false;
        }
        File file = new File(request.getPath1());
        File file2 = new File(request.getPath2());
        return file.renameTo(file2);
    }

    private boolean showDocument(Request request) {
        String string = request.getPath1();
        for (int i = 0; i < showDocumentWhiteList.length; ++i) {
            if (!showDocumentWhiteList[i].equals(string)) continue;
            Platform.get().showDocument(string);
            return true;
        }
        if (jnlpService == null) {
            return false;
        }
        return jnlpService.showDocument(string);
    }

    private String openFileDialog(Request request) {
        if (jnlpService == null) {
            return null;
        }
        String string = jnlpService.openFileDialog(request.getPath1(), request.getStrings());
        if (string != null) {
            verifiedPaths.add(string);
        }
        return string;
    }

    private String[] openMultiFileDialog(Request request) {
        if (jnlpService == null) {
            return null;
        }
        String[] stringArray = jnlpService.openMultiFileDialog(request.getPath1(), request.getStrings());
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                verifiedPaths.add(stringArray[i]);
            }
        }
        return stringArray;
    }

    private String saveFile(Request request) {
        if (jnlpService == null) {
            return null;
        }
        String string = jnlpService.saveFile(request.getPath1(), request.getStrings(), request.getPath2());
        if (string != null) {
            verifiedPaths.add(string);
        }
        return string;
    }

    private NativeSandboxBroker.RAF sendRAF(Request request) {
        NativeSandboxBroker.RAF rAF = request.getRAF();
        if (rAF == null) {
            return null;
        }
        if (!this.verifyFilePath(rAF.getFile()) || this.isValidCacheEntryPath(rAF.getFile())) {
            return null;
        }
        NativeSandboxBroker.RAF rAF2 = new NativeSandboxBroker.RAF(rAF.getCommand(), null);
        RandomAccessFile randomAccessFile = rafsFile.get(rAF.getFile());
        if (randomAccessFile == null) {
            try {
                randomAccessFile = new RandomAccessFile(rAF.getFile(), "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                rAF2.setIOException(fileNotFoundException.getMessage());
                return rAF2;
            }
            rafsFile.put(rAF.getFile(), randomAccessFile);
        }
        try {
            switch (rAF.getCommand()) {
                case 0: {
                    randomAccessFile.close();
                    rafsFile.remove(rAF.getFile());
                    break;
                }
                case 1: {
                    rAF2.setLongValue(randomAccessFile.getFilePointer());
                    break;
                }
                case 2: {
                    rAF2.setLongValue(randomAccessFile.length());
                    break;
                }
                case 3: {
                    int n = (int)rAF.getLongValue();
                    if (n <= 0) {
                        throw new IOException("b.length <= 0");
                    }
                    byte[] byArray = new byte[n];
                    randomAccessFile.read(byArray);
                    rAF2.setData(byArray);
                    break;
                }
                case 4: {
                    rAF2.setString(randomAccessFile.readLine());
                    break;
                }
                case 5: {
                    rAF2.setString(randomAccessFile.readUTF());
                    break;
                }
                case 6: {
                    randomAccessFile.seek(rAF.getLongValue());
                    break;
                }
                case 7: {
                    randomAccessFile.setLength(rAF.getLongValue());
                    break;
                }
                case 8: {
                    int n = randomAccessFile.skipBytes((int)rAF.getLongValue());
                    rAF2.setLongValue(n);
                    break;
                }
                case 9: {
                    randomAccessFile.write(rAF.getData());
                }
            }
        }
        catch (EOFException eOFException) {
            rAF2.setEOFException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            rAF2.setIOException(iOException.getMessage());
        }
        return rAF2;
    }

    private boolean openFile(Request request) {
        if (jnlpService == null) {
            return false;
        }
        boolean bl = jnlpService.openFile(request.getPath1());
        if (bl) {
            verifiedPaths.add(request.getPath1());
        }
        return bl;
    }

    private boolean openFiles(Request request) {
        if (jnlpService == null) {
            return false;
        }
        boolean bl = jnlpService.openFiles(request.getStrings());
        if (bl) {
            String[] stringArray = request.getStrings();
            for (int i = 0; i < stringArray.length; ++i) {
                verifiedPaths.add(stringArray[i]);
            }
        }
        return bl;
    }

    private boolean removeAssociation(Request request) {
        if (jnlpService == null) {
            return false;
        }
        return jnlpService.removeAssociation(request.getPath1(), request.getStrings());
    }

    private boolean removeShortcuts(Request request) {
        if (jnlpService == null) {
            return false;
        }
        return jnlpService.removeShortcuts();
    }

    private boolean requestAssociation(Request request) {
        if (jnlpService == null) {
            return false;
        }
        return jnlpService.requestAssociation(request.getPath1(), request.getStrings());
    }

    private boolean requestShortcut(Request request) {
        if (jnlpService == null) {
            return false;
        }
        byte[] byArray = request.getData();
        if (byArray == null || byArray.length != 2) {
            return false;
        }
        boolean bl = byArray[0] == 1;
        boolean bl2 = byArray[1] == 1;
        String string = request.getPath1();
        return jnlpService.requestShortcut(bl, bl2, string);
    }

    private long createMuffin(Request request) throws IOException {
        if (jnlpService == null) {
            return 0L;
        }
        String string = request.getPath1();
        long l = request.getOffset();
        return jnlpService.createMuffin(string, l);
    }

    private void deleteMuffin(Request request) throws IOException {
        if (jnlpService == null) {
            // empty if block
        }
        String string = request.getPath1();
        jnlpService.deleteMuffin(string);
    }

    private String getMuffin(Request request) throws IOException {
        if (jnlpService == null) {
            return null;
        }
        String string = request.getPath1();
        String string2 = jnlpService.getMuffin(string);
        if (string2 != null) {
            verifiedPaths.add(string2);
        }
        return string2;
    }

    private void setMuffinTag(Request request) throws IOException {
        if (jnlpService == null) {
            // empty if block
        }
        String string = request.getPath1();
        int n = request.getSize();
        jnlpService.setMuffinTag(string, n);
    }

    private native void parentWindow0(long var1, long var3);

    private void parentWindow(Request request) {
        int n = request.getAppletID();
        Long l = windowParents.get(n);
        if (l == null) {
            return;
        }
        this.parentWindow0(l, request.getChild());
    }

    private void setProperty(Request request) {
        switch (request.getIntValue()) {
            case 1: {
                Config.setBooleanProperty("deployment.deprecation.plugin.dialog.show", false);
            }
        }
        Config.get().storeIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParentWindow(int n, long l) {
        Map<Integer, Long> map = windowParents;
        synchronized (map) {
            windowParents.put(n, l);
        }
    }

    public static synchronized void setNativeSandboxJNLPService(NativeSandboxJNLPService nativeSandboxJNLPService) {
        if (jnlpService == null) {
            jnlpService = nativeSandboxJNLPService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFile(String string, byte[] byArray, long l, boolean bl) throws IOException {
        Object object = clientWriteLock;
        synchronized (object) {
            Response response;
            Request request = new Request(bl ? 1 : 0);
            request.setPath1(string);
            request.setData(byArray);
            if (bl) {
                request.setOffset(l);
            }
            if ((response = this.sendRequest(request)) != null) {
                if (response.getException() != null) {
                    throw new IOException(response.getException());
                }
                return response.getBooleanResult();
            }
            return false;
        }
    }

    @Override
    public boolean writeFile(File file, byte[] byArray) throws IOException {
        if (file == null) {
            return false;
        }
        return this.writeFile(file.getAbsolutePath(), byArray, -1L, false);
    }

    @Override
    public boolean writeFile(RandomAccessFile randomAccessFile, File file, long l, byte[] byArray) throws IOException {
        if (file == null) {
            return false;
        }
        return this.writeFile(file.getAbsolutePath(), byArray, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(File file) {
        Object object = clientWriteLock;
        synchronized (object) {
            if (!file.exists()) {
                return false;
            }
            Request request = new Request(2);
            request.setPath1(file.getAbsolutePath());
            Response response = this.sendRequest(request);
            if (response != null) {
                return response.getBooleanResult();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteOnExitFile(File file) {
        Object object = clientWriteLock;
        synchronized (object) {
            if (!file.exists()) {
                return false;
            }
            Request request = new Request(3);
            request.setPath1(file.getAbsolutePath());
            Response response = this.sendRequest(request);
            if (response != null) {
                return response.getBooleanResult();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameFile(File file, String string) {
        Object object = clientWriteLock;
        synchronized (object) {
            if (file == null || string == null) {
                return false;
            }
            Request request = new Request(4);
            request.setPath1(file.getAbsolutePath());
            request.setPath2(string);
            Response response = this.sendRequest(request);
            if (response != null) {
                return response.getBooleanResult();
            }
            return false;
        }
    }

    @Override
    public OutputStream getOutputStream(File file, boolean bl) throws IOException {
        if (file == null) {
            return null;
        }
        return new BufferedOutputStream(new NativeSandboxOutputStream(file.getAbsolutePath(), bl), 0x100000);
    }

    @Override
    public boolean showDocument(String string) {
        Request request = new Request(5);
        request.setPath1(string);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public String openFileDialog(String string, String[] stringArray) {
        Request request = new Request(7);
        request.setPath1(string);
        request.setStrings(stringArray);
        Response response = this.sendRequest(request);
        if (response != null && response.getBooleanResult()) {
            return response.getFileList()[0];
        }
        return null;
    }

    @Override
    public String[] openMultiFileDialog(String string, String[] stringArray) {
        Request request = new Request(8);
        request.setPath1(string);
        request.setStrings(stringArray);
        Response response = this.sendRequest(request);
        if (response != null && response.getBooleanResult()) {
            return response.getFileList();
        }
        return null;
    }

    @Override
    public String saveFile(String string, String[] stringArray, String string2) {
        Request request = new Request(9);
        request.setPath1(string);
        request.setPath2(string2);
        request.setStrings(stringArray);
        Response response = this.sendRequest(request);
        if (response != null && response.getBooleanResult()) {
            return response.getFileList()[0];
        }
        return null;
    }

    @Override
    public NativeSandboxBroker.RAF sendRAF(NativeSandboxBroker.RAF rAF) {
        Request request = new Request(10);
        request.setRAF(rAF);
        Response response = this.sendRequest(request);
        if (response != null && response.getBooleanResult()) {
            return response.getRAF();
        }
        return null;
    }

    @Override
    public boolean openFile(String string) {
        Request request = new Request(11);
        request.setPath1(string);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean openFiles(String[] stringArray) {
        Request request = new Request(12);
        request.setStrings(stringArray);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean removeAssociation(String string, String[] stringArray) {
        Request request = new Request(13);
        request.setPath1(string);
        request.setStrings(stringArray);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean removeShortcuts() {
        Request request = new Request(14);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean requestAssociation(String string, String[] stringArray) {
        Request request = new Request(15);
        request.setPath1(string);
        request.setStrings(stringArray);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean requestShortcut(boolean bl, boolean bl2, String string) {
        Request request = new Request(16);
        request.setPath1(string);
        byte[] byArray = new byte[]{bl ? (byte)1 : 0, bl2 ? (byte)1 : 0};
        request.setData(byArray);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public long createMuffin(String string, long l) throws IOException {
        Request request = new Request(17);
        request.setPath1(string);
        request.setOffset(l);
        Response response = this.sendRequest(request);
        if (response != null) {
            if (response.getException() != null) {
                throw new IOException(response.getException());
            }
            return response.getLongResult();
        }
        return 0L;
    }

    @Override
    public void deleteMuffin(String string) throws IOException {
        Request request = new Request(19);
        request.setPath1(string);
        Response response = this.sendRequest(request);
        if (response != null && response.getException() != null) {
            throw new IOException(response.getException());
        }
    }

    @Override
    public String getMuffin(String string) throws IOException {
        Request request = new Request(18);
        request.setPath1(string);
        Response response = this.sendRequest(request);
        if (response != null) {
            if (response.getException() != null) {
                throw new IOException(response.getException());
            }
            return response.getFileList()[0];
        }
        return null;
    }

    @Override
    public void setMuffinTag(String string, int n) throws IOException {
        Request request = new Request(20);
        request.setPath1(string);
        request.setSize(n);
        Response response = this.sendRequest(request);
        if (response != null && response.getException() != null) {
            throw new IOException(response.getException());
        }
    }

    @Override
    public boolean parentWindow(int n, long l) {
        Request request = new Request(21);
        request.setAppletID(n);
        request.setChild(l);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    @Override
    public boolean setProperty(int n) {
        Request request = new Request(22);
        request.setIntValue(n);
        Response response = this.sendRequest(request);
        if (response != null) {
            return response.getBooleanResult();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getObjectBytes(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutput objectOutput = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutput = new ObjectOutputStream(byteArrayOutputStream);
            objectOutput.flush();
            objectOutput.writeObject(object);
            objectOutput.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (objectOutput != null) {
                try {
                    objectOutput.close();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectFromBytes(byte[] byArray, int n, boolean bl) {
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInput objectInput = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
            objectInput = new ObjectInputStream(byteArrayInputStream);
            if (bl) {
                final ObjectInput objectInput2 = objectInput;
                Object object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException, ClassNotFoundException {
                        return objectInput2.readObject();
                    }
                }, ACC_INSTANCE);
                return object;
            }
            Object object = objectInput.readObject();
            return object;
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
            Object var7_14 = null;
            return var7_14;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.ignoredException(classNotFoundException);
            Object var7_15 = null;
            return var7_15;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignoredException(privilegedActionException);
            Object var7_16 = null;
            return var7_16;
        }
        finally {
            if (objectInput != null) {
                try {
                    objectInput.close();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
        }
    }

    static {
        RuntimePermission runtimePermission = new RuntimePermission("accessClassInPackage.com.sun.deploy.nativesandbox.comm");
        PermissionCollection permissionCollection = runtimePermission.newPermissionCollection();
        permissionCollection.add(runtimePermission);
        ACC_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissionCollection)});
        showDocumentWhiteList = new String[]{"http://bugs.sun.com", "http://www.java.com", "http://java.com/jcpsecurity", "http://java.com/nativesandbox", "http://java.com/sitelistfaq", "http://java.com/javaplugin"};
        denyLAPKeys = new String[]{"ssv.decision.all-perms.time", "ssv.enable.custom.preloader"};
        clientWriteLock = new Object();
        verifiedPaths = new ArrayList();
        rafsFile = new HashMap();
        windowParents = new HashMap<Integer, Long>();
    }
}

