/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.net.cookie.CookieHandler;
import com.sun.deploy.net.cookie.CookieUnavailableException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeployCookieSelector
extends java.net.CookieHandler {
    private HashMap<String, String> cookieTable = new HashMap();
    private CookieHandler cookieHandler = null;

    public static synchronized void reset() {
        java.net.CookieHandler.setDefault(new DeployCookieSelector());
    }

    private boolean canServeCookies(URI uRI) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SecureCookiePermission(uRI));
            }
            catch (SecurityException securityException) {
                if (uRI != null && !uRI.getScheme().toLowerCase().equals("http")) {
                    Trace.msgSecurityPrintln("Possible use of 'Secure' cookies blocked for " + uRI);
                    Trace.msgSecurityPrintln("To use secure cookie (HTTPS), consider signing the application or host application with HTTPS");
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized Map<String, List<String>> get(URI uRI, Map<String, List<String>> map) throws IOException {
        String string;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        URI uRI2 = uRI;
        if (!this.canServeCookies(uRI2)) {
            try {
                uRI2 = new URI("http", uRI.getSchemeSpecificPart(), uRI.getFragment());
            }
            catch (Exception exception) {
                Trace.ignoredException(exception);
            }
            if (!this.canServeCookies(uRI2)) {
                return hashMap;
            }
        }
        if ((string = this.getCookieInfo(uRI2.toURL())) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            hashMap.put("Cookie", arrayList);
        }
        return hashMap;
    }

    @Override
    public synchronized void put(URI uRI, Map<String, List<String>> map) throws IOException {
        for (String string : map.keySet()) {
            List<String> list;
            if (string == null || !string.equalsIgnoreCase("Set-Cookie") && !string.equalsIgnoreCase("Set-Cookie2") || (list = map.get(string)) == null) continue;
            for (String string2 : list) {
                if (string2 == null) continue;
                this.setCookieInfo(uRI.toURL(), string2);
            }
        }
    }

    protected void setCookieInfo(URL uRL, String string) {
        this.initializeImpl();
        if (Trace.isEnabled(TraceLevel.NETWORK)) {
            Trace.msgNetPrintln("net.cookie.server", new Object[]{uRL, string});
        }
        try {
            this.setCookieInBrowser(uRL, string);
        }
        catch (CookieUnavailableException cookieUnavailableException) {
            System.out.println(ResourceManager.getString("net.cookie.ignore.setcookie"));
        }
    }

    protected String getCookieInfo(URL uRL) {
        this.initializeImpl();
        String string = null;
        try {
            String string2 = uRL.getFile();
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            String string3 = uRL.getProtocol() + "://" + uRL.getHost() + string2;
            try {
                string = this.getCookieFromBrowser(uRL);
                if (!(string == null || string.equals("") || string.equals("\n") || string.equals("\r\n"))) {
                    this.cookieTable.put(string3, string);
                } else {
                    this.cookieTable.put(string3, "");
                    string = null;
                }
            }
            catch (CookieUnavailableException cookieUnavailableException) {
                if (Trace.isEnabled(TraceLevel.NETWORK)) {
                    Trace.msgNetPrintln(ResourceManager.getString("net.cookie.noservice"));
                }
                string = this.cookieTable.get(string3);
            }
            if (string != null && Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.msgNetPrintln("net.cookie.connect", new Object[]{uRL, string});
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    protected void initializeImpl() {
        if (this.cookieHandler == null) {
            Service service = ServiceManager.getService();
            this.cookieHandler = service.getCookieHandler();
        }
    }

    protected void setCookieInBrowser(URL uRL, String string) throws CookieUnavailableException {
        if (this.cookieHandler != null) {
            this.cookieHandler.setCookieInfo(uRL, string);
        }
    }

    protected String getCookieFromBrowser(URL uRL) throws CookieUnavailableException {
        if (this.cookieHandler != null) {
            return this.cookieHandler.getCookieInfo(uRL);
        }
        return null;
    }
}

