/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.DirectProxyHandler;
import com.sun.deploy.net.proxy.ManualProxyHandler;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.net.proxy.UserDefinedProxyConfig;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class DynamicProxyManager {
    private static HashMap<String, List<Proxy>> proxyCache = new HashMap();
    private static ProxyHandler handler = null;
    private static final AccessControlContext ACC_PROXY_INSTANCE;

    public static synchronized List<Proxy> getProxyList(URL uRL, boolean bl) {
        Object object;
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(uRL.getPort());
        String string3 = stringBuffer.toString();
        List<Proxy> list = null;
        if (handler.isProxyCacheSupported()) {
            list = proxyCache.get(string3);
        }
        if (list == null) {
            try {
                list = new ArrayList<Proxy>();
                if (!string2.equals("127.0.0.1") && !string2.equals("localhost")) {
                    object = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), "");
                    ProxyInfo[] proxyInfoArray = handler.getProxyInfo((URL)object);
                    for (int i = 0; i < proxyInfoArray.length; ++i) {
                        if (proxyInfoArray[i].isProxyUsed()) {
                            list.add(DynamicProxyManager.getProxy(proxyInfoArray[i], bl));
                            continue;
                        }
                        list.add(Proxy.NO_PROXY);
                    }
                } else {
                    list.add(Proxy.NO_PROXY);
                }
                if (handler.isProxyCacheSupported()) {
                    proxyCache.put(string3.toString(), list);
                }
            }
            catch (ProxyUnavailableException proxyUnavailableException) {
                Trace.msgNetPrintln("net.proxy.service.not_available", new Object[]{uRL});
                list.add(Proxy.NO_PROXY);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.msgNetPrintln("net.proxy.service.not_available", new Object[]{uRL});
                Trace.ignored(malformedURLException);
                list.add(Proxy.NO_PROXY);
            }
        }
        object = new ArrayList();
        object = list;
        return object;
    }

    private static Proxy getProxy(final ProxyInfo proxyInfo, final boolean bl) {
        Proxy proxy = null;
        try {
            proxy = AccessController.doPrivileged(new PrivilegedExceptionAction<Proxy>(){

                @Override
                public Proxy run() throws IOException {
                    if (bl) {
                        if (proxyInfo.isSocksUsed()) {
                            return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyInfo.getSocksProxy(), proxyInfo.getSocksPort()));
                        }
                        return Proxy.NO_PROXY;
                    }
                    if (proxyInfo.getProxy() == null && proxyInfo.isSocksUsed()) {
                        return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyInfo.getSocksProxy(), proxyInfo.getSocksPort()));
                    }
                    return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyInfo.getProxy(), proxyInfo.getPort()));
                }
            }, ACC_PROXY_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return proxy;
    }

    public static synchronized void setNoProxy(URL uRL) {
        String string = DynamicProxyManager.buildProxyKey(uRL);
        if (handler.isProxyCacheSupported()) {
            ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
            arrayList.add(Proxy.NO_PROXY);
            proxyCache.put(string, arrayList);
        }
    }

    private static String buildProxyKey(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(uRL.getPort());
        return stringBuffer.toString();
    }

    protected static synchronized void removeProxyFromCache(URL uRL, String string) {
        String string2 = DynamicProxyManager.buildProxyKey(uRL);
        if (proxyCache.containsKey(string2)) {
            List<Proxy> list = proxyCache.get(string2);
            ListIterator<Proxy> listIterator = list.listIterator();
            ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
            while (listIterator.hasNext()) {
                Proxy proxy = listIterator.next();
                InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
                if (inetSocketAddress == null || !string.contains(inetSocketAddress.getHostName())) continue;
                arrayList.add(proxy);
            }
            listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                list.remove(listIterator.next());
            }
            if (list.size() == 0) {
                proxyCache.remove(string2);
            }
        }
    }

    public static synchronized void reset() {
        try {
            Object object;
            proxyCache.clear();
            UserDefinedProxyConfig userDefinedProxyConfig = new UserDefinedProxyConfig();
            BrowserProxyInfo browserProxyInfo = userDefinedProxyConfig.getBrowserProxyInfo();
            Service service = ServiceManager.getService();
            if (browserProxyInfo.getType() == 3) {
                object = service.getProxyConfig();
                browserProxyInfo = object.getBrowserProxyInfo();
            }
            switch (browserProxyInfo.getType()) {
                case 4: {
                    try {
                        object = service.getSystemProxyHandler();
                        if (object == null) {
                            throw new ProxyConfigException("Unable to obtain system proxy handler.");
                        }
                        handler = object;
                        handler.init(browserProxyInfo);
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.ignoredException(proxyConfigException);
                    }
                    break;
                }
                case 3: {
                    try {
                        object = service.getBrowserProxyHandler();
                        if (object == null) {
                            throw new ProxyConfigException("Unable to obtain browser proxy handler.");
                        }
                        handler = object;
                        handler.init(browserProxyInfo);
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.ignoredException(proxyConfigException);
                    }
                    break;
                }
                case 0: {
                    try {
                        handler = new DirectProxyHandler();
                        handler.init(browserProxyInfo);
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.ignoredException(proxyConfigException);
                    }
                    break;
                }
                case 1: {
                    try {
                        handler = new ManualProxyHandler();
                        handler.init(browserProxyInfo);
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.msgNetPrintln("net.proxy.loading.manual.error");
                        try {
                            browserProxyInfo.setType(0);
                            handler = new DirectProxyHandler();
                            handler.init(browserProxyInfo);
                        }
                        catch (ProxyConfigException proxyConfigException2) {
                            Trace.ignoredException(proxyConfigException2);
                        }
                    }
                    break;
                }
                case 2: {
                    try {
                        object = service.getAutoProxyHandler();
                        if (object == null) {
                            throw new ProxyConfigException("Unable to obtain auto proxy handler.");
                        }
                        handler = object;
                        handler.init(browserProxyInfo);
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.msgNetPrintln("net.proxy.loading.auto.error");
                        try {
                            browserProxyInfo.setType(1);
                            handler = new ManualProxyHandler();
                            handler.init(browserProxyInfo);
                        }
                        catch (ProxyConfigException proxyConfigException3) {
                            Trace.msgNetPrintln("net.proxy.loading.manual.error");
                            try {
                                browserProxyInfo.setType(0);
                                handler = new DirectProxyHandler();
                                handler.init(browserProxyInfo);
                            }
                            catch (ProxyConfigException proxyConfigException4) {
                                Trace.ignoredException(proxyConfigException4);
                            }
                        }
                    }
                    break;
                }
                default: {
                    Trace.ignored(new IllegalStateException("DynamicProxyManager: Invalid Proxy Type: " + browserProxyInfo.getType() + " using ProxyType.NONE."));
                    try {
                        browserProxyInfo.setType(0);
                        handler = new DirectProxyHandler();
                        handler.init(browserProxyInfo);
                        break;
                    }
                    catch (ProxyConfigException proxyConfigException) {
                        Trace.ignoredException(proxyConfigException);
                    }
                }
            }
            object = browserProxyInfo;
            AccessController.doPrivileged(new PrivilegedAction<Void>((BrowserProxyInfo)object){
                final /* synthetic */ BrowserProxyInfo val$info;
                {
                    this.val$info = browserProxyInfo;
                }

                @Override
                public Void run() {
                    DynamicProxyManager.setProperties(this.val$info);
                    return null;
                }
            });
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.msgNetPrintln(browserProxyInfo.toString());
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
            ToolkitStore.getUI().showExceptionDialog(null, null, throwable, null, null, null, null);
        }
    }

    private static void setProperties(BrowserProxyInfo browserProxyInfo) {
        Properties properties = System.getProperties();
        int n = browserProxyInfo.getType();
        StringBuffer stringBuffer = new StringBuffer();
        if (browserProxyInfo.getHttpHost() != null) {
            stringBuffer.append("http=" + browserProxyInfo.getHttpHost());
            if (browserProxyInfo.getHttpPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getHttpPort());
            }
        }
        if (browserProxyInfo.getHttpsHost() != null) {
            stringBuffer.append(",https=" + browserProxyInfo.getHttpsHost());
            if (browserProxyInfo.getHttpsPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getHttpsPort());
            }
        }
        if (browserProxyInfo.getFtpHost() != null) {
            stringBuffer.append(",ftp=" + browserProxyInfo.getFtpHost());
            if (browserProxyInfo.getFtpPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getFtpPort());
            }
        }
        if (browserProxyInfo.getGopherHost() != null) {
            stringBuffer.append(",gopher=" + browserProxyInfo.getGopherHost());
            if (browserProxyInfo.getGopherPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getGopherPort());
            }
        }
        if (browserProxyInfo.getSocksHost() != null) {
            stringBuffer.append(",socks=" + browserProxyInfo.getSocksHost());
            if (browserProxyInfo.getSocksPort() != -1) {
                stringBuffer.append(":" + browserProxyInfo.getSocksPort());
            }
        }
        String string = stringBuffer.toString();
        String[] stringArray = browserProxyInfo.getOverrides();
        String string2 = null;
        if (stringArray != null) {
            stringBuffer = new StringBuffer();
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[i]);
            }
            string2 = stringBuffer.toString();
        }
        properties.remove("javaplugin.proxy.config.type");
        properties.remove("javaplugin.proxy.config.list");
        properties.remove("javaplugin.proxy.config.bypass");
        if (n == 0) {
            properties.put("javaplugin.proxy.config.type", "direct");
        } else if (n == 1) {
            properties.put("javaplugin.proxy.config.type", "manual");
            if (string != null) {
                properties.put("javaplugin.proxy.config.list", string);
            }
            if (string2 != null) {
                properties.put("javaplugin.proxy.config.bypass", string2);
            }
        } else if (n == 2) {
            properties.put("javaplugin.proxy.config.type", "auto");
        } else if (n == 3) {
            properties.put("javaplugin.proxy.config.type", "browser");
            if (string != null) {
                properties.put("javaplugin.proxy.config.list", string);
            }
            if (string2 != null) {
                properties.put("javaplugin.proxy.config.bypass", string2);
            }
        } else {
            properties.put("javaplugin.proxy.config.type", "unknown");
        }
        System.setProperties(properties);
    }

    static {
        Permissions permissions = new Permissions();
        SocketPermission socketPermission = new SocketPermission("*", "connect,resolve");
        ((PermissionCollection)permissions).add(socketPermission);
        ACC_PROXY_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }
}

