/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.jar.JarFile;

class JarIndexWrapper {
    private static final Method getMethod;
    private static final Method getJarFilesMethod;
    private static final Method getJarIndexMethod;
    private static final Method mergeMethod;
    private static final String PKG_PREFIX = "jdk.internal.util.jar";
    private static final String LEGACY_PKG_PREFIX = "sun.misc";
    private final Object jarIndex;

    private static Class<?> getJDKClass(String string) throws ClassNotFoundException {
        try {
            return Class.forName("jdk.internal.util.jar." + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName("sun.misc." + string);
        }
    }

    private JarIndexWrapper(Object object) {
        this.jarIndex = object;
    }

    public static JarIndexWrapper getJarIndex(JarFile jarFile) throws IOException {
        try {
            Object object = getJarIndexMethod.invoke(null, jarFile);
            return object == null ? null : new JarIndexWrapper(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            JarIndexWrapper.rethrowCause(invocationTargetException);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public LinkedList<String> get(String string) {
        try {
            return (LinkedList)getMethod.invoke(this.jarIndex, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            JarIndexWrapper.rethrowCause(invocationTargetException);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public String[] getJarFiles() {
        try {
            return (String[])getJarFilesMethod.invoke(this.jarIndex, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            JarIndexWrapper.rethrowCause(invocationTargetException);
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public void merge(JarIndexWrapper jarIndexWrapper, String string) {
        try {
            mergeMethod.invoke(this.jarIndex, jarIndexWrapper.jarIndex, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            JarIndexWrapper.rethrowCause(invocationTargetException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    private static void rethrowCause(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new AssertionError((Object)invocationTargetException);
    }

    static {
        try {
            Class<?> clazz = JarIndexWrapper.getJDKClass("JarIndex");
            getMethod = clazz.getDeclaredMethod("get", String.class);
            getJarFilesMethod = clazz.getDeclaredMethod("getJarFiles", new Class[0]);
            getJarIndexMethod = clazz.getDeclaredMethod("getJarIndex", JarFile.class);
            mergeMethod = clazz.getDeclaredMethod("merge", clazz, String.class);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }
}

