/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.SignedAsBlobJarFile;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.EnhancedJarVerifier;
import com.sun.deploy.security.JarAsBLOBVerifier;
import com.sun.deploy.security.SimpleJarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.DeployJavaUtilJarAccess;
import com.sun.deploy.util.JarUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.timestamp.TimestampToken;
import sun.security.util.DisabledAlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.util.SignatureFileVerifier;
import sun.security.x509.AlgorithmId;

public abstract class JarVerifier {
    private static final String WEAK_ALGORITHM_CTX_KEY = "jarverifier.weak.ctx_key";
    public static final String PROPERTY_JAR_DISABLED_ALGS = "jdk.jar.disabledAlgorithms";
    protected File jarFile;
    protected File nativePath;
    protected URL jarLocation;
    protected String jarVersion;
    protected boolean hasSingleCodeSource = false;
    protected boolean hasOnlySignedEntries = false;
    protected boolean hasOnlyUnsignedEntries = true;
    protected boolean hasMissingSignedEntries = false;
    protected Manifest manifest;
    protected Map<String, int[]> signerMapCert = new HashMap<String, int[]>();
    protected CodeSourceCache codeSourceCertCache = new CodeSourceCache();
    protected int[] singleSignerIndicesCert;
    protected List<Certificate> signerCerts = new ArrayList<Certificate>();
    protected Map<String, int[]> signerMap = new HashMap<String, int[]>();
    protected CodeSourceCache codeSourceCache = new CodeSourceCache();
    protected List<CodeSigner> signersCS = new ArrayList<CodeSigner>();
    protected int[] singleSignerIndicesCS;
    private String signingInfoMessage;
    private static boolean TEST_INJECT_HAS_UNSIGNED = false;

    protected JarVerifier(URL uRL, String string, File file, File file2) {
        this.jarFile = file;
        this.nativePath = file2;
        this.jarLocation = uRL;
        this.jarVersion = string;
    }

    public URL getJarLocation() {
        return this.jarLocation;
    }

    public String getJarVersion() {
        return this.jarVersion;
    }

    public abstract void validate(DownloadDelegate var1) throws IOException, JARSigningException;

    public Manifest getManifest() {
        return this.manifest;
    }

    public Map<String, int[]> getSignerMapCert() {
        return this.signerMapCert;
    }

    public CodeSourceCache getCodeSourceCertCache() {
        return this.codeSourceCertCache;
    }

    public Map<String, int[]> getSignerMap() {
        return this.signerMap;
    }

    public CodeSourceCache getCodeSourceCache() {
        return this.codeSourceCache;
    }

    public List<Certificate> getSignerCerts() {
        return this.signerCerts;
    }

    public List<CodeSigner> getSignersCS() {
        return this.signersCS;
    }

    public int[] getSingleSignerIndicesCert() {
        if (this.singleSignerIndicesCert != null) {
            return (int[])this.singleSignerIndicesCert.clone();
        }
        return null;
    }

    public int[] getSingleSignerIndicesCS() {
        if (this.singleSignerIndicesCS != null) {
            return (int[])this.singleSignerIndicesCS.clone();
        }
        return null;
    }

    public boolean hasOnlySignedEntries() {
        if (TEST_INJECT_HAS_UNSIGNED) {
            return false;
        }
        return this.hasOnlySignedEntries;
    }

    public boolean hasSingleCodeSource() {
        return this.hasSingleCodeSource;
    }

    public boolean hasMissingSignedEntries() {
        return this.hasMissingSignedEntries;
    }

    public static JarVerifier create(URL uRL, String string, File file, File file2) {
        JarVerifier jarVerifier = JarAsBLOBVerifier.create(uRL, string, file, file2);
        if (jarVerifier == null && (jarVerifier = EnhancedJarVerifier.create(uRL, string, file, file2)) == null) {
            jarVerifier = SimpleJarVerifier.create(uRL, string, file, file2);
        }
        return jarVerifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readAndMaybeSaveStreamTo(InputStream inputStream, boolean bl, String string, File file) throws IOException {
        FilterOutputStream filterOutputStream = null;
        byte[] byArray = new byte[16384];
        try {
            int n;
            File file2;
            if (bl && file != null && (file2 = new File(file, string).getCanonicalFile()).getParentFile().equals(file)) {
                file2.getParentFile().mkdirs();
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            }
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                if (filterOutputStream == null) continue;
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
                filterOutputStream = null;
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    protected void processCertificates(JarFile jarFile, JarEntry jarEntry, String string) throws MalformedURLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Certificate[] certificateArray = null;
        if (this.hasSingleCodeSource) {
            this.signerMapCert.put(string, this.singleSignerIndicesCert);
        } else {
            Object object;
            if (jarEntry != null) {
                certificateArray = jarEntry.getCertificates();
            } else {
                object = null;
                DeployJavaUtilJarAccess deployJavaUtilJarAccess = DeployJavaUtilJarAccess.instance();
                object = deployJavaUtilJarAccess.getCodeSource(jarFile, this.jarLocation, string);
                Certificate[] certificateArray2 = certificateArray = object != null ? ((CodeSource)object).getCertificates() : null;
            }
            if (certificateArray != null && certificateArray.length > 0) {
                int n;
                object = new int[certificateArray.length];
                for (int i = 0; i < certificateArray.length; ++i) {
                    n = this.signerCerts.indexOf(certificateArray[i]);
                    if (n == -1) {
                        n = this.signerCerts.size();
                        this.signerCerts.add(certificateArray[i]);
                    }
                    object[i] = n;
                }
                String string2 = String.valueOf(((Object)object).length);
                for (n = 0; n < ((Object)object).length; ++n) {
                    string2 = string2 + " " + (int)object[n];
                }
                int[] nArray = (int[])hashMap.get(string2);
                if (nArray == null) {
                    hashMap.put(string2, object);
                    CodeSource codeSource = new CodeSource(this.jarLocation, certificateArray);
                    this.codeSourceCertCache.put((int[])object, codeSource);
                } else {
                    object = nArray;
                }
                this.signerMapCert.put(string, (int[])object);
            }
        }
    }

    protected void processSigners(JarFile jarFile, JarEntry jarEntry, String string) throws MalformedURLException {
        CodeSigner[] codeSignerArray = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.hasSingleCodeSource) {
            this.signerMap.put(string, this.singleSignerIndicesCS);
        } else {
            Object object;
            if (jarEntry != null) {
                codeSignerArray = jarEntry.getCodeSigners();
            } else {
                object = DeployJavaUtilJarAccess.instance();
                CodeSource codeSource = ((DeployJavaUtilJarAccess)object).getCodeSource(jarFile, this.jarLocation, string);
                CodeSigner[] codeSignerArray2 = codeSignerArray = codeSource != null ? codeSource.getCodeSigners() : null;
            }
            if (codeSignerArray != null && codeSignerArray.length > 0) {
                int n;
                object = new int[codeSignerArray.length];
                for (int i = 0; i < codeSignerArray.length; ++i) {
                    n = this.signersCS.indexOf(codeSignerArray[i]);
                    if (n == -1) {
                        n = this.signersCS.size();
                        this.signersCS.add(codeSignerArray[i]);
                    }
                    object[i] = n;
                }
                String string2 = String.valueOf(((Object)object).length);
                for (n = 0; n < ((Object)object).length; ++n) {
                    string2 = string2 + " " + (int)object[n];
                }
                int[] nArray = (int[])hashMap.get(string2);
                if (nArray == null) {
                    hashMap.put(string2, object);
                    CodeSource codeSource = new CodeSource(this.jarLocation, codeSignerArray);
                    this.codeSourceCache.put((int[])object, codeSource);
                } else {
                    object = nArray;
                }
                this.signerMap.put(string, (int[])object);
            }
        }
    }

    protected void authenticateJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException, JARSigningException {
        if (jarEntry == null) {
            return;
        }
        String string = jarEntry.getName();
        boolean bl = this.nativePath != null && string.indexOf("/") == -1 && string.indexOf("\\") == -1;
        try {
            JarVerifier.readAndMaybeSaveStreamTo(jarFile.getInputStream(jarEntry), bl, string, this.nativePath);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, securityException);
        }
    }

    public static JarFile getValidatedJarFile(File file, URL uRL, URL uRL2, String string, DownloadDelegate downloadDelegate) throws IOException {
        boolean bl = false;
        JarVerifier jarVerifier = JarVerifier.create(uRL2, string, file, null);
        JarFile jarFile = JarUtil.createJarFile(file, true);
        if (downloadDelegate != null) {
            downloadDelegate.validating(uRL, 0, jarFile.size());
        }
        try {
            jarVerifier.validate(downloadDelegate);
            if (jarVerifier instanceof JarAsBLOBVerifier) {
                jarFile = new SignedAsBlobJarFile(file, (JarAsBLOBVerifier)jarVerifier);
            }
            if (BlackList.getInstance().checkJarFile(jarFile)) {
                JarFile jarFile2 = null;
                return jarFile2;
            }
            bl = true;
        }
        catch (ZipException zipException) {
            throw new JARSigningException(uRL, string, 2, zipException);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(uRL, string, 2, securityException);
        }
        finally {
            if (!bl) {
                jarFile.close();
            }
        }
        return bl ? jarFile : null;
    }

    protected void warnIfUnsigned() {
        try {
            if (this.signersCS.isEmpty() && this.isJarWeaklySigned()) {
                String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return Security.getProperty(JarVerifier.PROPERTY_JAR_DISABLED_ALGS);
                    }
                });
                String string2 = "jdk.jar.disabledAlgorithms=" + string;
                String string3 = ResourceManager.getString("deployment.console.weak.text", this.signingInfoMessage, string2, this.jarFile.getAbsolutePath());
                Trace.println(string3, TraceLevel.SECURITY);
                JarVerifier.setWeakAlgorithmMessage(this.signingInfoMessage);
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    private static void setWeakAlgorithmMessage(String string) {
        ToolkitStore.get().getAppContext().put(WEAK_ALGORITHM_CTX_KEY, string);
    }

    public static String getWeakAlgorithmMessage() {
        return (String)ToolkitStore.get().getAppContext().get(WEAK_ALGORITHM_CTX_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isJarWeaklySigned() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DisabledAlgorithmConstraints disabledAlgorithmConstraints = new DisabledAlgorithmConstraints(PROPERTY_JAR_DISABLED_ALGS);
        Set<CryptoPrimitive> set = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.MESSAGE_DIGEST));
        Set<CryptoPrimitive> set2 = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        HashMap<Object, PKCS7> hashMap2 = new HashMap<Object, PKCS7>();
        JarFile jarFile = null;
        try {
            jarFile = JarUtil.createJarFile(this.jarFile, true);
            byte[] byArray = new byte[8192];
            Enumeration<JarEntry> enumeration = jarFile.entries();
            block15: while (enumeration.hasMoreElements()) {
                Object object5 = (JarEntry)enumeration.nextElement();
                try {
                    object4 = jarFile.getInputStream((ZipEntry)object5);
                    String string = ((ZipEntry)object5).getName();
                    if (!SignatureFileVerifier.isSigningRelated(string) || !SignatureFileVerifier.isBlockOrSF(string)) continue;
                    object3 = string.substring(string.lastIndexOf(47) + 1, string.lastIndexOf(46));
                    if (string.endsWith(".SF")) {
                        object2 = new Manifest((InputStream)object4);
                        for (Object string2 : ((Manifest)object2).getMainAttributes().keySet()) {
                            object = string2.toString();
                            if (!((String)object).endsWith("-Digest-Manifest")) continue;
                            hashMap.put(object3, ((String)object).substring(0, ((String)object).length() - 16));
                            continue block15;
                        }
                        continue;
                    }
                    hashMap2.put(object3, new PKCS7((InputStream)object4));
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
        boolean bl = false;
        for (Object object5 : hashMap.keySet()) {
            object4 = (PKCS7)hashMap2.get(object5);
            if (object4 == null) continue;
            try {
                object3 = ((PKCS7)object4).getSignerInfos()[0];
                object2 = ((SignerInfo)object3).getCertificate((PKCS7)object4);
                String string = (String)hashMap.get(object5);
                String string2 = AlgorithmId.makeSigAlg((String)((SignerInfo)object3).getDigestAlgorithmId().getName(), (String)((SignerInfo)object3).getDigestEncryptionAlgorithmId().getName());
                object = ((Certificate)object2).getPublicKey();
                if (!disabledAlgorithmConstraints.permits(set, string, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.digest", string, this.jarLocation);
                    bl = true;
                    break;
                }
                if (!disabledAlgorithmConstraints.permits(set2, string2, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.signature", string2, this.jarLocation);
                    bl = true;
                    break;
                }
                if (!disabledAlgorithmConstraints.permits(set2, (Key)object)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.key", string2, KeyUtil.getKeySize((Key)object), this.jarLocation);
                    bl = true;
                    break;
                }
                PKCS7 pKCS7 = ((SignerInfo)object3).getTsToken();
                if (pKCS7 == null) continue;
                SignerInfo signerInfo = pKCS7.getSignerInfos()[0];
                X509Certificate x509Certificate = signerInfo.getCertificate(pKCS7);
                byte[] byArray = pKCS7.getContentInfo().getData();
                TimestampToken timestampToken = new TimestampToken(byArray);
                PublicKey publicKey = x509Certificate.getPublicKey();
                String string3 = timestampToken.getHashAlgorithm().getName();
                String string4 = AlgorithmId.makeSigAlg((String)signerInfo.getDigestAlgorithmId().getName(), (String)signerInfo.getDigestEncryptionAlgorithmId().getName());
                if (!disabledAlgorithmConstraints.permits(set, string3, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.ts.digest", string2, this.jarLocation);
                    bl = true;
                    break;
                }
                if (!disabledAlgorithmConstraints.permits(set2, string4, null)) {
                    this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.ts.signature", string2, this.jarLocation);
                    bl = true;
                    break;
                }
                if (disabledAlgorithmConstraints.permits(set2, publicKey)) continue;
                this.signingInfoMessage = ResourceManager.getString("launch.error.unsignedResource.weak.ts.key", string2, KeyUtil.getKeySize((Key)object), this.jarLocation);
                bl = true;
                break;
            }
            catch (Throwable throwable) {
                Trace.ignored(throwable);
            }
        }
        return bl;
    }

    public static class CodeSourceCache {
        private final Map<IndicesKey, CodeSource> map = new HashMap<IndicesKey, CodeSource>();

        public void put(int[] nArray, CodeSource codeSource) {
            this.map.put(CodeSourceCache.wrapKey(nArray), codeSource);
        }

        public CodeSource get(int[] nArray) {
            return this.map.get(CodeSourceCache.wrapKey(nArray));
        }

        public Collection<CodeSource> getCodeSources() {
            return Collections.unmodifiableCollection(this.map.values());
        }

        public int[] findMatchingIndices(CodeSource codeSource) {
            for (Map.Entry<IndicesKey, CodeSource> entry : this.map.entrySet()) {
                CodeSource codeSource2 = entry.getValue();
                if (codeSource2 == null || !codeSource2.equals(codeSource)) continue;
                return entry.getKey().getIndices();
            }
            return null;
        }

        private static IndicesKey wrapKey(int[] nArray) {
            return new IndicesKey(nArray);
        }

        private static class IndicesKey {
            private final int[] indices;

            public IndicesKey(int[] nArray) {
                this.indices = nArray;
            }

            public int[] getIndices() {
                return this.indices != null ? (int[])this.indices.clone() : null;
            }

            public int hashCode() {
                int n = 1;
                n = 31 * n + Arrays.hashCode(this.indices);
                return n;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                IndicesKey indicesKey = (IndicesKey)object;
                return Arrays.equals(this.indices, indicesKey.indices);
            }
        }
    }
}

