/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt.ui;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.AppInitEvent;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.ErrorEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.ProgressDialog;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class DownloadWindow
extends Preloader
implements ActionListener {
    private ProgressDialog progressDialog = null;
    String titleMsg = null;
    String headingMsg = null;
    private int answer = -1;
    private boolean isVisible = false;
    private boolean isInstaller = false;
    private boolean allowVisible = false;
    private int percentComplete = 0;
    private URL currentUrl = null;
    private boolean isCanceled = false;
    private boolean exitOnCancel = false;
    private String statusString = null;
    private static final int TIMER_UPDATE_RATE = 1500;
    private static final int TIMER_INITIAL_DELAY = 8000;
    private static final int TIMER_RECENT_SIZE = 10;
    static final int DELAY_TO_MAKE_VISIBLE = 2000;
    private boolean showOnDelayEnabled = false;
    Timer delayTimer = null;
    javax.swing.Timer timerObject = null;
    private int[] timerDownloadPercents = new int[10];
    private int timerCount = 0;
    private int timerLastPercent = 0;
    private boolean timerOn = false;
    private String pendingHeading;
    WindowAdapter closeListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DownloadWindow.this.cancelAction();
            DownloadWindow.this.resetCanceled();
        }
    };
    private boolean hideOnDownloadCompletion = false;
    private volatile boolean lazyInitialize = false;
    private Component owner;
    private AppInfo ainfo;
    private boolean includeOk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showOnDelay(boolean bl) {
        if (bl == this.showOnDelayEnabled) {
            return;
        }
        if (bl) {
            Object object = this;
            synchronized (object) {
                this.delayTimer = new Timer();
            }
            object = new TimerTask(){

                @Override
                public void run() {
                    DownloadWindow.this.cancelTimer();
                    if (!UIFactory.hasVisibleDialogs()) {
                        DownloadWindow.this.setVisible(true);
                    } else {
                        DownloadWindow.this.showOnDelay(false);
                        DownloadWindow.this.showOnDelay(true);
                    }
                }
            };
            this.delayTimer.schedule((TimerTask)object, 2000L);
            this.showOnDelayEnabled = true;
        } else {
            this.cancelTimer();
            this.showOnDelayEnabled = false;
        }
    }

    @Override
    public synchronized Object getOwner() {
        final Object[] objectArray = new Object[]{null};
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    objectArray[0] = DownloadWindow.this.progressDialog.getDialog();
                }
            }
        });
        return objectArray[0];
    }

    @Override
    public boolean handleEvent(PreloaderEvent preloaderEvent) throws CancelException {
        block0 : switch (preloaderEvent.getType()) {
            case 2: {
                ConfigEvent configEvent = (ConfigEvent)preloaderEvent;
                switch (configEvent.getAction()) {
                    case 1: {
                        this.setStatus((String)configEvent.getValue());
                        break block0;
                    }
                    case 2: {
                        this.setHeading((String)configEvent.getValue(), true);
                        break block0;
                    }
                    case 3: {
                        AppInfo appInfo = (AppInfo)configEvent.getValue();
                        this.initialize(null, appInfo, true, false);
                        break block0;
                    }
                    case 6: {
                        this.setVisible(false);
                        break block0;
                    }
                    case 5: {
                        if (this.progressDialog == null) break block0;
                        this.progressDialog.showProgress(9999);
                        break block0;
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 3: {
                this.showOnDelay(false);
                if (this.isCanceled()) {
                    throw new CancelException("Cancelled");
                }
                DownloadEvent downloadEvent = (DownloadEvent)preloaderEvent;
                switch (downloadEvent.getDownloadType()) {
                    case 0: {
                        if (downloadEvent.getResourceLabel() != null) {
                            this.setStatus(downloadEvent.getResourceLabel());
                        }
                        this.setHeading(ResourceManager.getString("progress.downloading"), true);
                        this.progress(this.currentUrl, downloadEvent.getCompletedCount(), downloadEvent.getTotalCount(), downloadEvent.getOverallPercentage());
                        break block0;
                    }
                    case 2: {
                        this.setHeading(ResourceManager.getString("progress.patching"), true);
                        this.upgradingArchive(this.currentUrl, null, (int)downloadEvent.getCompletedCount(), downloadEvent.getOverallPercentage());
                        break block0;
                    }
                    case 1: {
                        this.setHeading(ResourceManager.getString("progress.verifying"), true);
                        this.validating(this.currentUrl, null, downloadEvent.getCompletedCount(), downloadEvent.getTotalCount(), downloadEvent.getOverallPercentage());
                        break block0;
                    }
                }
                return false;
            }
            case 1: {
                InitEvent initEvent = (InitEvent)preloaderEvent;
                this.hideOnDownloadCompletion = false;
                switch (initEvent.getInitType()) {
                    case 2: {
                        this.titleMsg = "progress.title.installer";
                        this.headingMsg = "progress.launching";
                        this.setAllowVisible(true);
                        this.setVisible(true);
                        this.isInstaller = true;
                        break block0;
                    }
                    case 0: {
                        this.titleMsg = "progress.download.jre";
                        this.headingMsg = "progress.downloading";
                        this.setAllowVisible(true);
                        this.setVisible(true);
                        this.isInstaller = true;
                        break block0;
                    }
                    case 1: {
                        this.hideOnDownloadCompletion = true;
                        this.titleMsg = "progress.title.app";
                        this.headingMsg = "progress.downloading";
                        this.setAllowVisible(true);
                        this.setVisible(true);
                        this.startTimer();
                        break block0;
                    }
                    case 4: {
                        this.titleMsg = "progress.title.app";
                        this.headingMsg = "progress.downloading";
                        this.setAllowVisible(true);
                        this.showOnDelay(true);
                        break block0;
                    }
                    case 5: {
                        this.disposeWindow();
                        break block0;
                    }
                }
                return false;
            }
            case 6: {
                ErrorEvent errorEvent = (ErrorEvent)preloaderEvent;
                this.showOnDelay(false);
                this.downloadFailed(errorEvent.getLocation(), errorEvent.getValue());
                return true;
            }
            case 5: {
                this.showOnDelay(false);
                this.setVisible(false);
                return true;
            }
            case 4: {
                this.showOnDelay(false);
                AppInitEvent appInitEvent = (AppInitEvent)preloaderEvent;
                switch (appInitEvent.getSubtype()) {
                    case 2: {
                        if (!this.isInstaller) {
                            this.setVisible(false);
                            break block0;
                        }
                        this.isInstaller = false;
                        break block0;
                    }
                }
                Trace.println("AppInitEvent that is not handled explicitly", TraceLevel.PRELOADER);
                if (!this.isInstaller) {
                    this.setVisible(false);
                }
                return false;
            }
            default: {
                Trace.println("DownloadWindow can not handle " + preloaderEvent, TraceLevel.PRELOADER);
                return false;
            }
        }
        return true;
    }

    private synchronized void initialize(Component component, AppInfo appInfo, boolean bl, boolean bl2) {
        this.isCanceled = false;
        this.exitOnCancel = bl;
        this.includeOk = bl2;
        this.owner = component;
        this.ainfo = appInfo;
        this.lazyInitialize = true;
    }

    private void lazyInitializeIfNeeded() {
        if (!this.lazyInitialize) {
            return;
        }
        Trace.println("Performing actual init of DownloadWindow", TraceLevel.PRELOADER);
        this.lazyInitialize = false;
        String string = ResourceManager.getString("product.javaws.name", "");
        if (this.progressDialog == null) {
            this.progressDialog = UIFactory.createProgressDialog(this.ainfo, this.owner, string, null, this.includeOk);
        } else {
            this.progressDialog.reset(this.ainfo, string, this.includeOk);
        }
        if (this.progressDialog != null) {
            this.progressDialog.addWindowListener(this.closeListener);
        }
    }

    private void startTimer() {
        this.timerObject = new javax.swing.Timer(1500, this);
        this.timerCount = 0;
        this.timerObject.start();
    }

    private void setStatus(String string) {
        this.statusString = string;
        this.setStatusStringText(string);
    }

    private void setEstimatedTime(String string) {
        if (this.statusString == null || this.statusString.length() == 0) {
            this.setStatusStringText(string);
        }
    }

    private void setStatusStringText(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    DownloadWindow.this.progressDialog.setProgressStatusText(string);
                }
            }
        };
        this.invokeLater(runnable);
    }

    private void setHeading(final String string, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    DownloadWindow.this.progressDialog.setMasthead(string == null ? " " : string, bl);
                }
            }
        };
        this.pendingHeading = null;
        this.invokeLater(runnable);
    }

    private void setHeadingLater(String string) {
        if (this.timerObject != null && this.timerObject.isRunning()) {
            this.pendingHeading = string;
        } else {
            this.setHeading(string, true);
        }
    }

    private void clearWindow() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.clearWindowHelper();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DownloadWindow.this.clearWindowHelper();
                    }
                });
            }
            catch (Exception exception) {
                Trace.ignoredException(exception);
            }
        }
    }

    private void clearWindowHelper() {
        this.reset();
    }

    void disposeWindow() {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    DownloadWindow.this.clearWindow();
                    DownloadWindow.this.exitOnCancel = false;
                    DownloadWindow.this.progressDialog.removeWindowListener(DownloadWindow.this.closeListener);
                    DownloadWindow.this.setVisible(false);
                    DownloadWindow.this.progressDialog = null;
                }
            }
        });
    }

    private void reset() {
        this.stopTimer();
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    DownloadWindow.this.progressDialog.setMasthead("", true);
                    DownloadWindow.this.progressDialog.showProgress(9999);
                    DownloadWindow.this.progressDialog.setProgressStatusText(null);
                }
            }
        });
    }

    private void showDownloadWindow() {
        if (this.allowVisible && !this.isVisible()) {
            this.setVisible(true);
        }
    }

    private void progress(URL uRL, long l, final long l2, final int n) {
        if (n != 100) {
            this.showDownloadWindow();
        }
        this.timerOn = true;
        this.percentComplete = n;
        if (uRL != this.currentUrl && uRL != null) {
            this.setHeadingLater(ResourceManager.getString("progress.downloading"));
            this.currentUrl = uRL;
        }
        this.percentComplete = n;
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    if (l2 == -1L) {
                        DownloadWindow.this.progressDialog.showProgress(9999);
                    } else {
                        DownloadWindow.this.progressDialog.showProgress(n);
                    }
                }
            }
        });
    }

    private void upgradingArchive(URL uRL, String string, int n, int n2) {
        if (n2 != 100) {
            this.showDownloadWindow();
        }
        if (this.currentUrl != uRL || n == 0) {
            if (this.pendingHeading == null) {
                this.setHeadingLater(ResourceManager.getString("progress.patching"));
            }
            this.currentUrl = uRL;
        }
    }

    private void validating(URL uRL, String string, long l, long l2, int n) {
        if (n != 100) {
            this.showDownloadWindow();
        } else if (this.hideOnDownloadCompletion) {
            this.setVisible(false);
        }
        if (this.currentUrl != uRL || l == 0L) {
            if (this.pendingHeading == null) {
                this.setHeadingLater(ResourceManager.getString("progress.verifying"));
            }
            this.currentUrl = uRL;
        }
    }

    private void downloadFailed(URL uRL, String string) {
        this.stopTimer();
        this.setHeading(ResourceManager.getString("progress.download.failed"), true);
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DownloadWindow.this.progressDialog != null) {
                    DownloadWindow.this.progressDialog.showProgress(9999);
                }
            }
        });
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.pendingHeading != null) {
            this.setHeading(this.pendingHeading, true);
        }
        if (!this.timerOn || this.percentComplete <= 0) {
            return;
        }
        ++this.timerCount;
        int n = this.timerCount * 1500;
        int n2 = this.percentComplete - this.timerLastPercent;
        this.timerLastPercent = this.percentComplete;
        this.timerDownloadPercents[this.timerCount % 10] = n2;
        if (n > 8000) {
            int n3;
            int n4 = 0;
            int n5 = Math.min(10, this.timerCount);
            for (n3 = 0; n3 < n5; ++n3) {
                n4 += this.timerDownloadPercents[n3];
            }
            if (this.percentComplete == 100) {
                this.setEstimatedTime("");
            } else if (n4 != 0 && this.percentComplete > 0) {
                String string;
                n3 = n / 1000 * (100 - this.percentComplete) / this.percentComplete;
                int n6 = n3 / 60;
                int n7 = n3 - n6 * 60;
                if (n6 > 0) {
                    String string2 = n6 == 1 ? (n7 == 1 ? "progress.time.left.minute.second" : "progress.time.left.minute.seconds") : (n7 == 1 ? "progress.time.left.minutes.second" : "progress.time.left.minutes.seconds");
                    string = ResourceManager.getString(string2, n6, n7);
                } else {
                    String string3 = n7 == 1 ? "progress.time.left.second" : "progress.time.left.seconds";
                    string = ResourceManager.getString(string3, n7);
                }
                this.setEstimatedTime(string);
            }
        }
    }

    private void stopTimer() {
        this.timerOn = false;
        if (this.timerObject != null) {
            this.timerObject.stop();
            this.timerObject = null;
        }
        if (this.pendingHeading != null) {
            this.setHeading(this.pendingHeading, true);
        }
    }

    private synchronized void cancelTimer() {
        if (this.delayTimer != null) {
            this.delayTimer.cancel();
            this.delayTimer = null;
        }
    }

    synchronized void cancelAction() {
        this.setVisible(false);
        if (this.exitOnCancel) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        DownloadWindow.systemExit(-1);
                    }
                    catch (Exception exception) {
                        Trace.println("systemExit: " + exception, TraceLevel.BASIC);
                        Trace.ignoredException(exception);
                    }
                    return null;
                }
            });
        } else {
            this.isCanceled = true;
        }
    }

    private static void systemExit(int n) throws Exception {
        Trace.flush();
        if (Environment.isJavaPlugin()) {
            RuntimeException runtimeException = new RuntimeException("exit(" + n + ")");
            throw runtimeException;
        }
        System.exit(n);
    }

    private boolean isCanceled() {
        return this.isCanceled;
    }

    private synchronized void resetCanceled() {
        this.isCanceled = false;
    }

    private void setAllowVisible(boolean bl) {
        this.allowVisible = bl;
    }

    private void setVisible(final boolean bl) {
        if (!bl) {
            this.exitOnCancel = false;
            this.stopTimer();
        }
        this.showOnDelay(false);
        if (bl != this.isVisible) {
            this.isVisible = bl;
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        DownloadWindow.this.lazyInitializeIfNeeded();
                        if (DownloadWindow.this.progressDialog != null) {
                            DownloadWindow.this.progressDialog.setTitle(ResourceManager.getString(DownloadWindow.this.titleMsg));
                            DownloadWindow.this.setHeading(ResourceManager.getString(DownloadWindow.this.headingMsg), true);
                            UIFactory.showProgressDialog(DownloadWindow.this.progressDialog);
                            DownloadWindow.this.answer = DownloadWindow.this.progressDialog.getUserAnswer();
                            if (DownloadWindow.this.answer == 1) {
                                DownloadWindow.this.cancelAction();
                            }
                        }
                    } else if (DownloadWindow.this.progressDialog != null) {
                        UIFactory.hideProgressDialog(DownloadWindow.this.progressDialog);
                    }
                }
            });
        } else if (!bl) {
            this.isVisible = false;
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DownloadWindow.this.progressDialog != null) {
                        UIFactory.hideProgressDialog(DownloadWindow.this.progressDialog);
                    }
                }
            });
            this.showOnDelay(false);
        }
    }

    boolean isVisible() {
        return this.isVisible;
    }

    private void invokeLater(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        try {
            DeploySysRun.execute(new DeploySysAction(){

                @Override
                public Object execute() {
                    SwingUtilities.invokeLater(runnable);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }
}

