/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt.ui;

import com.sun.deploy.config.OSType;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleHelper;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public final class SwingConsoleWindow
extends JFrame
implements ConsoleWindow {
    private static final long serialVersionUID = 8147918735685532337L;
    private final ConsoleController controller;
    private final JTextArea textArea;
    private final JScrollPane scroller;
    private final JScrollBar sbHor;
    private final JScrollBar sbVer;

    public static SwingConsoleWindow create(final ConsoleController consoleController) throws Exception {
        final SwingConsoleWindow[] swingConsoleWindowArray = new SwingConsoleWindow[1];
        SwingConsoleWindow.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                swingConsoleWindowArray[0] = new SwingConsoleWindow(consoleController);
            }
        });
        return swingConsoleWindowArray[0];
    }

    public SwingConsoleWindow(final ConsoleController consoleController) {
        super(ResourceManager.getString("console.caption"));
        this.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        this.controller = consoleController;
        Rectangle rectangle = UIFactory.getMouseScreenBounds();
        this.setBounds(rectangle.x, rectangle.y, 450, 400);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.getRootPane().putClientProperty("Window.style", "small");
        this.getContentPane().setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setFont(ResourceManager.getUIFont());
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(0, 5, 0, 0));
        if (OSType.isMac()) {
            this.textArea.setFont(new Font("Monospaced", 0, 11));
        }
        this.scroller = new JScrollPane(this.textArea);
        if (OSType.isMac()) {
            this.scroller.setBorder(new Border(){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    graphics.setColor(Color.gray);
                    graphics.drawLine(0, n4 - 1, n3, n4 - 1);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }

                @Override
                public Insets getBorderInsets(Component component) {
                    return new Insets(0, 0, 1, 0);
                }
            });
        }
        JViewport jViewport = this.scroller.getViewport();
        jViewport.setScrollMode(1);
        this.sbVer = this.scroller.getVerticalScrollBar();
        this.sbHor = this.scroller.getHorizontalScrollBar();
        this.getContentPane().add((Component)this.scroller, "Center");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Trace.print(ResourceManager.getString("console.dump.stack"));
                Trace.print(ResourceManager.getString("console.menu.text.top"));
                ConsoleHelper.dumpAllStacks(consoleController);
                Trace.print(ResourceManager.getString("console.menu.text.tail"));
                Trace.print(ResourceManager.getString("console.done"));
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Trace.print(ResourceManager.getString("console.dump.thread"));
                ThreadGroup threadGroup = consoleController.getMainThreadGroup();
                ConsoleHelper.dumpThreadGroup(threadGroup);
                Trace.println(ResourceManager.getString("console.done"));
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Trace.print(ResourceManager.getString("console.reload.policy"));
                consoleController.reloadSecurityPolicy();
                Trace.println(ResourceManager.getString("console.completed"));
            }
        };
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Trace.println(ResourceManager.getString("console.reload.proxy"));
                consoleController.reloadProxyConfig();
                Trace.println(ResourceManager.getString("console.done"));
            }
        };
        ActionListener actionListener5 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleHelper.displaySystemProperties();
            }
        };
        ActionListener actionListener6 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleHelper.displayHelp(consoleController, SwingConsoleWindow.this);
            }
        };
        ActionListener actionListener7 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Trace.println(consoleController.dumpClassLoaders());
            }
        };
        ActionListener actionListener8 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                consoleController.clearClassLoaders();
                Trace.println(ResourceManager.getString("console.clear.classloader"));
            }
        };
        ActionListener actionListener9 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingConsoleWindow.this.clear();
            }
        };
        ActionListener actionListener10 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = SwingConsoleWindow.this.textArea.getSelectionStart();
                int n2 = SwingConsoleWindow.this.textArea.getSelectionEnd();
                if (n2 - n <= 0) {
                    SwingConsoleWindow.this.textArea.selectAll();
                }
                SwingConsoleWindow.this.textArea.copy();
            }
        };
        ActionListener actionListener11 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingConsoleWindow.this.setVisible(false);
                SwingConsoleWindow.this.dispose();
                consoleController.notifyConsoleClosed();
            }
        };
        final ActionListener actionListener12 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                long l = Runtime.getRuntime().freeMemory() / 1024L;
                long l2 = Runtime.getRuntime().totalMemory() / 1024L;
                long l3 = (long)(100.0 / ((double)l2 / (double)l));
                Trace.print(ResourceManager.getString("console.memory", l2, l, l3));
                Trace.println(ResourceManager.getString("console.completed"));
            }
        };
        ActionListener actionListener13 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Trace.print(ResourceManager.getString("console.finalize"));
                System.runFinalization();
                Trace.println(ResourceManager.getString("console.completed"));
                actionListener12.actionPerformed(actionEvent);
            }
        };
        ActionListener actionListener14 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Trace.print(ResourceManager.getString("console.gc"));
                System.gc();
                Trace.println(ResourceManager.getString("console.completed"));
                actionListener12.actionPerformed(actionEvent);
            }
        };
        ActionListener actionListener15 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleHelper.setTraceLevel(0);
            }
        };
        ActionListener actionListener16 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleHelper.setTraceLevel(1);
            }
        };
        ActionListener actionListener17 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleHelper.setTraceLevel(2);
            }
        };
        ActionListener actionListener18 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleHelper.setTraceLevel(3);
            }
        };
        ActionListener actionListener19 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleHelper.setTraceLevel(4);
            }
        };
        ActionListener actionListener20 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleHelper.setTraceLevel(5);
            }
        };
        ActionListener actionListener21 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Trace.println(ResourceManager.getString("console.log") + consoleController.toggleLogging() + ResourceManager.getString("console.completed"));
            }
        };
        if (consoleController.isDumpStackSupported()) {
            this.textArea.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(86, 0), 2);
        }
        if (consoleController.isProxyConfigReloadSupported()) {
            this.textArea.registerKeyboardAction(actionListener4, KeyStroke.getKeyStroke(80, 0), 2);
        }
        if (consoleController.isSecurityPolicyReloadSupported()) {
            this.textArea.registerKeyboardAction(actionListener3, KeyStroke.getKeyStroke(82, 0), 2);
        }
        if (consoleController.isClearClassLoaderSupported()) {
            this.textArea.registerKeyboardAction(actionListener8, KeyStroke.getKeyStroke(88, 0), 2);
        }
        if (consoleController.isDumpClassLoaderSupported()) {
            this.textArea.registerKeyboardAction(actionListener7, KeyStroke.getKeyStroke(76, 0), 2);
        }
        if (consoleController.isLoggingSupported()) {
            this.textArea.registerKeyboardAction(actionListener21, KeyStroke.getKeyStroke(79, 0), 2);
        }
        this.textArea.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(84, 0), 2);
        this.textArea.registerKeyboardAction(actionListener5, KeyStroke.getKeyStroke(83, 0), 2);
        this.textArea.registerKeyboardAction(actionListener6, KeyStroke.getKeyStroke(72, 0), 2);
        this.textArea.registerKeyboardAction(actionListener12, KeyStroke.getKeyStroke(77, 0), 2);
        this.textArea.registerKeyboardAction(actionListener9, KeyStroke.getKeyStroke(67, 0), 2);
        this.textArea.registerKeyboardAction(actionListener14, KeyStroke.getKeyStroke(71, 0), 2);
        this.textArea.registerKeyboardAction(actionListener13, KeyStroke.getKeyStroke(70, 0), 2);
        this.textArea.registerKeyboardAction(actionListener11, KeyStroke.getKeyStroke(81, 0), 2);
        this.textArea.registerKeyboardAction(actionListener15, KeyStroke.getKeyStroke(48, 0), 2);
        this.textArea.registerKeyboardAction(actionListener16, KeyStroke.getKeyStroke(49, 0), 2);
        this.textArea.registerKeyboardAction(actionListener17, KeyStroke.getKeyStroke(50, 0), 2);
        this.textArea.registerKeyboardAction(actionListener18, KeyStroke.getKeyStroke(51, 0), 2);
        this.textArea.registerKeyboardAction(actionListener19, KeyStroke.getKeyStroke(52, 0), 2);
        this.textArea.registerKeyboardAction(actionListener20, KeyStroke.getKeyStroke(53, 0), 2);
        JButton jButton = new JButton(ResourceManager.getString("console.clear"));
        jButton.setMnemonic(ResourceManager.getMnemonic("console.clear"));
        JButton jButton2 = new JButton(ResourceManager.getString("console.copy"));
        jButton2.setMnemonic(ResourceManager.getMnemonic("console.copy"));
        JButton jButton3 = new JButton(ResourceManager.getString("console.close"));
        jButton3.setMnemonic(ResourceManager.getMnemonic("console.close"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(new JLabel("    "));
        jPanel.add(jButton2);
        jPanel.add(new JLabel("    "));
        jPanel.add(jButton3);
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SwingConsoleWindow.this.setVisible(false);
                SwingConsoleWindow.this.dispose();
                consoleController.notifyConsoleClosed();
            }
        });
        jButton.addActionListener(actionListener9);
        jButton2.addActionListener(actionListener10);
        jButton3.addActionListener(actionListener11);
    }

    @Override
    public void clear() {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlainDocument plainDocument = new PlainDocument();
                SwingConsoleWindow.this.textArea.setDocument(plainDocument);
                SwingConsoleWindow.this.textArea.revalidate();
                SwingConsoleWindow.this.setScrollPosition();
                ConsoleHelper.displayVersion(SwingConsoleWindow.this.controller, SwingConsoleWindow.this);
                SwingConsoleWindow.this.append("\n");
                ConsoleHelper.displayHelp(SwingConsoleWindow.this.controller, SwingConsoleWindow.this);
            }
        });
    }

    private void invokeLater(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        try {
            DeploySysRun.execute(new DeploySysAction(){

                @Override
                public Object execute() {
                    SwingUtilities.invokeLater(runnable);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    private static void invokeAndWait(final Runnable runnable) {
        if (runnable == null) {
            return;
        }
        try {
            DeploySysRun.execute(new DeploySysAction(){

                @Override
                public Object execute() {
                    try {
                        if (!EventQueue.isDispatchThread()) {
                            SwingUtilities.invokeAndWait(runnable);
                        } else {
                            runnable.run();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    @Override
    public void append(final String string) {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (string.length() > 1048575) {
                        SwingConsoleWindow.this.textArea.setText(string.substring(string.length() - 1048575));
                    } else {
                        int n = SwingConsoleWindow.this.textArea.getText().length() + string.length() - 1048575;
                        if (n > 0) {
                            SwingConsoleWindow.this.textArea.replaceRange("", 0, n);
                        }
                        SwingConsoleWindow.this.textArea.append(string);
                    }
                    SwingConsoleWindow.this.textArea.revalidate();
                    SwingConsoleWindow.this.setScrollPosition();
                }
                catch (Exception exception) {
                    SwingConsoleWindow.this.clear();
                    Trace.println(ResourceManager.getString("console.trace.error"));
                }
            }
        });
    }

    private void setScrollPosition() {
        this.scroller.validate();
        this.sbVer.setValue(this.sbVer.getMaximum());
        this.sbHor.setValue(this.sbHor.getMinimum());
    }

    @Override
    public void setVisible(final boolean bl) {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingConsoleWindow.this.setVisibleImpl(bl);
            }
        });
    }

    private void setVisibleImpl(boolean bl) {
        if (this.isVisible() != bl) {
            super.setVisible(bl);
        }
        if (bl) {
            this.toFront();
        } else {
            this.dispose();
        }
    }

    @Override
    public void setTitle(final String string) {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingConsoleWindow.this.setTitleImpl(string);
            }
        });
    }

    private void setTitleImpl(String string) {
        super.setTitle(string);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public String getRecentLog() {
        final String[] stringArray = new String[]{"empty"};
        Trace.flush();
        SwingConsoleWindow.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Document document = SwingConsoleWindow.this.textArea.getDocument();
                try {
                    stringArray[0] = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return stringArray[0];
    }
}

