/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.GeneralUtil;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.ParameterUtil;
import com.sun.javaws.ExtensionInstallHandler;
import com.sun.javaws.Globals;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class JnlpxArgs {
    public static final String ARG_JVM = "jnlpx.jvm";
    public static final String ARG_REMOVE = "jnlpx.remove";
    public static final String ARG_OFFLINE = "jnlpx.offline";
    public static final String ARG_HEAPSIZE = "jnlpx.heapsize";
    public static final String ARG_VMARGS = "jnlpx.vmargs";
    public static final String ARG_HOME = "jnlpx.home";
    public static final String ARG_RELAUNCH = "jnlpx.relaunch";
    public static final String ARG_SESSION_DATA = "jnlpx.session.data";
    public static final String ARG_ORIGFILE_NAME = "jnlpx.origFilenameArg";
    public static final String ARG_DOCK_NAME = "macosx.jnlpx.dock.name";
    public static final String ARG_DOCK_ICON = "macosx.jnlpx.dock.icon";
    private static File _currentJVMCommand = null;
    private static final String JAVAWS_JAR = "javaws.jar";
    private static final String DEPLOY_JAR = "deploy.jar";
    private static final String PLUGIN_JAR = "plugin.jar";
    private static final String PLUGIN_LEGACY_JAR = "plugin-legacy.jar";
    private static final List<String> fileReadWriteList = new ArrayList<String>();
    private static boolean updateJNLPXVMARGS = true;
    private static boolean _verbose = false;

    public static synchronized String getVMArgs() {
        if (updateJNLPXVMARGS) {
            List jnlpx_vmargs;
            String jnlpx_vmargs_encoded;
            JREInfo homeJre = JREInfo.getHomeJRE();
            if (Config.useSecureLaunch((JREInfo)homeJre) && (jnlpx_vmargs_encoded = System.getProperty(ARG_VMARGS)) != null && (jnlpx_vmargs = ArgumentParsingUtil.decodeArgumentList((String)jnlpx_vmargs_encoded)) != null) {
                String jcp_args = homeJre.getVmArgs();
                List jcp_args_list = ArgumentParsingUtil.parseCommandLine((String)jcp_args);
                jnlpx_vmargs = ParameterUtil.mergeArgs((List)jnlpx_vmargs, (List)jcp_args_list, (int)1);
                jnlpx_vmargs_encoded = ArgumentParsingUtil.encodeArgumentList((List)jnlpx_vmargs);
                System.setProperty(ARG_VMARGS, jnlpx_vmargs_encoded);
                updateJNLPXVMARGS = false;
                return jnlpx_vmargs_encoded;
            }
            updateJNLPXVMARGS = false;
        }
        return System.getProperty(ARG_VMARGS);
    }

    public static boolean getIsRelaunch() {
        return JnlpxArgs.getBooleanProperty(ARG_RELAUNCH);
    }

    public static File getJVMCommand() {
        if (_currentJVMCommand == null) {
            String prop = System.getProperty(ARG_JVM, "").trim();
            if (prop.startsWith("X")) {
                prop = JREInfo.getDefaultJavaPath();
            }
            if (prop.startsWith("\"")) {
                prop = prop.substring(1);
            }
            if (prop.endsWith("\"")) {
                prop = prop.substring(0, prop.length() - 1);
            }
            _currentJVMCommand = new File(prop);
        }
        return _currentJVMCommand;
    }

    public static boolean shouldRemoveArgumentFile() {
        return JnlpxArgs.getBooleanProperty(ARG_REMOVE);
    }

    public static void setShouldRemoveArgumentFile(String value) {
        System.setProperty(ARG_REMOVE, value);
    }

    public static boolean isOffline() {
        return JnlpxArgs.getBooleanProperty(ARG_OFFLINE);
    }

    public static void SetIsOffline() {
        System.setProperty(ARG_OFFLINE, "true");
    }

    public static String getHeapSize() {
        return System.getProperty(ARG_HEAPSIZE);
    }

    public static void setVerbose(boolean verbose) {
        _verbose = verbose;
    }

    public static long getInitialHeapSize() {
        String s = JnlpxArgs.getHeapSize();
        if (s == null) {
            return -1L;
        }
        String val = s.substring(s.lastIndexOf(61) + 1);
        String initialHeap = val.substring(0, val.lastIndexOf(44));
        return GeneralUtil.heapValToLong((String)initialHeap);
    }

    public static long getMaxHeapSize() {
        String s = JnlpxArgs.getHeapSize();
        if (s == null) {
            return -1L;
        }
        String val = s.substring(s.lastIndexOf(61) + 1);
        String maxHeap = val.substring(val.lastIndexOf(44) + 1, val.length());
        return GeneralUtil.heapValToLong((String)maxHeap);
    }

    private static boolean heapSizesValid(long minHeap, long maxHeap) {
        return minHeap != -1L || maxHeap != -1L;
    }

    static List<String> getArgumentList(JREInfo jreInfo, String jvmCommandStd, long reqMinHeap, long reqMaxHeap, JVMParameters jvmParams, List<String> defaultVMArgs, boolean secure, boolean useJfxTk, boolean useJfx, File targetHome) {
        String encVMArgs;
        Object heapSizeArg = "-Djnlpx.heapsize=NULL,NULL";
        if (JnlpxArgs.heapSizesValid(reqMinHeap, reqMaxHeap)) {
            heapSizeArg = "-Djnlpx.heapsize=" + reqMinHeap + "," + reqMaxHeap;
        }
        if ((encVMArgs = JnlpxArgs.getVMArgs()) != null && !encVMArgs.isEmpty()) {
            jvmParams = jvmParams.copy();
            jvmParams.addEncodedArguments(encVMArgs, true, true, false);
        }
        String dockIcon = System.getProperty(ARG_DOCK_ICON);
        String dockName = System.getProperty(ARG_DOCK_NAME);
        String sessionDataPath = System.getProperty(ARG_SESSION_DATA);
        System.setProperty(ARG_SESSION_DATA, "");
        Object bootclasspathArg = "";
        if (!jreInfo.isModularJRE()) {
            String forcedBootClassPath = Environment.getForcedBootClassPath();
            bootclasspathArg = forcedBootClassPath == null ? "-Xbootclasspath/a:" + targetHome + File.separator + "lib" + File.separator + JAVAWS_JAR + File.pathSeparator + targetHome + File.separator + "lib" + File.separator + DEPLOY_JAR + File.pathSeparator + targetHome + File.separator + "lib" + File.separator + PLUGIN_JAR + File.pathSeparator + targetHome + File.separator + "lib" + File.separator + PLUGIN_LEGACY_JAR : "-Xbootclasspath/p:" + forcedBootClassPath;
        }
        String fxversion = useJfx ? "-Djnlp.fx=2.2+" : "";
        String uitoolkit = useJfxTk ? "-Djnlp.tk=jfx" : "";
        String origFilename = System.getProperty(ARG_ORIGFILE_NAME);
        String addModsArg = "";
        if (jreInfo.isModularJRE() && !Config.useSecureLaunch((JREInfo)jreInfo)) {
            addModsArg = "--add-modules=ALL-DEFAULT,javafx.deploy";
        }
        String[] args = new String[]{bootclasspathArg, fxversion, uitoolkit, "-cp", targetHome + File.separator + "lib" + File.separator + DEPLOY_JAR, null, dockIcon != null ? "-Xdock:icon=" + dockIcon : "", dockName != null ? "-Xdock:name=" + dockName : "", "-Djnlpx.jvm=" + jvmCommandStd, "-Djnlpx.home=" + targetHome, "-Djnlpx.remove=" + (JnlpxArgs.shouldRemoveArgumentFile() ? "true" : "false"), "-Djnlpx.offline=" + (JnlpxArgs.isOffline() ? "true" : "false"), "-Djnlpx.relaunch=true", "-Djnlpx.session.data=" + (sessionDataPath != null ? sessionDataPath : ""), heapSizeArg, "-Djava.security.policy=" + JnlpxArgs.getPolicyURLString(targetHome), "-DtrustProxy=true", "-Xverify:remote", origFilename == null ? "" : "-Djnlpx.origFilenameArg=" + origFilename, JnlpxArgs.useJCOV(), jreInfo.isModularJRE() ? "" : JnlpxArgs.useBootClassPath(), JnlpxArgs.useJpiProfile(), JnlpxArgs.useDebugMode(), JnlpxArgs.useDebugVMMode(), useJfxTk ? "" : "-Dsun.awt.warmup=true", "-Djava.security.manager", !addModsArg.isEmpty() ? addModsArg : "", jreInfo.isModularJRE() ? "-m" : "", jreInfo.isModularJRE() ? "jdk.plugin/sun.plugin2.main.WebStart" : "sun.plugin2.main.WebStart", secure ? "-secure" : "", _verbose ? "-verbose" : "", JnlpxArgs.setTCKHarnessOption(), Environment.isWebJava() ? "" : "-notWebJava", JnlpxArgs.useLogToHost()};
        List returnArgs = jvmParams.getCommandLineArguments(null, false, false, true, secure, false);
        if (!Config.useSecureLaunch((JREInfo)jreInfo)) {
            returnArgs = ParameterUtil.mergeArgs((List)returnArgs, defaultVMArgs, (int)1);
        }
        String vmArgs = ArgumentParsingUtil.encodeArgumentList((List)returnArgs);
        String vmArgsPropertyStr = "-Djnlpx.vmargs=" + vmArgs;
        boolean skip = false;
        boolean hasCPArg = returnArgs.contains("-cp") || returnArgs.contains("-classpath");
        for (String arg : args) {
            if (skip) {
                skip = false;
                continue;
            }
            if (arg == null) {
                if (vmArgsPropertyStr == null) continue;
                returnArgs.add(vmArgsPropertyStr);
                vmArgsPropertyStr = null;
                continue;
            }
            if (arg.length() <= 0) continue;
            if (hasCPArg && arg.equals("-cp")) {
                skip = true;
                continue;
            }
            returnArgs.add(arg);
        }
        return returnArgs;
    }

    static String getPolicyURLString(File targetHome) {
        String path = targetHome + File.separator + "conf" + File.separator + "security" + File.separator + "javaws.policy";
        Object path1 = path;
        try {
            URL url = new URL("file", "", path);
            path1 = url.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path1;
    }

    public static String useLogToHost() {
        if (Globals.LogToHost != null) {
            return "-XX:LogToHost=" + Globals.LogToHost;
        }
        return "";
    }

    public static String setTCKHarnessOption() {
        if (Globals.TCKHarnessRun) {
            return "-XX:TCKHarnessRun=true";
        }
        return "";
    }

    public static String useBootClassPath() {
        if (Globals.BootClassPath.equals("NONE")) {
            return "";
        }
        return "-Xbootclasspath" + Globals.BootClassPath;
    }

    public static String useJpiProfile() {
        String profileString = System.getProperty("javaplugin.user.profile");
        if (profileString != null) {
            return "-Djavaplugin.user.profile=" + profileString;
        }
        return "";
    }

    public static String useJCOV() {
        if (Globals.JCOV.equals("NONE")) {
            return "";
        }
        return "-Xrunjcov:file=" + Globals.JCOV;
    }

    public static String useDebugMode() {
        if (Config.isDebugMode()) {
            return "-Ddeploy.debugMode=true";
        }
        return "";
    }

    public static String useDebugVMMode() {
        if (Config.isDebugVMMode()) {
            return "-Ddeploy.useDebugJavaVM=true";
        }
        return "";
    }

    public static void removeArgumentFile(String arg) {
        if (JnlpxArgs.shouldRemoveArgumentFile() && arg != null) {
            new File(arg).delete();
        }
    }

    public static void verify() {
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)"Java part started", (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.jvm: " + JnlpxArgs.getJVMCommand()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.remove: " + JnlpxArgs.shouldRemoveArgumentFile()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("jnlpx.heapsize: " + JnlpxArgs.getHeapSize()), (TraceLevel)TraceLevel.BASIC);
        }
    }

    private static boolean getBooleanProperty(String key) {
        String s = System.getProperty(key, "false");
        return s != null && s.equals("true");
    }

    public static List<String> getFileReadWriteList() {
        return fileReadWriteList;
    }

    protected static Process execProgram(JREInfo jreInfo, String[] args, long minHeap, long maxHeap, JVMParameters jvmParams, boolean secure) throws IOException {
        return JnlpxArgs.execProgram(jreInfo, args, minHeap, maxHeap, jvmParams, secure, false, false);
    }

    public static Process execProgram(JREInfo jreInfo, String[] args, long minHeap, long maxHeap, JVMParameters jvmParams, boolean secure, boolean useJfxTk, boolean useJfx) throws IOException {
        File targetHome = jreInfo.isArchMatch() ? Environment.getDeploymentHome() : JREInfo.getCompatibleHomeJRE().getDeploymentHome();
        String stdjavacmd = jreInfo.getPath();
        String javacmd = Config.isDebugMode() && Config.isDebugVMMode() ? jreInfo.getDebugJavaPath() : jreInfo.getPath();
        if (javacmd == null || stdjavacmd == null || javacmd.length() == 0 || stdjavacmd.length() == 0 || targetHome == null) {
            throw new IllegalArgumentException("must exist");
        }
        String vmargs = jreInfo.getVmArgs();
        List defaultJVMArgs = ArgumentParsingUtil.parseCommandLine((String)vmargs);
        List<String> jnlpxs = JnlpxArgs.getArgumentList(jreInfo, stdjavacmd, minHeap, maxHeap, jvmParams, defaultJVMArgs, secure, useJfxTk, useJfx, targetHome);
        List<String> cmds = new ArrayList<String>();
        if (Config.useSecureLaunch((JREInfo)jreInfo)) {
            String launcher = Platform.get().findSecureLauncher(targetHome);
            cmds.add(launcher);
        } else {
            cmds.add(javacmd);
        }
        cmds.addAll(jnlpxs);
        cmds.addAll(Arrays.asList(args));
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)("Launching new JRE version: " + jreInfo), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("\t jvmParams: " + jvmParams), (TraceLevel)TraceLevel.BASIC);
            for (int i = 0; i < cmds.size(); ++i) {
                Trace.println((String)("cmd " + i + " : " + cmds.get(i)), (TraceLevel)TraceLevel.BASIC);
            }
        }
        if (Globals.TCKHarnessRun) {
            Main.tckprintln("JVM Starting");
        }
        Trace.flush();
        if (Config.useSecureLaunch((JREInfo)jreInfo)) {
            cmds = ArgumentParsingUtil.getSecureLaunchArgs((JREInfo)jreInfo, cmds, (JVMParameters)(secure ? jvmParams : null), (boolean)true, (boolean)true);
            for (int i = 0; i < cmds.size(); ++i) {
                Trace.println((String)("secure cmds " + i + " : " + cmds.get(i)), (TraceLevel)TraceLevel.BASIC);
            }
        }
        ProcessBuilder pb = new ProcessBuilder(cmds);
        return Platform.get().startProcessBuilder(pb);
    }

    public static void executeInstallers(ArrayList<File> files, Preloader progress) throws ExitException {
        if (progress.getOwner() != null) {
            try {
                progress.handleEvent((PreloaderEvent)new InitEvent(2));
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
        for (File jnlpFile : files) {
            try {
                LaunchDesc ld = LaunchDescFactory.buildDescriptor(jnlpFile, null, null, null);
                LocalApplicationProperties lap = Cache.getLocalApplicationProperties((String)jnlpFile.getPath());
                lap.setExtensionInstalled(false);
                lap.store();
                Trace.println((String)("Installing extension: " + jnlpFile), (TraceLevel)TraceLevel.EXTENSIONS);
                String[] args = new String[]{"-installer", jnlpFile.getAbsolutePath()};
                JREInfo jreInfo = ld.selectJRE(false);
                if (jreInfo == null) {
                    progress.handleEvent((PreloaderEvent)new ConfigEvent(6));
                    LaunchDescException lde = new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException(lde, 3);
                }
                boolean removeArgumentFile = JnlpxArgs.shouldRemoveArgumentFile();
                JnlpxArgs.setShouldRemoveArgumentFile("false");
                JREMatcher jreMatcher = ld.getJREMatcher();
                JVMParameters jvmParams = jreMatcher.getSelectedJVMParameters();
                JREDesc jreDesc = jreMatcher.getSelectedJREDesc();
                long minHeap = jreDesc.getMinHeap();
                long maxHeap = jreDesc.getMaxHeap();
                Process p = JnlpxArgs.execProgram(jreInfo, args, minHeap, maxHeap, jvmParams, false);
                progress.handleEvent((PreloaderEvent)new ConfigEvent(6));
                EatInput.eatInput(p.getErrorStream());
                EatInput.eatInput(p.getInputStream());
                p.waitFor();
                JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(removeArgumentFile));
                lap.refresh();
                if (lap.isRebootNeeded()) {
                    boolean doboot = false;
                    ExtensionInstallHandler eih = ExtensionInstallHandler.getInstance();
                    if (eih != null && eih.doPreRebootActions((Component)progress.getOwner())) {
                        doboot = true;
                    }
                    lap.setExtensionInstalled(true);
                    lap.setRebootNeeded(false);
                    lap.store();
                    if (doboot && eih != null && eih.doReboot()) {
                        throw new ExitException(null, 1);
                    }
                } else {
                    lap.setExtensionInstalled(true);
                    lap.store();
                }
                if (lap.isExtensionInstalled()) continue;
                progress.handleEvent((PreloaderEvent)new ConfigEvent(6));
                throw new ExitException(new LaunchDescException(ld, ResourceManager.getString((String)"Launch.error.installfailed"), null), 3);
            }
            catch (JNLPException je) {
                try {
                    progress.handleEvent((PreloaderEvent)new ConfigEvent(6));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                throw new ExitException(je, 3);
            }
            catch (IOException io) {
                try {
                    progress.handleEvent((PreloaderEvent)new ConfigEvent(6));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                throw new ExitException(io, 3);
            }
            catch (InterruptedException iro) {
                try {
                    progress.handleEvent((PreloaderEvent)new ConfigEvent(6));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                throw new ExitException(iro, 3);
            }
        }
    }

    public static void executeUninstallers(ArrayList<File> files) throws ExitException {
        for (File jnlpFile : files) {
            try {
                LaunchDesc ld = LaunchDescFactory.buildDescriptor(jnlpFile, null, null, null);
                LocalApplicationProperties lap = Cache.getLocalApplicationProperties((String)jnlpFile.getPath());
                Trace.println((String)("uninstalling extension: " + jnlpFile), (TraceLevel)TraceLevel.EXTENSIONS);
                if (!ld.isInstaller()) {
                    throw new ExitException(null, 3);
                }
                String[] args = new String[]{"-silent", "-installer", jnlpFile.getAbsolutePath()};
                JREInfo jreInfo = ld.selectJRE(false);
                if (jreInfo == null) {
                    LaunchDescException lde = new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
                    throw new ExitException(lde, 3);
                }
                JREMatcher jreMatcher = ld.getJREMatcher();
                JVMParameters jvmParams = jreMatcher.getSelectedJVMParameters();
                JREDesc jreDesc = jreMatcher.getSelectedJREDesc();
                long minHeap = jreDesc.getMinHeap();
                long maxHeap = jreDesc.getMaxHeap();
                Process p = JnlpxArgs.execProgram(jreInfo, args, minHeap, maxHeap, jvmParams, false);
                EatInput.eatInput(p.getErrorStream());
                EatInput.eatInput(p.getInputStream());
                boolean complete = p.waitFor(60L, TimeUnit.SECONDS);
                if (!complete) {
                    Trace.println((String)("uninstaller for " + ld + " did not complete within 60 seconds."), (TraceLevel)TraceLevel.BASIC);
                }
                lap.refresh();
                if (lap.isRebootNeeded()) {
                    boolean doboot = false;
                    ExtensionInstallHandler eih = ExtensionInstallHandler.getInstance();
                    if (eih != null && eih.doPreRebootActions(null)) {
                        doboot = true;
                    }
                    lap.setRebootNeeded(false);
                    lap.setExtensionInstalled(false);
                    lap.store();
                    if (!doboot || eih == null || !eih.doReboot()) continue;
                    throw new ExitException(null, 1);
                }
                lap.setExtensionInstalled(false);
                lap.store();
            }
            catch (JNLPException je) {
                throw new ExitException(je, 3);
            }
            catch (IOException io) {
                throw new ExitException(io, 3);
            }
            catch (InterruptedException iro) {
                throw new ExitException(iro, 3);
            }
        }
    }

    private static String sizeString(long size) {
        if (size > 0x100000L) {
            return size / 0x100000L + "Mb";
        }
        return size + "bytes";
    }

    private static class EatInput
    implements Runnable {
        private final InputStream _is;

        EatInput(InputStream is) {
            this._is = is;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            try {
                int n = 0;
                while (n != -1) {
                    n = this._is.read(buffer);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void eatInput(InputStream is) {
            EatInput eater = new EatInput(is);
            new Thread(eater).start();
        }
    }
}

