/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.DownloadErrorEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.MultipleHostsException;
import com.sun.javaws.exceptions.NativeLibViolationException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LDUpdater;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.javaws.security.JNLPSignedResourcesHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class LaunchDownload {
    private final LaunchDesc ld;
    public static final String APPCONTEXT_THREADPOOL_KEY = "deploy-launchdownloadthreadpoolinappcontext";

    public LaunchDownload(LaunchDesc ld) {
        this.ld = ld;
    }

    public static LaunchDesc updateLaunchDescInCache(LaunchDesc ld) {
        return LaunchDownload.updateLaunchDescInCache(ld, ld.getCodebase(), ld.getDocumentBase());
    }

    public static LaunchDesc updateLaunchDescInCache(LaunchDesc ld, URL codebase, URL docbase) {
        if (!Cache.isCacheEnabled()) {
            return ld;
        }
        boolean noHref = ld.getLocation() == null;
        URL ref = noHref ? ld.getCanonicalHome() : ld.getLocation();
        try {
            LaunchDesc cachedLD;
            File cachedJNLP;
            Resource r;
            URL original = ld.getSourceURL();
            if (original != null && ref != null && !original.toString().equals(ref.toString()) && (r = ResourceProvider.get().getCachedResource(original, null)) != null) {
                ResourceProvider.get().markRetired(r, false);
            }
            if ((cachedJNLP = ResourceProvider.get().getCachedJNLPFile(ref, null)) != null && ld.hasIdenticalContent(cachedLD = LaunchDescFactory.buildDescriptor(cachedJNLP, codebase, docbase, null))) {
                return cachedLD;
            }
            Cache.createOrUpdateCacheEntry((URL)ref, (byte[])ld.getSource().getBytes());
        }
        catch (IOException ioe) {
            Trace.ignoredException((Exception)ioe);
        }
        catch (BadFieldException bfe) {
            Trace.ignoredException((Exception)bfe);
        }
        catch (MissingFieldException mfe) {
            Trace.ignoredException((Exception)mfe);
        }
        catch (JNLParseException ex) {
            Trace.ignoredException((Exception)ex);
        }
        return ld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LaunchDesc getUpdatedLaunchDesc(URL origLocation, URL thisCodebase, boolean forced) throws JNLPException, IOException {
        boolean update;
        ResourceProvider provider;
        block16: {
            provider = ResourceProvider.get();
            if (origLocation == null) {
                return null;
            }
            Resource r0 = provider.getCachedResource(origLocation, null);
            if (r0 != null) {
                try {
                    if (forced) {
                        update = provider.checkUpdateAvailable(origLocation, r0, 1, null);
                        break block16;
                    }
                    update = provider.isUpdateAvailable(origLocation, null);
                }
                catch (IOException ioe) {
                    Trace.ignored((Throwable)ioe);
                    update = false;
                }
            } else {
                update = true;
            }
        }
        if (!update) {
            Trace.println((String)("Update JNLP: no update for: " + origLocation), (TraceLevel)TraceLevel.BASIC);
            return null;
        }
        Trace.println((String)("Update JNLP: " + origLocation + ", thisCodebase: " + thisCodebase), (TraceLevel)TraceLevel.BASIC);
        File cachedFile = null;
        int level = ResourceProvider.get().incrementInternalUse();
        try {
            Resource r = provider.downloadUpdate(origLocation, null);
            cachedFile = r.getDataFile();
        }
        catch (FileNotFoundException fnfe) {
            Trace.ignoredException((Exception)fnfe);
        }
        finally {
            ResourceProvider.get().decrementInternalUse(level);
        }
        if (cachedFile != null) {
            LaunchDesc ld = null;
            try {
                ld = LaunchDescFactory.buildDescriptor(cachedFile, thisCodebase, origLocation, origLocation);
                return ld;
            }
            catch (LaunchDescException lde) {
                ld = LaunchDescFactory.buildDescriptor(cachedFile);
                if (ld == null) {
                    throw lde;
                }
                return ld;
            }
        }
        return LaunchDescFactory.buildDescriptor(origLocation, origLocation);
    }

    public static boolean isJnlpCached(LaunchDesc ld) {
        try {
            return ResourceProvider.get().isCached(ld.getCanonicalHome(), null);
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
            return false;
        }
    }

    public boolean isInCache() {
        return this.isInCache(false);
    }

    public boolean isInCache(boolean skipExtension) {
        ResourcesDesc rd = this.ld.getResources();
        if (rd == null) {
            return true;
        }
        try {
            JARDesc[] jars;
            boolean success;
            if (this.ld.getLocation() != null && !ResourceProvider.get().isCached(this.ld.getLocation(), null)) {
                return false;
            }
            if (!skipExtension && !(success = this.getCachedExtensions())) {
                return false;
            }
            boolean includingLazy = Environment.isImportMode();
            for (JARDesc jar : jars = rd.getEagerOrAllJarDescs(includingLazy)) {
                Resource r = ResourceProvider.get().getCachedResource(jar.getLocation(), jar.getVersion());
                if (r == null) {
                    return false;
                }
                if (!this.checkJarFileCorrupted(r)) continue;
                return false;
            }
        }
        catch (JNLPException e) {
            Trace.ignoredException((Exception)e);
            return false;
        }
        catch (IOException ioe) {
            Trace.ignoredException((Exception)ioe);
            return false;
        }
        return true;
    }

    private static boolean isUpdateAvailable(LaunchDesc launchDesc) throws JNLPException {
        try {
            return new LDUpdater(launchDesc).isUpdateAvailable();
        }
        catch (Exception e) {
            if (e instanceof JNLPException) {
                throw (JNLPException)e;
            }
            if (e.getCause() instanceof JNLPException) {
                throw (JNLPException)e.getCause();
            }
            throw new FailedDownloadingResourceException(launchDesc.getLocation(), null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkJarFileCorrupted(Resource jar) {
        if (jar == null || jar.getDataFile() == null) {
            return true;
        }
        JarFile jf = null;
        try {
            jf = JarUtil.createJarFile((File)jar.getDataFile(), (boolean)true);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
            ResourceProvider.get().markRetired(jar, false);
            boolean bl = true;
            return bl;
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void downloadExtensions(Preloader dp, int remaining, ArrayList<File> installFiles) throws IOException, JNLPException {
        this.downloadExtensionsHelper(dp, remaining, false, installFiles);
    }

    public boolean getCachedExtensions() throws IOException, JNLPException {
        return this.downloadExtensionsHelper(null, 0, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadExtensionsHelper(Preloader dp, int remaining, boolean cacheOnly, ArrayList<File> installFiles) throws IOException, JNLPException {
        int current = ResourceProvider.get().incrementInternalUse();
        try {
            boolean bl = this._downloadExtensionsHelper(dp, remaining, cacheOnly, installFiles);
            return bl;
        }
        finally {
            ResourceProvider.get().decrementInternalUse(current);
        }
    }

    private boolean _downloadExtensionsHelper(Preloader dp, int remaining, boolean cacheOnly, ArrayList<File> installFiles) throws IOException, JNLPException {
        ResourcesDesc rd = this.ld.getResources();
        if (rd == null) {
            return true;
        }
        String knownPlatforms = JREInfo.getKnownPlatforms();
        final ArrayList list = new ArrayList();
        rd.visit(new ResourceVisitor(){

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                list.add(ed);
            }
        });
        remaining += list.size();
        for (ExtensionDesc ed : list) {
            int idx;
            String name = ed.getName();
            if (name == null && (idx = (name = ed.getLocation().toString()).lastIndexOf(47)) > 0) {
                name = name.substring(idx + 1, name.length());
            }
            --remaining;
            if (dp != null) {
                dp.handleEvent((PreloaderEvent)new DownloadEvent(0, ed.getLocation(), ed.getVersion(), name, (long)remaining, (long)list.size(), list.size()));
            }
            Resource r = ResourceProvider.get().getJreResource(ed.getLocation(), ed.getVersion(), !cacheOnly, false, JREInfo.getKnownPlatforms());
            File cachedFile = r != null ? r.getDataFile() : null;
            Trace.println((String)("Downloaded extension: " + ed.getLocation() + "\n\tcodebase: " + ed.getCodebase() + "\n\tld parentCodebase: " + this.ld.getCodebase() + "\n\tfile: " + cachedFile), (TraceLevel)TraceLevel.NETWORK);
            if (cachedFile == null) {
                return false;
            }
            LaunchDesc extensionLd = LaunchDescFactory.buildDescriptor(cachedFile, ed.getCodebase(), ed.getLocation(), ed.getLocation());
            boolean downloadExtension = false;
            if (extensionLd.getLaunchType() == 3) {
                downloadExtension = true;
            } else if (extensionLd.getLaunchType() == 4) {
                LocalApplicationProperties lap = Cache.getLocalApplicationProperties((URL)ed.getLocation(), (String)ed.getVersion(), (boolean)false);
                boolean bl = downloadExtension = !lap.isExtensionInstalled();
                if (installFiles != null && (LaunchDownload.isUpdateAvailable(extensionLd) || downloadExtension)) {
                    installFiles.add(cachedFile);
                }
                if (cacheOnly && downloadExtension) {
                    return false;
                }
            } else {
                throw new MissingFieldException(extensionLd.getSource(), "<component-desc>|<installer-desc>");
            }
            if (!downloadExtension) continue;
            ed.setExtensionDesc(extensionLd);
            LaunchDownload download = new LaunchDownload(extensionLd);
            boolean res = download.downloadExtensionsHelper(dp, remaining, cacheOnly, installFiles);
            if (res) continue;
            return false;
        }
        return true;
    }

    public static void downloadResource(LaunchDesc ld, URL location, String version, Preloader dp, boolean isCacheOk) throws IOException, JNLPException {
        ResourcesDesc resources = ld.getResources();
        if (resources == null) {
            return;
        }
        int downloads = resources.getConcurrentDownloads();
        JARDesc[] jardescs = resources.getResource(location, version);
        LaunchDownload.downloadJarFiles(jardescs, dp, isCacheOk, downloads);
    }

    public static void downloadParts(LaunchDesc ld, String[] parts, Preloader dp, boolean isCacheOk) throws IOException, JNLPException {
        ResourcesDesc resources = ld.getResources();
        if (resources == null) {
            return;
        }
        int downloads = resources.getConcurrentDownloads();
        JARDesc[] jardescs = resources.getPartJars(parts);
        LaunchDownload.downloadJarFiles(jardescs, dp, isCacheOk, downloads);
    }

    public static void downloadExtensionPart(LaunchDesc ld, URL location, String version, String[] parts, Preloader dp, boolean isCacheOk) throws IOException, JNLPException {
        ResourcesDesc resources = ld.getResources();
        if (resources == null) {
            return;
        }
        int downloads = resources.getConcurrentDownloads();
        JARDesc[] jardescs = resources.getExtensionPart(location, version, parts);
        LaunchDownload.downloadJarFiles(jardescs, dp, isCacheOk, downloads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadEagerorAll(boolean downloadAll, Preloader dp, boolean isCacheOk) throws IOException, JNLPException {
        JARDesc[] allJarDescs;
        ResourcesDesc resources = this.ld.getResources();
        if (resources == null) {
            return;
        }
        JARDesc[] jardescs = resources.getEagerOrAllJarDescs(downloadAll);
        ArrayList<JARDesc> cachedLazyJars = new ArrayList<JARDesc>();
        if (!downloadAll && (allJarDescs = resources.getEagerOrAllJarDescs(true)).length != jardescs.length) {
            HashSet<JARDesc> hm = new HashSet<JARDesc>(Arrays.asList(jardescs));
            boolean found = false;
            for (JARDesc allJarDesc : allJarDescs) {
                URL location = allJarDesc.getLocation();
                String version = allJarDesc.getVersion();
                if (hm.contains(allJarDesc) || !ResourceProvider.get().isCached(location, version)) continue;
                cachedLazyJars.add(allJarDesc);
            }
        }
        int n = this.ld.getResources().getConcurrentDownloads();
        LaunchDownload.downloadJarFiles(jardescs, dp, isCacheOk, n);
        for (JARDesc jd : cachedLazyJars) {
            try {
                if (!jd.getUpdater().isUpdateAvailable()) continue;
                ResourceProvider.get().markRetired(ResourceProvider.get().getCachedResource(jd.getLocation(), jd.getVersion()), true);
            }
            catch (Exception e) {
                Trace.ignored((Throwable)e);
            }
        }
        IconDesc id = this.ld.getInformation().getIconLocation(48, 0);
        if (id != null) {
            int level = ResourceProvider.get().incrementInternalUse();
            try {
                ResourceProvider.get().getResource(id.getLocation(), id.getVersion(), true, 1, null);
                Trace.println((String)("Downloaded " + id.getLocation()), (TraceLevel)TraceLevel.NETWORK);
            }
            catch (Exception e) {
                Trace.ignored((Throwable)e);
            }
            finally {
                ResourceProvider.get().decrementInternalUse(level);
            }
        }
    }

    public static void reverse(JARDesc[] b) {
        int left = 0;
        for (int right = b.length - 1; left < right; ++left, --right) {
            JARDesc temp = b[left];
            b[left] = b[right];
            b[right] = temp;
        }
    }

    public static int getDownloadType(JARDesc jar) {
        int downloadType = 256;
        if (jar.isNativeLib()) {
            downloadType |= 0x10;
        }
        if (jar.isPack200Enabled()) {
            downloadType |= 0x1000;
        }
        if (jar.isVersionEnabled()) {
            downloadType |= 0x10000;
        }
        return downloadType;
    }

    public void prepareCustomProgress(PreloaderDelegate delegate, JNLPSignedResourcesHelper signingHelper, Runnable okAction, Runnable failAction, boolean doUpdate) {
        this.prepareCustomProgress(delegate, signingHelper, okAction, failAction, doUpdate, true);
    }

    void prepareCustomProgress(final PreloaderDelegate delegate, final JNLPSignedResourcesHelper signingHelper, final Runnable okAction, final Runnable failAction, final boolean doUpdate, boolean async) {
        delegate.setPreloaderClass(this.ld.getProgressClassName());
        delegate.markLoadingStarted();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (doUpdate) {
                            LaunchDownload.this.downloadProgressJars(delegate);
                        }
                        if (okAction != null) {
                            okAction.run();
                        }
                        delegate.markLoaded(null);
                        signingHelper.warmup();
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            e = e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
                        }
                        Trace.println((String)("Error preparing preloader : " + e), (TraceLevel)TraceLevel.PRELOADER);
                        Trace.ignored((Throwable)e);
                        delegate.markLoaded(e);
                        if (failAction == null) break block5;
                        failAction.run();
                    }
                }
            }
        };
        if (async) {
            Thread t = new Thread(action, "Loading Custom Progress");
            t.setDaemon(true);
            t.start();
        } else {
            action.run();
        }
    }

    void downloadProgressJars(PreloaderDelegate cp) throws IOException, JNLPException {
        ExecutorService progressThreadPool = null;
        List<Future<Object>> progressJobs = null;
        ResourcesDesc resources = this.ld.getResources();
        if (resources == null) {
            return;
        }
        progressThreadPool = LaunchDownload.getThreadPool(2);
        if (progressThreadPool == null) {
            return;
        }
        JARDesc[] jardescs = resources.getEagerOrAllJarDescs(false);
        ArrayList<DownloadTask> downloadTasks = new ArrayList<DownloadTask>(2);
        for (JARDesc jar : jardescs) {
            DownloadTask dTask;
            if (!jar.isProgressJar() || downloadTasks.contains(dTask = new DownloadTask(jar.getLocation(), null, jar.getVersion(), null, true, LaunchDownload.getDownloadType(jar), null, null, null))) continue;
            downloadTasks.add(dTask);
        }
        if (downloadTasks.size() > 0) {
            try {
                progressJobs = progressThreadPool.invokeAll(downloadTasks);
            }
            catch (InterruptedException e) {
                Trace.ignored((Throwable)e);
                progressThreadPool.shutdownNow();
            }
            progressThreadPool.shutdown();
            LaunchDownload.validateResults(progressJobs, downloadTasks, null);
        }
    }

    private static void downloadJarFiles(JARDesc[] jars, Preloader dp, boolean isCacheOk, int concurrentDownloads) throws JNLPException, IOException {
        if (jars == null) {
            return;
        }
        if (Globals.isReverseMode()) {
            LaunchDownload.reverse(jars);
        }
        long totalSize = 0L;
        DownloadCallbackHelper dch = DownloadCallbackHelper.get(dp);
        int jarsWithKnownSizes = 0;
        boolean allJarsHaveKnownSize = true;
        for (JARDesc jar : jars) {
            int sz = jar.getSize();
            if (jar.isProgressJar()) continue;
            if (sz > 0) {
                ++jarsWithKnownSizes;
                totalSize += (long)sz;
                continue;
            }
            allJarsHaveKnownSize = false;
        }
        int nonProgressJars = 0;
        for (JARDesc jar : jars) {
            int sz = jar.getSize();
            if (jar.isProgressJar()) continue;
            if (sz <= 0) {
                dch.register(jar.getLocation().toString(), jar.getVersion(), 0, 1.0);
            } else if (sz > 0) {
                dch.register(jar.getLocation().toString(), jar.getVersion(), sz, 0.5 + (double)(sz * jarsWithKnownSizes) / (double)totalSize);
            }
            ++nonProgressJars;
        }
        if (!allJarsHaveKnownSize) {
            totalSize = -1L;
        }
        Trace.println((String)("Total size to download: " + totalSize), (TraceLevel)TraceLevel.NETWORK);
        if (totalSize == 0L) {
            return;
        }
        dch.setTotalSize(totalSize);
        dch.setNumOfJars(jars.length);
        int[] jarsDoneBox = new int[]{0};
        ExecutorService threadPool = LaunchDownload.getThreadPool(concurrentDownloads);
        if (threadPool != null) {
            ToolkitStore.get().getAppContext().put((Object)APPCONTEXT_THREADPOOL_KEY, (Object)threadPool);
            dch.setNumOfJars(nonProgressJars);
        }
        ArrayList<DownloadTask> downloadTasks = new ArrayList<DownloadTask>(jars.length);
        for (JARDesc jar : jars) {
            int level = ResourceProvider.get().incrementInternalUse();
            try {
                DownloadTask dTask;
                int downloadType = LaunchDownload.getDownloadType(jar);
                if (threadPool == null) {
                    Resource r = ResourceProvider.get().getResource(jar.getLocation(), jar.getVersion(), true, downloadType, (DownloadDelegate)dch);
                    jarsDoneBox[0] = jarsDoneBox[0] + 1;
                    dch.setJarsDone(jarsDoneBox[0]);
                    if (!Cache.isCacheEnabled() || r != null || Environment.isImportMode()) continue;
                    throw new FailedDownloadingResourceException(null, jar.getLocation(), jar.getVersion(), null);
                }
                if (jar.isProgressJar() || downloadTasks.contains(dTask = new DownloadTask(jar.getLocation(), null, jar.getVersion(), dch, true, downloadType, dp, jarsDoneBox, dch))) continue;
                downloadTasks.add(dTask);
            }
            catch (JNLPException je) {
                if (dp != null) {
                    dp.handleEvent((PreloaderEvent)new DownloadErrorEvent(jar.getLocation(), jar.getVersion()));
                }
                throw je;
            }
            finally {
                ResourceProvider.get().decrementInternalUse(level);
            }
        }
        List<Future<Object>> tasks = null;
        try {
            if (threadPool != null) {
                tasks = threadPool.invokeAll(downloadTasks);
            }
        }
        catch (Exception e) {
            Trace.ignored((Throwable)e);
        }
        if (threadPool != null) {
            ToolkitStore.get().getAppContext().remove((Object)APPCONTEXT_THREADPOOL_KEY);
            threadPool.shutdown();
            LaunchDownload.validateResults(tasks, downloadTasks, dp);
        }
    }

    private static void validateResults(List<Future<Object>> tasks, ArrayList<DownloadTask> downloadTasks, Preloader dp) throws IOException, JNLPException {
        if (tasks != null) {
            int pos = 0;
            for (Future<Object> task : tasks) {
                URL url = downloadTasks.get(pos).getURL();
                String version = downloadTasks.get(pos).getVersion();
                ++pos;
                try {
                    task.get();
                }
                catch (ExecutionException ee) {
                    Throwable t = ee.getCause();
                    if (null == t) continue;
                    if (t instanceof IOException) {
                        if (dp != null) {
                            dp.handleEvent((PreloaderEvent)new DownloadErrorEvent(url, version, t));
                        }
                        throw (IOException)t;
                    }
                    if (t instanceof JNLPException) {
                        if (dp != null) {
                            dp.handleEvent((PreloaderEvent)new DownloadErrorEvent(url, version));
                        }
                        throw (JNLPException)t;
                    }
                    throw new IOException("JNLP Jar download failure.");
                }
                catch (InterruptedException e) {
                    Trace.ignored((Throwable)e);
                }
            }
        }
    }

    private static synchronized void notifyProgress(DownloadCallbackHelper dch, int[] counterBox, URL jarurl) {
        if (counterBox != null && dch != null) {
            counterBox[0] = counterBox[0] + 1;
            Trace.println((String)("Download Progress: jarsDone: " + counterBox[0]), (TraceLevel)TraceLevel.NETWORK);
            dch.jarDone(jarurl);
            dch.setJarsDone(counterBox[0]);
        }
    }

    private static ExecutorService getThreadPool(int threads) {
        ExecutorService threadPool = Executors.newFixedThreadPool(threads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        return threadPool;
    }

    public static void checkJNLPSecurity(LaunchDesc ld) throws MultipleHostsException, NativeLibViolationException {
        boolean[] nativeLibViolation = new boolean[1];
        boolean[] hostViolation = new boolean[1];
        ResourcesDesc rd = ld.getResources();
        if (rd == null) {
            return;
        }
        JARDesc mainJar = ld.getMainJar();
        if (mainJar == null) {
            return;
        }
        LaunchDownload.checkJNLPSecurityHelper(ld, mainJar.getLocation().getHost(), hostViolation, nativeLibViolation);
        if (hostViolation[0]) {
            throw new MultipleHostsException();
        }
        if (nativeLibViolation[0]) {
            throw new NativeLibViolationException();
        }
    }

    private static void checkJNLPSecurityHelper(LaunchDesc ld, final String host, final boolean[] hostViolation, final boolean[] nativeLibViolation) {
        if (ld.getSecurityModel() != 0) {
            return;
        }
        ResourcesDesc rd = ld.getResources();
        if (rd == null) {
            return;
        }
        rd.visit(new ResourceVisitor(){

            @Override
            public void visitJARDesc(JARDesc jad) {
                String thisHost = jad.getLocation().getHost();
                hostViolation[0] = hostViolation[0] || !host.equals(thisHost);
                nativeLibViolation[0] = nativeLibViolation[0] || jad.isNativeLib();
            }

            @Override
            public void visitExtensionDesc(ExtensionDesc ed) {
                if (!hostViolation[0] && !nativeLibViolation[0]) {
                    LaunchDesc extLd = ed.getExtensionDesc();
                    String thisHost = ed.getLocation().getHost();
                    if (extLd != null && extLd.getSecurityModel() == 0 && !hostViolation[0]) {
                        LaunchDownload.checkJNLPSecurityHelper(extLd, thisHost, hostViolation, nativeLibViolation);
                    }
                }
            }
        });
    }

    public static long getCachedSize(LaunchDesc ld) {
        JARDesc[] jars;
        long size = 0L;
        ResourcesDesc rd = ld.getResources();
        if (rd == null) {
            return size;
        }
        for (JARDesc jar : jars = rd.getEagerOrAllJarDescs(true)) {
            Resource r = ResourceProvider.get().getCachedResource(jar.getLocation(), jar.getVersion());
            if (r == null) continue;
            size += r.getSize();
        }
        IconDesc[] icons = ld.getInformation().getIcons();
        if (icons != null) {
            for (IconDesc icon : icons) {
                Resource r = ResourceProvider.get().getCachedResource(icon.getLocation(), icon.getVersion());
                if (r == null) continue;
                size += r.getSize();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMainClassName(LaunchDesc ld) throws IOException, JNLPException, LaunchDescException {
        String mainclassname = null;
        mainclassname = ld.getMainClassName();
        if (mainclassname != null && mainclassname.length() == 0) {
            mainclassname = null;
        }
        if (ld.getResources() == null) {
            return null;
        }
        JARDesc mainJar = ld.getMainJar();
        if (mainJar == null) {
            return null;
        }
        Manifest mf = null;
        try (ZipFile jarf = null;){
            String nameFromManifest;
            jarf = JarUtil.createJarFile((File)ResourceProvider.get().getCachedJNLPFile(mainJar.getLocation(), mainJar.getVersion()), (boolean)false);
            if (jarf != null && ld.getLaunchType() != 2 && (mf = ((JarFile)jarf).getManifest()) != null) {
                mainclassname = DeployManifestChecker.verifyMainClass((String)mainclassname, (Attributes)mf.getMainAttributes());
            }
            if (mainclassname == null) {
                throw new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.nomainclassspec"), null);
            }
            String string = nameFromManifest = mf == null ? null : mf.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (nameFromManifest == null) {
                String string2 = mainclassname;
                return string2;
            }
            String mainclasspath = mainclassname.replace('.', '/') + ".class";
            if (((JarFile)jarf).getEntry(mainclasspath) == null) {
                throw new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.nomainclass", (Object[])new Object[]{mainclassname, mainJar.getLocation().toString()}), null);
            }
            String string3 = mainclassname;
            return string3;
        }
    }

    public static boolean inCache(JARDesc jar) {
        return ResourceProvider.get().isCached(jar.getLocation(), jar.getVersion());
    }

    private static class DownloadTask
    implements Callable<Object> {
        private URL url;
        private int downloadType;
        private String resourceID;
        private String versionString;
        private DownloadDelegate dd;
        private final boolean doDownload;
        private Preloader dp;
        private int[] counterBox;
        private DownloadCallbackHelper dch;

        public DownloadTask(URL url, String resourceID, String versionString, DownloadDelegate dd, boolean doDownload, int downloadType, Preloader dp, int[] counterBox, DownloadCallbackHelper dch) {
            this.url = url;
            this.downloadType = downloadType;
            this.resourceID = resourceID;
            this.versionString = versionString;
            this.dd = dd;
            this.doDownload = doDownload;
            this.dp = dp;
            this.counterBox = counterBox;
            this.dch = dch;
        }

        public URL getURL() {
            return this.url;
        }

        public String getVersion() {
            return this.versionString;
        }

        public int hashCode() {
            if (this.url == null) {
                return 0;
            }
            return this.url.hashCode();
        }

        public String toString() {
            return this.url.toString() + (String)(this.versionString != null ? ":" + this.versionString : "");
        }

        public boolean equals(Object obj) {
            if (obj instanceof DownloadTask) {
                DownloadTask dTask = (DownloadTask)obj;
                URL u = dTask.getURL();
                String version = dTask.getVersion();
                if (this.url.toString().equals(u.toString())) {
                    if (this.versionString == null && version == null) {
                        return true;
                    }
                    if (this.versionString != null && version != null && this.versionString.equals(version)) {
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws IOException, JNLPException {
            int current = ResourceProvider.get().incrementInternalUse();
            try {
                URL cacheFileURL;
                Resource r = ResourceProvider.get().getResource(this.url, this.versionString, this.doDownload, this.downloadType, (DownloadDelegate)this.dch);
                URL uRL = cacheFileURL = r != null ? URLUtil.fileToURL((File)r.getDataFile()) : null;
                if (Cache.isCacheEnabled() && cacheFileURL == null && !Environment.isImportMode()) {
                    throw new FailedDownloadingResourceException(null, this.url, this.versionString, null);
                }
                LaunchDownload.notifyProgress(this.dch, this.counterBox, this.url);
            }
            finally {
                ResourceProvider.get().decrementInternalUse(current);
            }
            return null;
        }
    }

    private static class DownloadCallbackHelper
    implements DownloadDelegate {
        Preloader _preloader;
        long _totalSize = -1L;
        final ArrayList<ProgressRecord> _records;
        int _numOfJars = 1;
        int _jarsDone = 0;
        private static WeakHashMap<Preloader, DownloadCallbackHelper> helpers = new WeakHashMap();

        private DownloadCallbackHelper(Preloader dp) {
            this._preloader = dp;
            this._records = new ArrayList();
        }

        static DownloadCallbackHelper get(Preloader dp) {
            DownloadCallbackHelper dch = helpers.get(dp);
            if (dch == null) {
                dch = new DownloadCallbackHelper(dp);
                helpers.put(dp, dch);
            }
            return dch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(String url, String version, int sizeEstimate, double weight) {
            ProgressRecord record = this.getProgressRecord(url);
            if (record == null) {
                record = new ProgressRecord(url, version, sizeEstimate);
                record.setWeight(weight);
                ArrayList<ProgressRecord> arrayList = this._records;
                synchronized (arrayList) {
                    this._records.add(record);
                }
            } else {
                record.setWeight(weight);
                record.setSize(sizeEstimate);
            }
        }

        public void setTotalSize(long size) {
            this._totalSize = size;
        }

        public void setNumOfJars(int num) {
            this._numOfJars = num;
        }

        public void setJarsDone(int num) {
            this._jarsDone = num;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void downloading(URL url, String version, int readSoFar, int total, boolean willPatch) throws CancelException {
            if (this._preloader != null) {
                String u = url.toString();
                ProgressRecord record = this.getProgressRecord(u);
                if (record == null) {
                    record = new ProgressRecord(u, version, total);
                    ArrayList<ProgressRecord> arrayList = this._records;
                    synchronized (arrayList) {
                        this._records.add(record);
                    }
                } else {
                    record.setSize(total);
                }
                record.downloadProgress(readSoFar);
                int overallPercent = this.getOverallPercent();
                this._preloader.handleEvent((PreloaderEvent)new DownloadEvent(0, url, version, null, (long)readSoFar, (long)total, overallPercent));
            }
        }

        public void patching(URL url, String version, int percentDone) throws CancelException {
            String u;
            ProgressRecord record;
            if (this._preloader != null && (record = this.getProgressRecord(u = url.toString())) != null) {
                record.patchProgress(percentDone);
                int overallPercent = this.getOverallPercent();
                this._preloader.handleEvent((PreloaderEvent)new DownloadEvent(2, url, version, null, (long)percentDone, 100L, overallPercent));
            }
        }

        public void validating(URL url, int readSoFar, int total) throws CancelException {
            String u;
            ProgressRecord record;
            if (this._preloader != null && (record = this.getProgressRecord(u = url.toString())) != null) {
                record.cacheTotalElements(total);
                record.validateProgress(readSoFar, total);
                int overallPercent = this.getOverallPercent();
                this._preloader.handleEvent((PreloaderEvent)new DownloadEvent(1, url, null, null, (long)readSoFar, (long)total, overallPercent));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProgressRecord getProgressRecord(String url) {
            ArrayList<ProgressRecord> arrayList = this._records;
            synchronized (arrayList) {
                for (ProgressRecord record : this._records) {
                    if (url == null || !url.equals(record.getUrl())) continue;
                    return record;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getOverallPercent() {
            double percent = 0.0;
            double totalWeight = 0.0;
            ArrayList<ProgressRecord> arrayList = this._records;
            synchronized (arrayList) {
                for (ProgressRecord record : this._records) {
                    percent += record.getPercent() * record.getWeight();
                    totalWeight += record.getWeight();
                }
            }
            int overall = (int)(percent * 100.0 / totalWeight);
            if (overall > 100) {
                overall = 100;
            }
            return overall;
        }

        public void downloadFailed(URL url, String version) {
            if (this._preloader != null) {
                try {
                    this._preloader.handleEvent((PreloaderEvent)new DownloadErrorEvent(url, version));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
            }
        }

        void jarDone(URL url) {
            String u;
            ProgressRecord record;
            if (this._preloader != null && (record = this.getProgressRecord(u = url.toString())) != null && record.getPercent() < 1.0) {
                record.markComplete();
                int overallPercent = this.getOverallPercent();
                try {
                    this._preloader.handleEvent((PreloaderEvent)new DownloadEvent(1, url, null, null, (long)record.getCachedTotalElements(), (long)record.getCachedTotalElements(), overallPercent));
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
            }
        }
    }

    private static class ProgressRecord {
        private String _url;
        private String _ver;
        private int _size;
        private double _percent;
        private int _totalElements = 1;
        private double _weight;

        public ProgressRecord(String url, String ver, int size) {
            this._url = url;
            this._ver = ver;
            this._size = size;
            this._weight = 1.0;
            this._percent = 0.0;
        }

        void cacheTotalElements(int total) {
            this._totalElements = total;
        }

        int getCachedTotalElements() {
            return this._totalElements;
        }

        void setWeight(double weight) {
            this._weight = weight;
        }

        void setSize(int size) {
            this._size = size;
        }

        double getPercent() {
            return this._percent;
        }

        String getUrl() {
            return this._url;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + (this._url != null ? this._url.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object o) {
            return this._url.equals(((ProgressRecord)o)._url);
        }

        double getWeight() {
            return this._weight;
        }

        void downloadProgress(int bytesDownloaded) {
            this._percent = this._size != 0 ? (double)bytesDownloaded / (double)this._size * 0.8 : 0.8;
        }

        void patchProgress(int patchPercent) {
            this._percent = (double)patchPercent / 100.0 * 0.1 + 0.8;
        }

        void validateProgress(int sofar, int total) {
            this._percent = total != 0 ? (double)sofar / (double)total * 0.05 + 0.9 : 0.95;
        }

        private void markComplete() {
            this._percent = 1.0;
        }
    }
}

