/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.event.AppInitEvent;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ComponentRef;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.HtmlOptions;
import com.sun.javaws.IconUtil;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JreExecException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.security.AppContextUtil;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JNLPSignedResourcesHelper;
import com.sun.javaws.security.JavaWebStartSecurity;
import com.sun.javaws.ui.ApplicationIconGenerator;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsConsoleController;
import com.sun.javaws.util.JfxHelper;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.JNLPClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import sun.awt.AppContext;

public class Launcher
implements Runnable {
    private LaunchDesc _initialLaunchDesc;
    protected LaunchDesc _launchDesc;
    protected String[] _args;
    protected boolean _exit = true;
    private JAuthenticator _ja;
    private LocalApplicationProperties _lap = null;
    private JNLPClassLoader _jnlpClassLoader = null;
    private JREInfo _jreInfo = null;
    private boolean _isRelaunch = false;
    private boolean _isCached = false;
    private boolean _isUpdated = false;
    private boolean _disableCustomPreloader = false;
    boolean securityManagerDiabledForTests = false;
    private boolean _shownDownloadWindow = false;

    public Launcher(LaunchDesc ld) {
        this._initialLaunchDesc = ld;
    }

    public Launcher(LaunchDesc ld, String[] args, boolean exit) {
        this(ld);
        this._args = args;
        this._exit = exit;
    }

    public void launch(String[] args, boolean exit) {
        this._args = args != null ? (String[])args.clone() : null;
        this._exit = exit;
        if (this.checkForSingleInstance()) {
            return;
        }
        if (this.prepareToLaunch()) {
            this.initiateUpdateCheck();
            if (this.useAppletLifecycle()) {
                return;
            }
            new Thread(Main.getLaunchThreadGroup(), this, "javawsApplicationMain").start();
        } else if (!Environment.isImportMode()) {
            LaunchErrorDialog.show(Progress.get(null).getOwner(), new Exception(ResourceManager.getString((String)"launch.error.category.unexpected")), true);
        }
    }

    @Override
    public void run() {
        block9: {
            try {
                this.doLaunchApp();
            }
            catch (Throwable t) {
                int exitValue;
                ExitException ee = null;
                Throwable cause = t.getCause();
                ee = cause != null && cause instanceof ExitException ? (ExitException)cause : (t instanceof ExitException ? (ExitException)t : new ExitException(t, 3));
                int n = exitValue = ee.getReason() == 0 || t instanceof BlockedException ? 0 : -1;
                if (exitValue != 0 && this._launchDesc != null && this._launchDesc.isApplication()) {
                    URL href = this._launchDesc.getCanonicalHome();
                    SecureStaticVersioning.resetAcceptedVersion((URL)href, (AppInfo)this._launchDesc.getAppInfo());
                }
                if (ee.getReason() == 3) {
                    if (this._launchDesc != null && this._launchDesc.getUpdater().isBackgroundUpdateRunning() && this._lap != null) {
                        this._lap.setForceUpdateCheck(true);
                        try {
                            this._lap.store();
                        }
                        catch (Exception href) {
                            // empty catch block
                        }
                    }
                    LaunchErrorDialog.show(Progress.get(null).getOwner(), ee.getException(), this._exit);
                }
                if (!this._exit) break block9;
                try {
                    Main.systemExit(exitValue);
                }
                catch (ExitException ee2) {
                    Trace.println((String)("systemExit: " + ee2), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)ee2);
                }
            }
        }
    }

    public boolean isImport() {
        return Environment.isImportMode() || this._launchDesc != null && this._launchDesc.isLibrary();
    }

    public LocalApplicationProperties getLap() {
        return this._lap;
    }

    boolean prepareToLaunch() {
        boolean tryOffline = this.tryOffline();
        try {
            if (!tryOffline && DeployOfflineManager.isForcedOffline()) {
                throw new CacheUpdateRequiredException("Forced offline mode!");
            }
            boolean ret = this.prepareToLaunch(tryOffline);
            return ret;
        }
        catch (CacheUpdateRequiredException e) {
            return this.handleCacheUpdateRequiredException(e, tryOffline);
        }
    }

    private boolean canRelaunch() {
        if (this._isRelaunch) {
            Trace.println((String)"JAVAWS: Relaunch ignored: relaunched already", (TraceLevel)TraceLevel.BASIC);
            return false;
        }
        return true;
    }

    private boolean prepareToLaunch(boolean offlineOnly) throws CacheUpdateRequiredException {
        try {
            this.updateLaunchDesc(offlineOnly);
            this.prepareAllResources(offlineOnly);
        }
        catch (CacheUpdateRequiredException e) {
            throw e;
        }
        catch (Throwable t) {
            this.handleExitException(t);
            return false;
        }
        return true;
    }

    public boolean useAppletLifecycle() {
        if (this._launchDesc == null) {
            return false;
        }
        String tk = System.getProperty("jnlp.tk");
        boolean useJfxTk = "jfx".equals(tk);
        boolean isFX = this._launchDesc.isFXApp();
        boolean isApplet = this._launchDesc.isApplet();
        if (isFX && useJfxTk || !isFX && isApplet) {
            Trace.println((String)("using applet lifecycle because " + (useJfxTk ? "using FX Toolkit" : "it is an Applet")), (TraceLevel)TraceLevel.BASIC);
            return true;
        }
        Trace.println((String)"not using applet lifecycle", (TraceLevel)TraceLevel.BASIC);
        return false;
    }

    protected boolean updateFinalLaunchDesc(LaunchDesc ld, int count, boolean useCacheOnly) throws ExitException, CacheUpdateRequiredException {
        int current = ResourceProvider.get().incrementInternalUse();
        try {
            File cachedFile;
            URL href = ld.getLocation();
            if (href == null) {
                this._launchDesc = ld;
                if (ld.getCanonicalHome() == null) {
                    boolean bl = false;
                    return bl;
                }
                LaunchDesc newDesc = LaunchDownload.updateLaunchDescInCache(ld);
                boolean bl = ld == newDesc;
                return bl;
            }
            URL codebase = this.deriveCodebase(href);
            boolean fromCache = SystemUtils.isPathFromCache((String)this._args[0]);
            Resource r = ResourceProvider.get().getResource(href, null, false, 1, null);
            File file = cachedFile = r != null ? r.getDataFile() : null;
            if (!useCacheOnly && fromCache) {
                LaunchDesc newLD = LaunchDownload.getUpdatedLaunchDesc(href, null, false);
                if (newLD == null) {
                    this._launchDesc = ld;
                    boolean bl = false;
                    return bl;
                }
                URL newHref = newLD.getLocation();
                if (newHref == null || !newHref.toString().equals(href.toString()) && count == 0) {
                    ResourceProvider.get().markRetired(r, false);
                    boolean bl = this.updateFinalLaunchDesc(newLD, ++count, false);
                    return bl;
                }
                this._launchDesc = newLD;
                boolean bl = true;
                return bl;
            }
            if (cachedFile != null) {
                boolean wasUpdated;
                block39: {
                    wasUpdated = false;
                    if (!useCacheOnly) {
                        r = ResourceProvider.get().getResource(href, null, true, 1, null);
                        cachedFile = r != null ? r.getDataFile() : null;
                        wasUpdated = true;
                    }
                    try {
                        this._launchDesc = LaunchDescFactory.buildDescriptor(cachedFile, codebase, null, href);
                    }
                    catch (LaunchDescException lde) {
                        this._launchDesc = LaunchDescFactory.buildDescriptor(cachedFile);
                        if (this._launchDesc != null) break block39;
                        throw lde;
                    }
                }
                LaunchDesc newLD = null;
                if (!ld.hasIdenticalContent(this._launchDesc)) {
                    if (count == 0 && useCacheOnly) {
                        throw new CacheUpdateRequiredException("Given JNLP is newer than cached copy!");
                    }
                    Trace.println((String)"Launch copy is different than cached, force update", (TraceLevel)TraceLevel.BASIC);
                    newLD = LaunchDownload.getUpdatedLaunchDesc(href, null, true);
                }
                if (newLD != null) {
                    this._launchDesc = newLD;
                    URL newHref = this._launchDesc.getLocation();
                    if (newHref == null || !newHref.toString().equals(href.toString()) && count == 0) {
                        ResourceProvider.get().markRetired(r, useCacheOnly);
                        boolean bl = this.updateFinalLaunchDesc(this._launchDesc, ++count, useCacheOnly);
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                if (wasUpdated) {
                    boolean newHref = true;
                    return newHref;
                }
                Cache.removeRemovedApp((String)href.toString(), (String)this._launchDesc.getInformation().getTitle());
                URL newHref = this._launchDesc.getLocation();
                if (newHref == null || !newHref.toString().equals(href.toString()) && count == 0) {
                    ResourceProvider.get().markRetired(r, false);
                    boolean bl = this.updateFinalLaunchDesc(this._launchDesc, ++count, useCacheOnly);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (useCacheOnly) {
                throw new CacheUpdateRequiredException("Missing from the cache: " + href);
            }
            if (Cache.isCacheEnabled()) {
                r = ResourceProvider.get().getResource(href, null, true, 1, null);
                File file2 = cachedFile = r != null ? r.getDataFile() : null;
                if (cachedFile != null) {
                    this._launchDesc = LaunchDescFactory.buildDescriptor(cachedFile, codebase, null, href);
                    URL newHref = this._launchDesc.getLocation();
                    if (newHref == null || !newHref.toString().equals(href.toString()) && count == 0) {
                        ResourceProvider.get().markRetired(r, false);
                        boolean bl = this.updateFinalLaunchDesc(this._launchDesc, ++count, useCacheOnly);
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                throw new Exception("cache failed for" + href);
            }
            this._launchDesc = LaunchDescFactory.buildDescriptor(href, codebase);
            URL newHref = this._launchDesc.getLocation();
            if (newHref != null && !newHref.toString().equals(href.toString()) && count == 0) {
                boolean bl = this.updateFinalLaunchDesc(this._launchDesc, ++count, useCacheOnly);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (CacheUpdateRequiredException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new ExitException(exception, 3);
        }
        finally {
            ResourceProvider.get().decrementInternalUse(current);
        }
    }

    private URL deriveCodebase(URL href) {
        try {
            return new URL(href.toString().substring(0, href.toString().lastIndexOf("/") + 1));
        }
        catch (MalformedURLException mue) {
            Trace.ignoredException((Exception)mue);
            return null;
        }
    }

    private void removeTempJnlpFile(LaunchDesc ld) {
        File cachedJnlp = null;
        if (ld.isApplicationDescriptor()) {
            cachedJnlp = ResourceProvider.get().getCachedJNLPFile(ld.getCanonicalHome(), null);
        }
        if (cachedJnlp == null) {
            return;
        }
        if (this._args != null && cachedJnlp != null && JnlpxArgs.shouldRemoveArgumentFile()) {
            new File(this._args[0]).delete();
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
            this._args[0] = cachedJnlp.getPath();
        }
    }

    public void prepareAllResources(boolean offlineOnly) throws ExitException, CacheUpdateRequiredException {
        ArrayList<File> installFiles = new ArrayList<File>();
        boolean skipExtensions = this.prepareLaunchFile(this._launchDesc, this._args, offlineOnly, installFiles);
        this.prepareSecurity(this._launchDesc);
        final PreloaderDelegate preloader = Progress.get(null);
        final JNLPSignedResourcesHelper signingHelper = new JNLPSignedResourcesHelper(this._launchDesc);
        if (!offlineOnly) {
            this.prepareEnvironment(this._launchDesc);
            if (!Globals.isSilentMode() && !offlineOnly) {
                boolean updateCache = !this._launchDesc.getUpdate().isBackgroundCheck() && !this._launchDesc.getUpdate().isPromptPolicy() && !this._isRelaunch;
                boolean doUpdate = !this._isCached || updateCache;
                Runnable okAction = new Runnable(){

                    @Override
                    public void run() {
                        SplashScreen.hide();
                        try {
                            boolean allSigned = signingHelper.checkSignedResources(Progress.get(null), true);
                            Trace.println((String)("Security check for progress jars: allSigned=" + allSigned), (TraceLevel)TraceLevel.SECURITY);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        if (Launcher.this.disableCustomPreloader(Launcher.this._launchDesc)) {
                            preloader.setPreloaderClass(null);
                        }
                        preloader.initPreloader((ClassLoader)((Object)Launcher.this._jnlpClassLoader), Main.getLaunchThreadGroup());
                    }
                };
                Runnable failAction = new Runnable(){

                    @Override
                    public void run() {
                        preloader.setPreloaderClass(null);
                        SplashScreen.hide();
                        preloader.initPreloader((ClassLoader)((Object)Launcher.this._jnlpClassLoader), Main.getLaunchThreadGroup());
                    }
                };
                new LaunchDownload(this._launchDesc).prepareCustomProgress(preloader, signingHelper, okAction, failAction, doUpdate);
            }
        }
        this.prepareResources(this._launchDesc, this._args, this._isUpdated, offlineOnly, skipExtensions, installFiles, signingHelper);
        if (offlineOnly) {
            this.prepareEnvironment(this._launchDesc);
            preloader.setPreloaderClass(this._launchDesc.getProgressClassName());
            preloader.initPreloader((ClassLoader)((Object)this._jnlpClassLoader), Main.getLaunchThreadGroup());
        }
    }

    private boolean prepareLaunchFile(LaunchDesc ld, String[] args, boolean offlineOnly, ArrayList<File> installFiles) throws ExitException, CacheUpdateRequiredException {
        URL jnlpUrl;
        LaunchDescException lde;
        boolean loadedExtensions = false;
        if (ld.getResources() == null) {
            this.handleJnlpFileException(ld, new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.noappresources", (Object[])new Object[]{ld.getSpecVersion()}), null));
        }
        if (!this.isImport() && ld.isLibrary()) {
            LaunchDescException lde2 = new LaunchDescException(ld, "Internal Error: !isImport() && ld.isLibrary()", null);
            this.handleJnlpFileException(ld, lde2);
        }
        boolean isInstaller = ld.isInstaller();
        JNLPException.setDefaultLaunchDesc(ld);
        JREInfo homeJREInfo = JREInfo.getHomeJRE();
        Trace.println((String)("Launcher: isInstaller: " + isInstaller + ", isRelaunch: " + this._isRelaunch + ", isImport(): " + this.isImport() + ", java.home:" + Environment.getJavaHome() + ", Running JRE: " + homeJREInfo), (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)"JREInfos", (TraceLevel)TraceLevel.BASIC);
        JREInfo.traceJREs();
        if (homeJREInfo == null) {
            LaunchDescException lde3 = new LaunchDescException(ld, "Internal Error: no running JRE", null);
            this.handleJnlpFileException(ld, lde3);
        }
        if (!ld.getInformation().supportsOfflineOperation() && DeployOfflineManager.isGlobalOffline()) {
            throw new ExitException(new OfflineLaunchException(1), 3);
        }
        LaunchDownload download = new LaunchDownload(ld);
        if ((this._isRelaunch || ld.getUpdate().isBackgroundCheck() || ld.getUpdate().isPromptPolicy()) && (this._lap == null || !this._lap.forceUpdateCheck())) {
            this._isCached = download.isInCache();
        }
        if (!this._isCached && !offlineOnly) {
            try {
                download.downloadExtensions(null, 0, installFiles);
                loadedExtensions = true;
            }
            catch (Exception ioe) {
                if (!ld.getInformation().supportsOfflineOperation() || !download.isInCache()) {
                    throw new ExitException(ioe, 3);
                }
                Trace.ignoredException((Exception)ioe);
            }
        } else {
            loadedExtensions = this._isCached;
        }
        if (!loadedExtensions) {
            if (!ld.getInformation().supportsOfflineOperation() || !download.isInCache()) {
                throw new CacheUpdateRequiredException("Some of required resources are not cached.");
            }
            loadedExtensions = true;
        }
        JREMatcher jreMatcher = ld.getJREMatcher();
        JVMParameters jvmParams = jreMatcher.getSelectedJVMParameters();
        this._jreInfo = jreMatcher.getSelectedJREInfo();
        JREDesc jreDesc = jreMatcher.getSelectedJREDesc();
        if (this._jreInfo == null && jreDesc == null || null == jvmParams) {
            Trace.println((String)jreMatcher.toString());
            lde = new LaunchDescException(ld, "Internal Error: Internal error, jreMatcher uninitialized", null);
            this.handleJnlpFileException(ld, lde);
        }
        if (!ld.isJRESpecified()) {
            lde = new LaunchDescException(ld, "Internal Error: !isJRESpecified()", null);
            this.handleJnlpFileException(ld, lde);
        }
        if ((jnlpUrl = ld.getCanonicalHome()) == null) {
            LaunchDescException lde4 = new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.nomainjar"), null);
            throw new ExitException(lde4, 3);
        }
        if (isInstaller) {
            this._lap = Cache.getLocalApplicationProperties((String)args[0]);
            if (this._lap == null || !Environment.isInstallMode()) {
                this.handleJnlpFileException(ld, new MissingFieldException(ld.getSource(), "<application-desc>|<applet-desc>"));
            }
            jnlpUrl = this._lap.getLocation();
        } else if (!ld.isLibrary()) {
            this._lap = Cache.getLocalApplicationProperties((URL)jnlpUrl);
        }
        Trace.println((String)("LaunchDesc location: " + jnlpUrl), (TraceLevel)TraceLevel.BASIC);
        return loadedExtensions;
    }

    private void prepareEnvironment(LaunchDesc ld) throws ExitException {
        if (this.isImport() && !ld.isInstaller()) {
            return;
        }
        AppPolicy policy = AppPolicy.createInstance(ld.getCanonicalHome().getHost());
        this._jnlpClassLoader = JNLPClassLoader.createClassLoader(ld, policy);
        try {
            String codebaseProtocol = "http";
            URL canonicalHome = ld.getCanonicalHome();
            if (canonicalHome.getProtocol().equalsIgnoreCase("file") && canonicalHome.getHost().equals("")) {
                codebaseProtocol = "file";
            }
            BasicServiceImpl.initialize(ld.getCodebase(), true, codebaseProtocol);
            if (ld.getLaunchType() == 4) {
                String installDir = this._lap.getInstallDirectory();
                if (installDir == null) {
                    installDir = Cache.getNewExtensionInstallDirectory();
                    this._lap.setInstallDirectory(installDir);
                }
                ExtensionInstallerServiceImpl.initialize(ld.isSecure() ? null : installDir, this._lap, Progress.get(null));
            }
        }
        catch (Throwable t) {
            throw new ExitException(t, 3);
        }
        if (!this.securityManagerDiabledForTests) {
            System.setSecurityManager(new JavaWebStartSecurity());
        }
    }

    private boolean isJfxSupportSatisfied(LaunchDesc ld) {
        if (!ld.needFX()) {
            return true;
        }
        if (ld.isFXApp() && !ToolkitStore.setPreferredToolkit((ToolkitStore.ToolkitType)ToolkitStore.ToolkitType.FX_TOOLKIT)) {
            return false;
        }
        return JfxHelper.isJfxSupportSatisfied(null, ld);
    }

    protected void relaunch(JREDesc jreDesc, LaunchDesc ld, String[] args, JVMParameters jvmParams, boolean secure) throws ExitException {
        File f;
        if (!this.canRelaunch()) {
            return;
        }
        if (OSType.isMac()) {
            String iconPath;
            String title = ld.getInformation().getTitle();
            if (title != null) {
                System.setProperty("macosx.jnlpx.dock.name", title);
            }
            if ((iconPath = IconUtil.getIconPath(ld)) == null) {
                iconPath = Platform.get().getDefaultIconPath();
            }
            if (iconPath != null) {
                System.setProperty("macosx.jnlpx.dock.icon", iconPath);
            }
        }
        long minHeap = jreDesc.getMinHeap();
        long maxHeap = jreDesc.getMaxHeap();
        HtmlOptions o = HtmlOptions.get();
        if (o != null) {
            try {
                File tmpLaunchProps = File.createTempFile("jnl", ".tmp");
                o.export(new FileOutputStream(tmpLaunchProps));
                args = new String[]{"-nocodebase", tmpLaunchProps.getAbsolutePath()};
            }
            catch (IOException ioe) {
                throw new ExitException("Failed to relaunch. Can not save launch file.", ioe);
            }
        }
        if ((f = SessionState.save()) != null) {
            System.setProperty("jnlpx.session.data", f.getAbsolutePath());
        }
        try {
            if (secure) {
                JVMParameters jvmExtASCIIParams = new JVMParameters();
                jvmExtASCIIParams.setIncludeExtendedASCIIValues(true);
                jvmExtASCIIParams.parse(jreDesc.getVmArgs());
                jvmParams.addArguments(jvmExtASCIIParams);
            }
            args = this.insertApplicationArgs(args);
            Process process = JnlpxArgs.execProgram(this._jreInfo, args, minHeap, maxHeap, jvmParams, secure, ld.isFXApp(), ld.needFX());
            try {
                InputStream is;
                long timeout = 3L;
                process.waitFor(3L, TimeUnit.SECONDS);
                if (!process.isAlive() && process.exitValue() != 0 && (is = process.getErrorStream()) != null) {
                    Scanner s = new Scanner(is).useDelimiter("\\A");
                    String jvmError = s.hasNext() ? s.next() : "";
                    LaunchErrorDialog.show(Progress.get(null).getOwner(), new Exception(jvmError), true);
                    is.close();
                }
                if (Platform.get().getRunInNativeSandbox()) {
                    process.waitFor();
                }
            }
            catch (InterruptedException ex) {
                Trace.ignoredException((Exception)ex);
            }
        }
        catch (IOException ioe) {
            throw new ExitException(new JreExecException(this._jreInfo.getPath(), ioe), 3);
        }
        if (JnlpxArgs.shouldRemoveArgumentFile()) {
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
        }
        throw new ExitException(null, 0);
    }

    private boolean runInNativeSandbox(LaunchDesc ld) {
        if (Platform.get().isNativeSandbox()) {
            return false;
        }
        DeploymentRuleSet drs = ld.getMainDeploymentRuleSet();
        if (drs != null && !drs.allowNativeSandbox()) {
            return false;
        }
        ArrayList<LaunchDesc> list = new ArrayList<LaunchDesc>();
        JNLPSignedResourcesHelper.addExtensions(list, ld);
        for (LaunchDesc listItem : list) {
            JARDesc[] jds;
            ResourcesDesc rd;
            LaunchDesc cur = listItem;
            if (cur.getSecurityModel() == 0 || (rd = cur.getResources()) == null || (jds = rd.getLocalJarDescs()) == null || jds.length == 0) continue;
            return false;
        }
        return true;
    }

    private boolean disableCustomPreloader(LaunchDesc ld) {
        if (this._disableCustomPreloader) {
            Trace.println((String)"Custom preloader: disabled", (TraceLevel)TraceLevel.PRELOADER);
            return true;
        }
        if (this.runInNativeSandbox(ld)) {
            Trace.println((String)"Custom preloader: disabled", (TraceLevel)TraceLevel.PRELOADER);
            return true;
        }
        if (this._lap != null && this._lap.getEnableCustomPreloader()) {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
            return false;
        }
        if (Platform.get().isNativeSandbox()) {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
            return false;
        }
        DeploymentRuleSet drs = ld.getMainDeploymentRuleSet();
        if (drs != null && !drs.allowNativeSandbox()) {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
            return false;
        }
        ArrayList<LaunchDesc> list = new ArrayList<LaunchDesc>();
        JNLPSignedResourcesHelper.addExtensions(list, ld);
        boolean haveAllPermissions = false;
        boolean haveSandbox = false;
        for (LaunchDesc cur : list) {
            if (cur.getSecurityModel() == 0) {
                haveSandbox = true;
            } else {
                haveAllPermissions = true;
            }
            if (!haveAllPermissions || !haveSandbox) continue;
            this._disableCustomPreloader = true;
            break;
        }
        if (this._disableCustomPreloader) {
            Trace.println((String)"Custom preloader: disabled", (TraceLevel)TraceLevel.PRELOADER);
        } else {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
        }
        return this._disableCustomPreloader;
    }

    private void prepareResources(LaunchDesc ld, String[] args, boolean launchFileUpdated, boolean offlineOnly, boolean skipExtensions, ArrayList<File> installFiles, JNLPSignedResourcesHelper signingHelper) throws ExitException, CacheUpdateRequiredException {
        boolean forceUpdate;
        boolean isInstaller = ld.isInstaller();
        boolean offlineMode = this._isCached && DeployOfflineManager.isGlobalOffline();
        boolean forceUpdateIfCached = !this.isImport() && this._jreInfo == null || isInstaller;
        boolean bl = forceUpdate = !this._isCached || forceUpdateIfCached;
        if (forceUpdate && offlineMode) {
            throw new ExitException(new OfflineLaunchException(0), 3);
        }
        boolean needUpdate = forceUpdate;
        if (!offlineMode) {
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                Trace.println((String)"Forced update check in LAP, do full update", (TraceLevel)TraceLevel.BASIC);
                needUpdate = true;
            } else if (!offlineOnly && !ld.getUpdate().isBackgroundCheck() && ld.getUpdate().getPolicy() == 0) {
                needUpdate = true;
            } else if (!offlineOnly) {
                try {
                    needUpdate = ld.getUpdater().isUpdateAvailable();
                }
                catch (Exception e) {
                    throw new ExitException(e, 3);
                }
                if (needUpdate && ld.getUpdate().getPolicy() != 0) {
                    this._isCached = new LaunchDownload(ld).isInCache();
                    if (this._isCached) {
                        forceUpdate = forceUpdateIfCached;
                    }
                }
                if (ld.getUpdater().isCheckAborted()) {
                    throw new ExitException(new LaunchDescException(ld, "User rejected cert - aborted", null), 4);
                }
            }
        }
        Trace.println((String)("Offline mode: " + offlineMode + "\nIsInCache: " + this._isCached + "\nforceUpdate: " + forceUpdate + "\nneedUpdate: " + needUpdate + "\nIsInstaller: " + isInstaller), (TraceLevel)TraceLevel.BASIC);
        if (needUpdate && !forceUpdate) {
            forceUpdate = ld.getUpdater().needUpdatePerPolicy(Progress.get(null));
        }
        if (forceUpdate && offlineMode) {
            throw new ExitException(new OfflineLaunchException(0), 3);
        }
        if (forceUpdate) {
            this.downloadResources(ld, installFiles, skipExtensions, isInstaller);
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                this._lap.setForceUpdateCheck(false);
                try {
                    this._lap.store();
                }
                catch (IOException ioe) {
                    Trace.ignoredException((Exception)ioe);
                }
            }
        }
        PreloaderDelegate cp = Progress.get(null);
        try {
            cp.handleEvent((PreloaderEvent)new DownloadEvent(1, ld.getLocation(), null, null, 1L, 1L, 100));
        }
        catch (CancelException ce) {
            throw new ExitException(ce, 3);
        }
        try {
            cp.waitTillLoaded();
        }
        catch (JNLPException je) {
            throw new ExitException(je, 3);
        }
        catch (IOException ioe) {
            LaunchDownload download = new LaunchDownload(ld);
            if (ld.getInformation().supportsOfflineOperation() && download.isInCache(skipExtensions)) {
                Trace.ignoredException((Exception)ioe);
            }
            throw new ExitException(ioe, 3);
        }
        ApplicationIconGenerator.generate(ld, launchFileUpdated);
        if (!this.isImport() && !installFiles.isEmpty()) {
            if (isInstaller) {
                // empty if block
            }
            JnlpxArgs.executeInstallers(installFiles, Progress.get(null));
        }
        if (!Globals.isSilentMode() && ld.isInstaller()) {
            try {
                Progress.get(null).handleEvent((PreloaderEvent)new ConfigEvent(3, ld.getAppInfo()));
                Progress.get(null).handleEvent((PreloaderEvent)new InitEvent(2));
            }
            catch (CancelException ce) {
                throw new ExitException(ce, 3);
            }
        }
        JREMatcher jreMatcher = ld.getJREMatcher();
        JVMParameters jvmParams = jreMatcher.getSelectedJVMParameters();
        this._jreInfo = jreMatcher.getSelectedJREInfo();
        JREDesc jreDesc = jreMatcher.getSelectedJREDesc();
        if (this.isImport()) {
            try {
                Progress.get(null).handleEvent((PreloaderEvent)new InitEvent(5));
            }
            catch (CancelException ce) {
                throw new ExitException(ce, 3);
            }
            boolean updated = LaunchDownload.isJnlpCached(ld) && launchFileUpdated;
            Launcher.notifyLocalInstallHandler(ld, this._lap, Globals.isSilentMode(), updated, null);
            Trace.println((String)"Exiting after import", (TraceLevel)TraceLevel.BASIC);
            throw new ExitException(null, 0);
        }
        if (!ld.isValidSpecificationVersion()) {
            JNLPException.setDefaultLaunchDesc(ld);
            this.handleJnlpFileException(ld, new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.badjnlversion", (Object[])new Object[]{ld.getSpecVersion()}), null));
        }
        boolean allSigned = false;
        try {
            signingHelper.checkSignedLaunchDesc();
            allSigned = signingHelper.checkSignedResources(Progress.get(null), false);
            boolean bl2 = allSigned = allSigned && ld.isSigned();
            if (this._disableCustomPreloader) {
                this._lap.setEnableCustomPreloader(true);
                this._lap.store();
            }
        }
        catch (JNLPException je) {
            throw new ExitException(je, 3);
        }
        catch (IOException ioe) {
            throw new ExitException(ioe, 3);
        }
        SplashScreen.generateCustomSplash(ld, launchFileUpdated);
        DeploymentRuleSet drs = ld.getMainDeploymentRuleSet();
        try {
            if (this._jreInfo == null) {
                SecureStaticVersioning.useLatest((AppInfo)ld.getAppInfo(), (DeploymentRuleSet)drs, (String)jreDesc.getVersion(), (int)2);
                this._jreInfo = ld.selectJRE(true);
                jreMatcher = ld.getJREMatcher();
                jreDesc = jreMatcher.getSelectedJREDesc();
                jvmParams = jreMatcher.getSelectedJVMParameters();
            } else if (!SecureStaticVersioning.canUse((AppInfo)ld.getAppInfo(), (DeploymentRuleSet)drs, (String)this._jreInfo.getProduct())) {
                this._jreInfo = ld.selectJRE(true);
                jreMatcher = ld.getJREMatcher();
                jreDesc = jreMatcher.getSelectedJREDesc();
                jvmParams = jreMatcher.getSelectedJVMParameters();
            }
        }
        catch (BlockedException be) {
            throw new ExitException(be, 0);
        }
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            Trace.println((String)("passing security checks; secureArgs:" + ld.isSecureJVMArgs() + ", allSigned:" + allSigned), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("trusted app: " + !ld.isSecure() + ", -secure=" + Globals.isSecureMode()), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)jreMatcher.toString(), (TraceLevel)TraceLevel.BASIC);
        }
        boolean homeJVMMatch = jreMatcher.isRunningJVMSatisfying(allSigned);
        boolean runInNativeSandbox = this.runInNativeSandbox(ld);
        if (!homeJVMMatch || !this.isJfxSupportSatisfied(ld) || runInNativeSandbox || this._disableCustomPreloader) {
            if (runInNativeSandbox) {
                Platform.get().setRunInNativeSandbox(true);
            } else {
                Platform.get().setRunInNativeSandbox(false);
                if (this._disableCustomPreloader) {
                    Platform.get().checkAndUpdateSandboxWindow(true);
                }
            }
            this.relaunch(jreDesc, ld, args, jvmParams, allSigned);
        }
        String titleSuffix = " - " + ld.getInformation().getTitle();
        JavawsConsoleController.getInstance().setTitle("console.caption", titleSuffix);
        JavawsConsoleController.getInstance().showConsoleIfEnabled();
        JnlpxArgs.removeArgumentFile(args[0]);
        if (Cache.isCacheEnabled() && (LocalInstallHandler.getInstance() != null && !LocalInstallHandler.getInstance().isShortcutExists(this._lap) || Globals.isIconImageUpdated())) {
            Launcher.notifyLocalInstallHandler(ld, this._lap, Globals.isSilentMode(), launchFileUpdated || Globals.isIconImageUpdated(), Progress.get(null).getOwnerRef());
            if (Globals.isIconImageUpdated()) {
                Globals.setIconImageUpdated(false);
            }
        }
        Trace.println((String)"continuing launch in this VM", (TraceLevel)TraceLevel.BASIC);
        Config.getHooks().confirmAppRun();
    }

    private String[] insertApplicationArgs(String[] args) {
        String[] progArgs = Globals.getApplicationArgs();
        if (progArgs == null) {
            return args;
        }
        String[] ret = new String[progArgs.length + args.length];
        for (int i = 0; i < progArgs.length; ++i) {
            ret[i] = progArgs[i];
        }
        for (int j = 0; j < args.length; ++j) {
            ret[i++] = args[j];
        }
        return ret;
    }

    private void doLaunchApp() throws ExitException {
        AppContextUtil.createApplicationAppContext();
        JNLPClassLoader cl = this._jnlpClassLoader;
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)cl));
        ToolkitStore.get().setContextClassLoader((ClassLoader)((Object)cl));
        String appTitle = this._launchDesc.getInformation().getTitle();
        AppContext.getAppContext().put("deploy.trust.decider.app.name", appTitle);
        this._launchDesc.storeVersionsInAppContext();
        String className = null;
        Class<?> mainClass = null;
        try {
            className = LaunchDownload.getMainClassName(this._launchDesc);
            Trace.println((String)("Main-class: " + className), (TraceLevel)TraceLevel.BASIC);
            if (className == null) {
                throw new ClassNotFoundException(className);
            }
            ToolkitStore.get().getAppContext().put((Object)"deploy-main-class", (Object)className);
            if (!Config.checkPackageAccess((String)className, (AccessControlContext)Config.getNoPermissionACC())) {
                SecurityException se = new SecurityException("Bad package name of main-class");
                throw new ExitException(se, 3);
            }
            Progress.get(null).handleEvent((PreloaderEvent)new AppInitEvent(1));
            this._launchDesc.getUpdater().storeBackgroundListInAppContext();
            mainClass = ((ClassLoader)((Object)cl)).loadClass(className);
            Class[] main_type = new Class[]{new String[0].getClass()};
            Method mainMethod = mainClass.getMethod("main", main_type);
            Class<?> declaringClass = mainMethod.getDeclaringClass();
            if (declaringClass != mainClass) {
                ClassLoader extCL;
                ClassLoader mainMethodCL = declaringClass.getClassLoader();
                ClassLoader systemCL = ClassLoader.getSystemClassLoader();
                for (extCL = mainMethodCL; extCL != null && extCL.getParent() != null; extCL = extCL.getParent()) {
                }
                if (mainMethodCL == systemCL || mainMethodCL == extCL) {
                    throw new ClassNotFoundException(className);
                }
            }
            if (this.getClass().getPackage().equals(mainClass.getPackage())) {
                throw new ClassNotFoundException(className);
            }
            ClassLoader clUsed = mainClass.getClassLoader();
            if (clUsed != cl && clUsed != ((ClassLoader)((Object)cl)).getParent()) {
                SecurityException se = new SecurityException("Bad main-class name");
                throw new ExitException(se, 3);
            }
            CodeSource cs = mainClass.getProtectionDomain().getCodeSource();
            if (cs != null) {
                DeploymentRuleSet drs = this._launchDesc.getMainDeploymentRuleSet();
                if (cs.getCertificates() != null) {
                    DeployManifestChecker.verifyMainJar((DeploymentRuleSet)drs, (URL)cs.getLocation(), (!this._launchDesc.isSecure() ? 1 : 0) != 0, (AppInfo)this._launchDesc.getAppInfo());
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ExitException(cnfe, 3);
        }
        catch (IOException ioe) {
            throw new ExitException(ioe, 3);
        }
        catch (JNLPException je) {
            throw new ExitException(je, 3);
        }
        catch (Exception e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof ExitException)) continue;
                throw (ExitException)cause;
            }
            throw new ExitException(e, 3);
        }
        catch (Throwable t) {
            throw new ExitException(t, 3);
        }
        try {
            if (Globals.TCKHarnessRun) {
                Main.tckprintln("JNLP Launching");
            }
            this.executeMainClass(this._launchDesc, this._lap, mainClass, Progress.get(null));
        }
        catch (SecurityException se) {
            throw new ExitException(se, 3);
        }
        catch (InvocationTargetException ite) {
            Trace.ignored((Throwable)ite);
            Throwable cause = ite;
            while (((Throwable)cause).getCause() != null) {
                cause = ((Throwable)cause).getCause();
            }
            throw new ExitException(cause, 3);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExitException(nsme, 3);
        }
        catch (Throwable t) {
            throw new ExitException(t, 3);
        }
        if (this._launchDesc.getLaunchType() == 4) {
            throw new ExitException(null, 0);
        }
    }

    private void downloadResources(LaunchDesc ld, ArrayList<File> installFiles, boolean skipExtensions, boolean isInstaller) throws ExitException {
        LaunchDownload download = new LaunchDownload(ld);
        try {
            if (!this._shownDownloadWindow && !Globals.isSilentMode()) {
                this._shownDownloadWindow = true;
                PreloaderDelegate pl = Progress.get(null);
                pl.handleEvent((PreloaderEvent)new ConfigEvent(3, ld.getAppInfo()));
                if (!isInstaller) {
                    pl.handleEvent((PreloaderEvent)new InitEvent(4));
                }
            }
            if (!skipExtensions) {
                download.downloadExtensions(Progress.get(null), 0, installFiles);
            }
            LaunchDownload.checkJNLPSecurity(ld);
            boolean includingLazy = Environment.isImportMode();
            download.downloadEagerorAll(includingLazy, Progress.get(null), false);
        }
        catch (SecurityException se) {
            throw new ExitException(se, 3);
        }
        catch (JNLPException je) {
            throw new ExitException(je, 3);
        }
        catch (Exception e) {
            if (ld.getInformation().supportsOfflineOperation() && download.isInCache(skipExtensions)) {
                Trace.ignoredException((Exception)e);
            }
            throw new ExitException(e, 3);
        }
    }

    public void prepareSecurity(LaunchDesc ld) throws ExitException {
        try {
            LaunchDownload.checkJNLPSecurity(ld);
        }
        catch (SecurityException se) {
            throw new ExitException(se, 3);
        }
        catch (JNLPException je) {
            throw new ExitException(je, 3);
        }
    }

    public static void notifyLocalInstallHandler(LaunchDesc ld, LocalApplicationProperties lap, boolean silent, boolean updated, ComponentRef ownerRef) {
        LocalInstallHandler lih;
        if (lap == null) {
            return;
        }
        URL codebase = LaunchDescFactory.getDerivedCodebase();
        if (codebase != null) {
            lap.setCodebase(codebase.toString());
        }
        lap.setLastAccessed(new Date());
        if (!Environment.isImportMode() && !ld.isLibrary()) {
            lap.incrementLaunchCount();
        }
        if ((lih = LocalInstallHandler.getInstance()) != null) {
            lih.install(ld, lap, updated, silent, ownerRef);
        }
        try {
            lap.store();
        }
        catch (IOException ioe) {
            Trace.println((String)("Couldn't save LAP: " + ioe), (TraceLevel)TraceLevel.BASIC);
        }
    }

    private void executeMainClass(LaunchDesc ld, LocalApplicationProperties lap, Class mainclass, PreloaderDelegate dw) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        ld.getUpdater().startBackgroundUpdateOpt();
        this.executeApplication(ld, lap, mainclass, dw);
    }

    private void executeApplication(LaunchDesc ld, LocalApplicationProperties lap, Class mainclass, PreloaderDelegate dw) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        String[] args = null;
        if (ld.getLaunchType() == 4) {
            args = new String[]{lap.isExtensionInstalled() ? "uninstall" : "install"};
            lap.setExtensionInstalled(false);
            lap.setRebootNeeded(false);
            try {
                lap.store();
            }
            catch (IOException ioe) {
                Trace.ignoredException((Exception)ioe);
            }
        } else {
            String[] assocArgs;
            SplashScreen.hide();
            args = null;
            if (!ld.isFXApp()) {
                if (!ld.isSigned() && HtmlOptions.get() != null) {
                    args = HtmlOptions.get().getHtmlApplicationArgs();
                }
                if (args == null) {
                    args = ld.getApplicationDescriptor().getArguments();
                }
            }
            if ((assocArgs = Globals.getApplicationArgs()) != null) {
                args = assocArgs;
            }
        }
        Object[] wrappedArguments = new Object[]{args};
        Class[] main_type = new Class[]{new String[0].getClass()};
        Method mainMethod = mainclass.getMethod("main", main_type);
        if (!Modifier.isStatic(mainMethod.getModifiers())) {
            throw new NoSuchMethodException(ResourceManager.getString((String)"launch.error.nonstaticmainmethod"));
        }
        try {
            Progress.get(null).handleEvent((PreloaderEvent)new AppInitEvent(2));
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        mainMethod.invoke(null, wrappedArguments);
    }

    public void handleJnlpFileException(LaunchDesc ld, Exception exception) throws ExitException {
        Resource r = ResourceProvider.get().getCachedResource(ld.getCanonicalHome(), null);
        if (r != null) {
            ResourceProvider.get().markRetired(r, false);
        }
        throw new ExitException(exception, 3);
    }

    public void handleExitException(Throwable t) {
        int exitValue;
        ExitException ee = t instanceof ExitException ? (ExitException)t : new ExitException(t, 3);
        int n = exitValue = ee.getReason() == 0 || t instanceof BlockedException ? 0 : -1;
        if (!(t instanceof BlockedException)) {
            if (ee.getReason() == 3) {
                LaunchErrorDialog.show(Progress.get(null).getOwner(), ee.getException(), this._exit);
            } else if (ee.getReason() == 6) {
                LaunchErrorDialog.show(Progress.get(null).getOwner(), ee, this._exit);
            }
        }
        if (exitValue == 0) {
            Trace.println((String)"Exiting", (TraceLevel)TraceLevel.BASIC);
        } else {
            Trace.ignoredException((Exception)ee);
        }
        if (this._exit) {
            try {
                Main.systemExit(exitValue);
            }
            catch (ExitException ee2) {
                Trace.println((String)("systemExit: " + ee2), (TraceLevel)TraceLevel.BASIC);
                Trace.ignoredException((Exception)ee2);
            }
        }
    }

    public boolean handleCacheUpdateRequiredException(CacheUpdateRequiredException e, boolean tryOffline) {
        Trace.println((String)(ResourceManager.getString((String)"launch.error.cache") + " [" + e.getMessage() + "]"), (TraceLevel)TraceLevel.BASIC);
        if (tryOffline) {
            if (DeployOfflineManager.isForcedOffline()) {
                DeployOfflineManager.setForcedOffline((boolean)false);
                if (!DeployOfflineManager.askUserGoOnline((URL)this._initialLaunchDesc.getLocation())) {
                    DeployOfflineManager.setForcedOffline((boolean)true);
                    Trace.println((String)"User chose not to go online and we can not not start in offline mode");
                    LaunchErrorDialog.show(Progress.get(null).getOwner(), new OfflineLaunchException(0), this._exit);
                    return false;
                }
            } else if (!JnlpxArgs.getIsRelaunch()) {
                this._initialLaunchDesc = LaunchDescFactory.tryUpdateDescriptor(this._initialLaunchDesc);
            }
        }
        try {
            boolean ret = this.prepareToLaunch(false);
            return ret;
        }
        catch (CacheUpdateRequiredException ex) {
            Trace.println((String)("Unexpected exception: " + ex));
            return false;
        }
    }

    public boolean checkForSingleInstance() {
        if (!Environment.isImportMode() && this._initialLaunchDesc.getCanonicalHome() != null && SingleInstanceManager.isServerRunning((String)this._initialLaunchDesc.getCanonicalHome().toString())) {
            String[] appArgs = Globals.getApplicationArgs();
            if (appArgs == null && HtmlOptions.get() != null) {
                appArgs = HtmlOptions.get().getHtmlApplicationArgs();
            }
            if (appArgs != null && appArgs.length > 0 && this._initialLaunchDesc.getApplicationDescriptor() != null) {
                this._initialLaunchDesc.getApplicationDescriptor().setArguments(appArgs);
            }
            if (SingleInstanceManager.connectToServer((String)this._initialLaunchDesc.toString())) {
                JnlpxArgs.removeArgumentFile(this._args[0]);
                Trace.println((String)"Exiting (launched in the other instance)", (TraceLevel)TraceLevel.BASIC);
                try {
                    ToolkitStore.get().dispose();
                }
                catch (Exception e) {
                    Trace.ignoredException((Exception)e);
                }
                return true;
            }
        }
        return false;
    }

    public boolean tryOffline() {
        boolean tryOffline = Cache.isCacheEnabled() && (this._initialLaunchDesc.getUpdate().isBackgroundCheck() || DeployOfflineManager.isForcedOffline() || JnlpxArgs.getIsRelaunch());
        return tryOffline;
    }

    public LaunchDesc updateLaunchDesc(boolean offlineOnly) throws CacheUpdateRequiredException, ExitException {
        String appName;
        URL href;
        Trace.println((String)("prepareToLaunch: offlineOnly=" + offlineOnly), (TraceLevel)TraceLevel.NETWORK);
        try {
            this._isUpdated = this.updateFinalLaunchDesc(this._initialLaunchDesc, 0, offlineOnly);
        }
        catch (ExitException x) {
            boolean always = this._initialLaunchDesc.getUpdate().getCheck() == 0;
            boolean allow = this._initialLaunchDesc.getInformation().supportsOfflineOperation();
            if (offlineOnly || always || !allow) {
                throw x;
            }
            this._isUpdated = this.updateFinalLaunchDesc(this._initialLaunchDesc, 0, true);
        }
        if (this._launchDesc != null && this._launchDesc.isFXApp()) {
            ToolkitStore.setToolkitType((ToolkitStore.ToolkitType)ToolkitStore.ToolkitType.FX_TOOLKIT);
        }
        ToolkitStore.get().getAppContext().put((Object)"deploy-main-class", (Object)this._launchDesc.getMainClassName());
        this.removeTempJnlpFile(this._launchDesc);
        if (this._isUpdated && this._launchDesc.isApplicationDescriptor()) {
            Resource r = ResourceProvider.get().getCachedResource(this._launchDesc.getCanonicalHome(), null);
            File cachedJnlp = r != null ? r.getDataFile() : null;
            boolean hasHref = this._launchDesc.getLocation() != null;
            boolean tempFile = JnlpxArgs.shouldRemoveArgumentFile();
            if (Cache.isCacheEnabled() && (hasHref || tempFile) && this._args != null && cachedJnlp != null) {
                this._args[0] = cachedJnlp.getPath();
            }
        }
        boolean isInstaller = this._launchDesc.isInstaller();
        this._isRelaunch = JnlpxArgs.getIsRelaunch();
        URL jnlpUrl = this._launchDesc.getCanonicalHome();
        if (!isInstaller && !this._launchDesc.isLibrary()) {
            this._lap = Cache.getLocalApplicationProperties((URL)jnlpUrl);
            if (offlineOnly && this._lap != null && this._lap.forceUpdateCheck()) {
                throw new CacheUpdateRequiredException("Need to update: force update set in LAP");
            }
        }
        if (this._isUpdated && this._lap != null && Cache.isCacheEnabled() && this._lap.isShortcutInstalled() && LocalInstallHandler.getInstance() != null && LocalInstallHandler.getInstance().isShortcutExists(this._lap)) {
            Launcher.notifyLocalInstallHandler(this._launchDesc, this._lap, Globals.isSilentMode(), this._isUpdated, Progress.get(null).getOwnerRef());
        }
        if ((href = this._launchDesc.getLocation()) != null) {
            Cache.removeRemovedApp((String)href.toString(), (String)this._launchDesc.getInformation().getTitle());
        }
        Trace.println((String)("isUpdated: " + this._isUpdated), (TraceLevel)TraceLevel.NETWORK);
        if (this._launchDesc.getResources() != null) {
            Globals.getDebugOptionsFromProperties(this._launchDesc.getResources().getResourceProperties());
        }
        if (Config.getBooleanProperty((String)"deployment.security.authenticator")) {
            this._ja = JAuthenticator.getInstance(Progress.get(null).getOwnerRef());
            Authenticator.setDefault((Authenticator)((Object)this._ja));
        }
        if (this._lap != null) {
            String originalURL;
            URL codebase = LaunchDescFactory.getDerivedCodebase();
            if (codebase != null) {
                this._lap.setCodebase(codebase.toString());
            }
            if (this._args != null && this._args.length > 0 && ((originalURL = URLUtil.filterProtocols((String)this._args[0].toLowerCase())).startsWith("http://") || originalURL.startsWith("https://"))) {
                this._lap.setOriginalURL(this._args[0]);
            }
            try {
                this._lap.store();
            }
            catch (IOException ioe) {
                Trace.ignoredException((Exception)ioe);
            }
            String original = this._lap.getOriginalURL();
            if (original != null && this._launchDesc.getSourceURL() == null) {
                try {
                    this._launchDesc.setSourceURL(new URL(original));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (this.useAppletLifecycle()) {
            appName = this._launchDesc.getDocumentBase().toString() + ": " + this._launchDesc.getArgumentsString();
        } else {
            URL codebase = this._launchDesc.getCodebase();
            String string = appName = codebase != null ? codebase.toString() + ": " : "(no codebase): " + this._launchDesc.getMainClassName() + " " + this._launchDesc.getArgumentsString();
        }
        if (this._launchDesc.getSourceURL() != null) {
            appName = appName + " sourceURL=" + this._launchDesc.getSourceURL();
        }
        Config.getHooks().storeAppName(appName);
        return this._launchDesc;
    }

    public void initiateUpdateCheck() {
        String javawsCommand = Platform.get().getSystemJavawsPath();
        File cachedJNLPFile = ResourceProvider.get().getCachedJNLPFile(this._launchDesc.getCanonicalHome(), null);
        try {
            String[] stringArray;
            String arg2 = null;
            if (cachedJNLPFile != null) {
                arg2 = cachedJNLPFile.getCanonicalPath();
            } else if (this._launchDesc.getLocation() != null) {
                arg2 = this._launchDesc.getLocation().toString();
            }
            if (arg2 == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = javawsCommand;
                stringArray = stringArray2;
                stringArray2[1] = arg2;
            }
            String[] relaunchArgs = stringArray;
            Platform.get().getAutoUpdater().checkForUpdate(relaunchArgs);
        }
        catch (IOException ioe) {
            Trace.ignored((Throwable)ioe);
            Platform.get().getAutoUpdater().checkForUpdate(null);
        }
    }

    public class CacheUpdateRequiredException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CacheUpdateRequiredException(String message) {
            super(message);
        }
    }
}

